/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.applozic.mobicomkit.api.account.register.RegisterUserClientService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.MobiComMessageService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import java.util.Date;
import java.util.List;

public class SyncCallService {
    private static final String TAG = "SyncCall";
    public static boolean refreshView = false;
    private Context context;
    private static SyncCallService syncCallService;
    private MobiComMessageService mobiComMessageService;
    private MobiComConversationService mobiComConversationService;
    private BaseContactService contactService;
    private ChannelService channelService;

    private SyncCallService(Context context) {
        this.context = context;
        this.mobiComMessageService = new MobiComMessageService(context, MessageIntentService.class);
        this.mobiComConversationService = new MobiComConversationService(context);
        this.contactService = new AppContactService(context);
        this.channelService = ChannelService.getInstance(context);
    }

    public static synchronized SyncCallService getInstance(Context context) {
        if (syncCallService == null) {
            syncCallService = new SyncCallService(context);
        }
        return syncCallService;
    }

    public synchronized void updateDeliveryStatus(String key) {
        this.mobiComMessageService.updateDeliveryStatus(key, false);
        refreshView = true;
    }

    public synchronized void updateReadStatus(String key) {
        this.mobiComMessageService.updateDeliveryStatus(key, true);
        refreshView = true;
    }

    public synchronized List<Message> getLatestMessagesGroupByPeople() {
        return this.mobiComConversationService.getLatestMessagesGroupByPeople(null);
    }

    public synchronized List<Message> getLatestMessagesGroupByPeople(Long createdAt) {
        return this.mobiComConversationService.getLatestMessagesGroupByPeople(createdAt);
    }

    public synchronized void syncMessages(String key) {
        if (!TextUtils.isEmpty((CharSequence)key) && this.mobiComMessageService.isMessagePresent(key)) {
            Log.d((String)TAG, (String)"Message is already present, MQTT reached before GCM.");
        } else {
            this.mobiComMessageService.syncMessages();
        }
    }

    public synchronized void updateDeliveryStatusForContact(String contactId, boolean markRead) {
        this.mobiComMessageService.updateDeliveryStatusForContact(contactId, markRead);
    }

    public synchronized void updateConnectedStatus(String contactId, Date date, boolean connected) {
        this.contactService.updateConnectedStatus(contactId, date, connected);
    }

    public synchronized void deleteConversationThread(String userId) {
        this.mobiComConversationService.deleteConversationFromDevice(userId);
        refreshView = true;
    }

    public synchronized void deleteMessage(String messageKey) {
        this.mobiComConversationService.deleteMessageFromDevice(messageKey, null);
        refreshView = true;
    }

    public synchronized void updateUserBlocked(String userId, boolean userBlocked) {
        this.contactService.updateUserBlocked(userId, userBlocked);
    }

    public synchronized void updateUserBlockedBy(String userId, boolean userBlockedBy) {
        this.contactService.updateUserBlockedBy(userId, userBlockedBy);
    }

    public synchronized void updateUnreadCount(Contact contact, Channel channel) {
        this.mobiComConversationService.updateUnreadCount(contact, channel);
    }

    public void checkAccountStatus() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                new RegisterUserClientService(SyncCallService.this.context).syncAccountStatus();
            }
        }).start();
    }
}

