/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.attachment;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MarkStream
extends InputStream {
    private InputStream inputStream;
    private long offsetValue;
    private long resetValue;
    private long limit;
    private long defaultValue = -1L;

    public MarkStream(InputStream inputStream) {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        this.inputStream = inputStream;
    }

    @Override
    public void mark(int readLimit) {
        this.defaultValue = this.setPos(readLimit);
    }

    public long setPos(int readLimit) {
        long offsetLimit = this.offsetValue + (long)readLimit;
        if (this.limit < offsetLimit) {
            this.setLimit(offsetLimit);
        }
        return this.offsetValue;
    }

    private void setLimit(long limit) {
        try {
            if (this.resetValue < this.offsetValue && this.offsetValue <= this.limit) {
                this.inputStream.reset();
                this.inputStream.mark((int)(limit - this.resetValue));
                this.skipBytes(this.resetValue, this.offsetValue);
            } else {
                this.resetValue = this.offsetValue;
                this.inputStream.mark((int)(limit - this.offsetValue));
            }
            this.limit = limit;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to mark: " + e);
        }
    }

    @Override
    public void reset() throws IOException {
        this.resetPos(this.defaultValue);
    }

    public void resetPos(long token) throws IOException {
        if (this.offsetValue > this.limit || token < this.resetValue) {
            throw new IOException("Cannot reset the pos ");
        }
        this.inputStream.reset();
        this.skipBytes(this.resetValue, token);
        this.offsetValue = token;
    }

    private void skipBytes(long current, long pos) throws IOException {
        while (current < pos) {
            long skipped = this.inputStream.skip(pos - current);
            current += skipped;
        }
    }

    @Override
    public int read() throws IOException {
        int result = this.inputStream.read();
        if (result != -1) {
            ++this.offsetValue;
        }
        return result;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        int byteCount = this.inputStream.read(buffer);
        if (byteCount != -1) {
            this.offsetValue += (long)byteCount;
        }
        return byteCount;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int byteCount = this.inputStream.read(buffer, offset, length);
        if (byteCount != -1) {
            this.offsetValue += (long)byteCount;
        }
        return byteCount;
    }

    @Override
    public long skip(long byteCount) throws IOException {
        long skipped = this.inputStream.skip(byteCount);
        this.offsetValue += skipped;
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }
}

