/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.android.service;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.support.v4.content.LocalBroadcastManager;
import android.util.SparseArray;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.paho.android.service.MqttDeliveryTokenAndroid;
import org.eclipse.paho.android.service.MqttService;
import org.eclipse.paho.android.service.MqttServiceBinder;
import org.eclipse.paho.android.service.MqttTokenAndroid;
import org.eclipse.paho.android.service.MqttTraceHandler;
import org.eclipse.paho.android.service.ParcelableMqttMessage;
import org.eclipse.paho.android.service.Status;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;

public class MqttAndroidClient
extends BroadcastReceiver
implements IMqttAsyncClient {
    private static final String SERVICE_NAME = "org.eclipse.paho.android.service.MqttService";
    private static final int BIND_SERVICE_FLAG = 0;
    private static ExecutorService pool = Executors.newCachedThreadPool();
    private MyServiceConnection serviceConnection = new MyServiceConnection();
    private MqttService mqttService;
    private String clientHandle;
    Context myContext;
    private SparseArray<IMqttToken> tokenMap = new SparseArray();
    private int tokenNumber = 0;
    private String serverURI;
    private String clientId;
    private MqttClientPersistence persistence = null;
    private MqttConnectOptions connectOptions;
    private IMqttToken connectToken;
    private MqttCallback callback;
    private MqttTraceHandler traceCallback;
    private Ack messageAck;
    private boolean traceEnabled = false;
    private volatile boolean registerReceiver = false;
    private volatile boolean bindedService = false;

    public MqttAndroidClient(Context context, String serverURI, String clientId) {
        this(context, serverURI, clientId, null, Ack.AUTO_ACK);
    }

    public MqttAndroidClient(Context ctx, String serverURI, String clientId, Ack ackType) {
        this(ctx, serverURI, clientId, null, ackType);
    }

    public MqttAndroidClient(Context ctx, String serverURI, String clientId, MqttClientPersistence persistence) {
        this(ctx, serverURI, clientId, persistence, Ack.AUTO_ACK);
    }

    public MqttAndroidClient(Context context, String serverURI, String clientId, MqttClientPersistence persistence, Ack ackType) {
        this.myContext = context;
        this.serverURI = serverURI;
        this.clientId = clientId;
        this.persistence = persistence;
        this.messageAck = ackType;
    }

    public boolean isConnected() {
        if (this.mqttService != null) {
            return this.mqttService.isConnected(this.clientHandle);
        }
        return false;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getServerURI() {
        return this.serverURI;
    }

    public void close() {
        if (this.clientHandle == null) {
            this.clientHandle = this.mqttService.getClient(this.serverURI, this.clientId, this.myContext.getApplicationInfo().packageName, this.persistence);
        }
        this.mqttService.close(this.clientHandle);
    }

    public IMqttToken connect() throws MqttException {
        return this.connect(null, null);
    }

    public IMqttToken connect(MqttConnectOptions options) throws MqttException {
        return this.connect(options, null, null);
    }

    public IMqttToken connect(Object userContext, IMqttActionListener callback) throws MqttException {
        return this.connect(new MqttConnectOptions(), userContext, callback);
    }

    public IMqttToken connect(MqttConnectOptions options, Object userContext, IMqttActionListener callback) throws MqttException {
        MqttTokenAndroid token = new MqttTokenAndroid(this, userContext, callback);
        this.connectOptions = options;
        this.connectToken = token;
        if (this.mqttService == null) {
            IMqttActionListener listener;
            Intent serviceStartIntent = new Intent();
            serviceStartIntent.setClassName(this.myContext, SERVICE_NAME);
            ComponentName service = this.myContext.startService(serviceStartIntent);
            if (service == null && (listener = token.getActionCallback()) != null) {
                listener.onFailure((IMqttToken)token, (Throwable)new RuntimeException("cannot start service org.eclipse.paho.android.service.MqttService"));
            }
            this.myContext.startService(serviceStartIntent);
            this.myContext.bindService(serviceStartIntent, (ServiceConnection)this.serviceConnection, 1);
            this.registerReceiver(this);
        } else {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    MqttAndroidClient.this.doConnect();
                    MqttAndroidClient.this.registerReceiver(MqttAndroidClient.this);
                }
            });
        }
        return token;
    }

    private void registerReceiver(BroadcastReceiver receiver) {
        IntentFilter filter = new IntentFilter();
        filter.addAction("MqttService.callbackToActivity.v0");
        LocalBroadcastManager.getInstance((Context)this.myContext).registerReceiver(receiver, filter);
        this.registerReceiver = true;
    }

    private void doConnect() {
        block3: {
            if (this.clientHandle == null) {
                this.clientHandle = this.mqttService.getClient(this.serverURI, this.clientId, this.myContext.getApplicationInfo().packageName, this.persistence);
            }
            this.mqttService.setTraceEnabled(this.traceEnabled);
            this.mqttService.setTraceCallbackId(this.clientHandle);
            String activityToken = this.storeToken(this.connectToken);
            try {
                this.mqttService.connect(this.clientHandle, this.connectOptions, null, activityToken);
            }
            catch (MqttException e) {
                IMqttActionListener listener = this.connectToken.getActionCallback();
                if (listener == null) break block3;
                listener.onFailure(this.connectToken, (Throwable)e);
            }
        }
    }

    public IMqttToken disconnect() throws MqttException {
        MqttTokenAndroid token = new MqttTokenAndroid(this, null, null);
        String activityToken = this.storeToken(token);
        this.mqttService.disconnect(this.clientHandle, null, activityToken);
        return token;
    }

    public IMqttToken disconnect(long quiesceTimeout) throws MqttException {
        MqttTokenAndroid token = new MqttTokenAndroid(this, null, null);
        String activityToken = this.storeToken(token);
        this.mqttService.disconnect(this.clientHandle, quiesceTimeout, null, activityToken);
        return token;
    }

    public IMqttToken disconnect(Object userContext, IMqttActionListener callback) throws MqttException {
        MqttTokenAndroid token = new MqttTokenAndroid(this, userContext, callback);
        String activityToken = this.storeToken(token);
        this.mqttService.disconnect(this.clientHandle, null, activityToken);
        return token;
    }

    public IMqttToken disconnect(long quiesceTimeout, Object userContext, IMqttActionListener callback) throws MqttException {
        MqttTokenAndroid token = new MqttTokenAndroid(this, userContext, callback);
        String activityToken = this.storeToken(token);
        this.mqttService.disconnect(this.clientHandle, quiesceTimeout, null, activityToken);
        return token;
    }

    public IMqttDeliveryToken publish(String topic, byte[] payload, int qos, boolean retained) throws MqttException, MqttPersistenceException {
        return this.publish(topic, payload, qos, retained, null, null);
    }

    public IMqttDeliveryToken publish(String topic, MqttMessage message) throws MqttException, MqttPersistenceException {
        return this.publish(topic, message, null, null);
    }

    public IMqttDeliveryToken publish(String topic, byte[] payload, int qos, boolean retained, Object userContext, IMqttActionListener callback) throws MqttException, MqttPersistenceException {
        MqttMessage message = new MqttMessage(payload);
        message.setQos(qos);
        message.setRetained(retained);
        MqttDeliveryTokenAndroid token = new MqttDeliveryTokenAndroid(this, userContext, callback, message);
        String activityToken = this.storeToken(token);
        IMqttDeliveryToken internalToken = this.mqttService.publish(this.clientHandle, topic, payload, qos, retained, null, activityToken);
        token.setDelegate((IMqttToken)internalToken);
        return token;
    }

    public IMqttDeliveryToken publish(String topic, MqttMessage message, Object userContext, IMqttActionListener callback) throws MqttException, MqttPersistenceException {
        MqttDeliveryTokenAndroid token = new MqttDeliveryTokenAndroid(this, userContext, callback, message);
        String activityToken = this.storeToken(token);
        IMqttDeliveryToken internalToken = this.mqttService.publish(this.clientHandle, topic, message, null, activityToken);
        token.setDelegate((IMqttToken)internalToken);
        return token;
    }

    public IMqttToken subscribe(String topic, int qos) throws MqttException, MqttSecurityException {
        return this.subscribe(topic, qos, null, null);
    }

    public IMqttToken subscribe(String[] topic, int[] qos) throws MqttException, MqttSecurityException {
        return this.subscribe(topic, qos, null, null);
    }

    public IMqttToken subscribe(String topic, int qos, Object userContext, IMqttActionListener callback) throws MqttException {
        MqttTokenAndroid token = new MqttTokenAndroid(this, userContext, callback, new String[]{topic});
        String activityToken = this.storeToken(token);
        this.mqttService.subscribe(this.clientHandle, topic, qos, null, activityToken);
        return token;
    }

    public IMqttToken subscribe(String[] topic, int[] qos, Object userContext, IMqttActionListener callback) throws MqttException {
        MqttTokenAndroid token = new MqttTokenAndroid(this, userContext, callback, topic);
        String activityToken = this.storeToken(token);
        this.mqttService.subscribe(this.clientHandle, topic, qos, null, activityToken);
        return token;
    }

    public IMqttToken unsubscribe(String topic) throws MqttException {
        return this.unsubscribe(topic, null, null);
    }

    public IMqttToken unsubscribe(String[] topic) throws MqttException {
        return this.unsubscribe(topic, null, null);
    }

    public IMqttToken unsubscribe(String topic, Object userContext, IMqttActionListener callback) throws MqttException {
        MqttTokenAndroid token = new MqttTokenAndroid(this, userContext, callback);
        String activityToken = this.storeToken(token);
        this.mqttService.unsubscribe(this.clientHandle, topic, null, activityToken);
        return token;
    }

    public IMqttToken unsubscribe(String[] topic, Object userContext, IMqttActionListener callback) throws MqttException {
        MqttTokenAndroid token = new MqttTokenAndroid(this, userContext, callback);
        String activityToken = this.storeToken(token);
        this.mqttService.unsubscribe(this.clientHandle, topic, null, activityToken);
        return token;
    }

    public IMqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.mqttService.getPendingDeliveryTokens(this.clientHandle);
    }

    public void setCallback(MqttCallback callback) {
        this.callback = callback;
    }

    public void setTraceCallback(MqttTraceHandler traceCallback) {
        this.traceCallback = traceCallback;
    }

    public void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
        if (this.mqttService != null) {
            this.mqttService.setTraceEnabled(traceEnabled);
        }
    }

    public void onReceive(Context context, Intent intent) {
        Bundle data = intent.getExtras();
        String handleFromIntent = data.getString("MqttService.clientHandle");
        if (handleFromIntent == null || !handleFromIntent.equals(this.clientHandle)) {
            return;
        }
        String action = data.getString("MqttService.callbackAction");
        if ("connect".equals(action)) {
            this.connectAction(data);
        } else if ("messageArrived".equals(action)) {
            this.messageArrivedAction(data);
        } else if ("subscribe".equals(action)) {
            this.subscribeAction(data);
        } else if ("unsubscribe".equals(action)) {
            this.unSubscribeAction(data);
        } else if ("send".equals(action)) {
            this.sendAction(data);
        } else if ("messageDelivered".equals(action)) {
            this.messageDeliveredAction(data);
        } else if ("onConnectionLost".equals(action)) {
            this.connectionLostAction(data);
        } else if ("disconnect".equals(action)) {
            this.disconnected(data);
        } else if ("trace".equals(action)) {
            this.traceAction(data);
        } else {
            this.mqttService.traceError("MqttService", "Callback action doesn't exist.");
        }
    }

    public boolean acknowledgeMessage(String messageId) {
        if (this.messageAck == Ack.MANUAL_ACK) {
            Status status = this.mqttService.acknowledgeMessageArrival(this.clientHandle, messageId);
            return status == Status.OK;
        }
        return false;
    }

    private void connectAction(Bundle data) {
        IMqttToken token = this.connectToken;
        this.removeMqttToken(data);
        this.simpleAction(token, data);
    }

    private void disconnected(Bundle data) {
        this.clientHandle = null;
        IMqttToken token = this.removeMqttToken(data);
        if (token != null) {
            ((MqttTokenAndroid)token).notifyComplete();
        }
        if (this.callback != null) {
            this.callback.connectionLost(null);
        }
    }

    private void connectionLostAction(Bundle data) {
        if (this.callback != null) {
            Exception reason = (Exception)data.getSerializable("MqttService.exception");
            this.callback.connectionLost((Throwable)reason);
        }
    }

    private void simpleAction(IMqttToken token, Bundle data) {
        if (token != null) {
            Status status = (Status)((Object)data.getSerializable("MqttService.callbackStatus"));
            if (status == Status.OK) {
                ((MqttTokenAndroid)token).notifyComplete();
            } else {
                Exception exceptionThrown = (Exception)data.getSerializable("MqttService.exception");
                ((MqttTokenAndroid)token).notifyFailure(exceptionThrown);
            }
        } else {
            this.mqttService.traceError("MqttService", "simpleAction : token is null");
        }
    }

    private void sendAction(Bundle data) {
        IMqttToken token = this.getMqttToken(data);
        this.simpleAction(token, data);
    }

    private void subscribeAction(Bundle data) {
        IMqttToken token = this.removeMqttToken(data);
        this.simpleAction(token, data);
    }

    private void unSubscribeAction(Bundle data) {
        IMqttToken token = this.removeMqttToken(data);
        this.simpleAction(token, data);
    }

    private void messageDeliveredAction(Bundle data) {
        Status status;
        IMqttToken token = this.removeMqttToken(data);
        if (token != null && this.callback != null && (status = (Status)((Object)data.getSerializable("MqttService.callbackStatus"))) == Status.OK) {
            this.callback.deliveryComplete((IMqttDeliveryToken)token);
        }
    }

    private void messageArrivedAction(Bundle data) {
        if (this.callback != null) {
            String messageId = data.getString("MqttService.messageId");
            String destinationName = data.getString("MqttService.destinationName");
            ParcelableMqttMessage message = (ParcelableMqttMessage)data.getParcelable("MqttService.PARCEL");
            try {
                if (this.messageAck == Ack.AUTO_ACK) {
                    this.callback.messageArrived(destinationName, (MqttMessage)message);
                    this.mqttService.acknowledgeMessageArrival(this.clientHandle, messageId);
                } else {
                    message.messageId = messageId;
                    this.callback.messageArrived(destinationName, (MqttMessage)message);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void traceAction(Bundle data) {
        if (this.traceCallback != null) {
            String severity = data.getString("MqttService.traceSeverity");
            String message = data.getString("MqttService.errorMessage");
            String tag = data.getString("MqttService.traceTag");
            if ("debug".equals(severity)) {
                this.traceCallback.traceDebug(tag, message);
            } else if ("error".equals(severity)) {
                this.traceCallback.traceError(tag, message);
            } else {
                Exception e = (Exception)data.getSerializable("MqttService.exception");
                this.traceCallback.traceException(tag, message, e);
            }
        }
    }

    private synchronized String storeToken(IMqttToken token) {
        this.tokenMap.put(this.tokenNumber, (Object)token);
        return Integer.toString(this.tokenNumber++);
    }

    private synchronized IMqttToken removeMqttToken(Bundle data) {
        String activityToken = data.getString("MqttService.activityToken");
        if (activityToken != null) {
            int tokenNumber = Integer.parseInt(activityToken);
            IMqttToken token = (IMqttToken)this.tokenMap.get(tokenNumber);
            this.tokenMap.delete(tokenNumber);
            return token;
        }
        return null;
    }

    private synchronized IMqttToken getMqttToken(Bundle data) {
        String activityToken = data.getString("MqttService.activityToken");
        IMqttToken token = (IMqttToken)this.tokenMap.get(Integer.parseInt(activityToken));
        return token;
    }

    public SSLSocketFactory getSSLSocketFactory(InputStream keyStore, String password) throws MqttSecurityException {
        try {
            SSLContext ctx = null;
            SSLSocketFactory sslSockFactory = null;
            KeyStore ts = KeyStore.getInstance("BKS");
            ts.load(keyStore, password.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("X509");
            tmf.init(ts);
            TrustManager[] tm = tmf.getTrustManagers();
            ctx = SSLContext.getInstance("SSL");
            ctx.init(null, tm, null);
            sslSockFactory = ctx.getSocketFactory();
            return sslSockFactory;
        }
        catch (KeyStoreException e) {
            throw new MqttSecurityException((Throwable)e);
        }
        catch (CertificateException e) {
            throw new MqttSecurityException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new MqttSecurityException((Throwable)e);
        }
        catch (IOException e) {
            throw new MqttSecurityException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new MqttSecurityException((Throwable)e);
        }
        catch (KeyManagementException e) {
            throw new MqttSecurityException((Throwable)e);
        }
    }

    public void disconnectForcibly() throws MqttException {
        throw new UnsupportedOperationException();
    }

    public void disconnectForcibly(long disconnectTimeout) throws MqttException {
        throw new UnsupportedOperationException();
    }

    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout) throws MqttException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterResources() {
        if (this.myContext != null && this.registerReceiver) {
            MqttAndroidClient mqttAndroidClient = this;
            synchronized (mqttAndroidClient) {
                LocalBroadcastManager.getInstance((Context)this.myContext).unregisterReceiver((BroadcastReceiver)this);
                this.registerReceiver = false;
            }
            if (this.bindedService) {
                try {
                    this.myContext.unbindService((ServiceConnection)this.serviceConnection);
                    this.bindedService = false;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    public void registerResources(Context context) {
        if (context != null) {
            this.myContext = context;
            if (!this.registerReceiver) {
                this.registerReceiver(this);
            }
        }
    }

    public static enum Ack {
        AUTO_ACK,
        MANUAL_ACK;

    }

    private final class MyServiceConnection
    implements ServiceConnection {
        private MyServiceConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder binder) {
            MqttAndroidClient.this.mqttService = ((MqttServiceBinder)binder).getService();
            MqttAndroidClient.this.bindedService = true;
            MqttAndroidClient.this.doConnect();
        }

        public void onServiceDisconnected(ComponentName name) {
            MqttAndroidClient.this.mqttService = null;
        }
    }
}

