/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.notification;

import android.app.ActivityManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.RingtoneManager;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.TaskStackBuilder;
import android.text.TextUtils;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.notification.WearableNotificationWithVoice;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.ChannelUtils;
import com.applozic.mobicommons.people.contact.Contact;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.List;

public class NotificationService {
    private static final int NOTIFICATION_ID = 1000;
    private static final String NOTIFICATION_SMALL_ICON_METADATA = "com.applozic.mobicomkit.notification.smallIcon";
    private Context context;
    private int iconResourceId;
    private int wearable_action_title;
    private int wearable_action_label;
    private int wearable_send_icon;
    private AppContactService appContactService;
    private ApplozicClient applozicClient;
    private String activityToOpen;

    public NotificationService(int iconResourceID, Context context, int wearable_action_label, int wearable_action_title, int wearable_send_icon) {
        this.context = context;
        this.iconResourceId = iconResourceID;
        this.wearable_action_label = wearable_action_label;
        this.wearable_action_title = wearable_action_title;
        this.wearable_send_icon = wearable_send_icon;
        this.applozicClient = ApplozicClient.getInstance(context);
        this.appContactService = new AppContactService(context);
        this.activityToOpen = Utils.getMetaDataValue((Context)context, (String)"activity.open.on.notification");
    }

    public void notifyUser(Contact contact, Channel channel, Message message) {
        PendingIntent pendingIntent;
        String title;
        Contact displayNameContact = null;
        if (message.getGroupId() != null) {
            title = ChannelUtils.getChannelTitleName((Channel)channel, (String)MobiComUserPreference.getInstance(this.context).getUserId());
            displayNameContact = this.appContactService.getContactById(message.getTo());
        } else {
            title = contact.getDisplayName();
        }
        String notificationText = message.getContentType() == Message.ContentType.LOCATION.getValue().shortValue() ? "Location" : (message.getContentType() == Message.ContentType.AUDIO_MSG.getValue().shortValue() ? "Audio" : (message.getContentType() == Message.ContentType.VIDEO_MSG.getValue().shortValue() ? "Video" : (message.hasAttachment() && TextUtils.isEmpty((CharSequence)message.getMessage()) ? "Attachment" : message.getMessage())));
        Class<?> activity = null;
        try {
            activity = Class.forName(this.activityToOpen);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        Integer smallIconResourceId = Utils.getMetaDataValueForResources((Context)this.context, (String)NOTIFICATION_SMALL_ICON_METADATA) != null ? Utils.getMetaDataValueForResources((Context)this.context, (String)NOTIFICATION_SMALL_ICON_METADATA) : this.iconResourceId;
        Intent intent = new Intent(this.context, activity);
        intent.putExtra("message_json", GsonUtils.getJsonFromObject((Object)((Object)message), Message.class));
        if (this.applozicClient.isChatListOnNotificationIsHidden()) {
            intent.putExtra("takeOrder", true);
        }
        if (this.applozicClient.isContextBasedChat()) {
            intent.putExtra("contextBasedChat", true);
        }
        intent.putExtra("sms_body", "text");
        intent.setType("vnd.android-dir/mms-sms");
        TaskStackBuilder stackBuilder = TaskStackBuilder.create((Context)this.context);
        if (!this.isRunning(this.context)) {
            stackBuilder.addParentStack(activity);
            stackBuilder.addNextIntent(intent);
            pendingIntent = stackBuilder.getPendingIntent((int)(System.currentTimeMillis() & 0xFFFFFFFL), 0x8000000);
        } else {
            pendingIntent = PendingIntent.getActivity((Context)this.context, (int)((int)(System.currentTimeMillis() & 0xFFFFFFFL)), (Intent)intent, (int)0x8000000);
        }
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(this.context).setSmallIcon(smallIconResourceId.intValue()).setLargeIcon(BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)this.iconResourceId)).setCategory("msg").setPriority(2).setWhen(System.currentTimeMillis()).setContentTitle((CharSequence)title).setContentText((CharSequence)(channel != null ? displayNameContact.getDisplayName() + ": " + notificationText : notificationText)).setSound(RingtoneManager.getDefaultUri((int)2));
        mBuilder.setContentIntent(pendingIntent);
        mBuilder.setAutoCancel(true);
        if (message.hasAttachment()) {
            try {
                int response;
                FileMeta fileMeta = message.getFileMetas();
                HttpURLConnection httpConn = null;
                if (fileMeta.getThumbnailUrl() != null && (response = (httpConn = new MobiComKitClientService(this.context).openHttpConnection(fileMeta.getThumbnailUrl())).getResponseCode()) == 200) {
                    InputStream in = httpConn.getInputStream();
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)in);
                    String imageName = fileMeta.getBlobKeyString() + "." + FileUtils.getFileFormat((String)fileMeta.getName());
                    FileClientService.saveImageToInternalStorage(bitmap, imageName, this.context, fileMeta.getContentType());
                    mBuilder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(bitmap));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        WearableNotificationWithVoice notificationWithVoice = new WearableNotificationWithVoice(mBuilder, this.wearable_action_title, this.wearable_action_label, this.wearable_send_icon, message.getGroupId() != null ? String.valueOf(message.getGroupId()).hashCode() : message.getContactIds().hashCode());
        notificationWithVoice.setCurrentContext(this.context);
        notificationWithVoice.setPendingIntent(pendingIntent);
        try {
            notificationWithVoice.sendNotification();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isRunning(Context ctx) {
        try {
            ActivityManager activityManager = (ActivityManager)ctx.getSystemService("activity");
            List tasks = activityManager.getRunningTasks(Integer.MAX_VALUE);
            return tasks != null && tasks.size() > 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

