/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.UserClientService;
import com.applozic.mobicommons.commons.core.utils.DBUtils;

public class MobiComDatabaseHelper
extends SQLiteOpenHelper {
    public static final int DB_VERSION = 13;
    public static final String _ID = "_id";
    public static final String SMS_KEY_STRING = "smsKeyString";
    public static final String STORE_ON_DEVICE_COLUMN = "storeOnDevice";
    public static final String TO_FIELD = "toField";
    public static final String SMS = "sms";
    public static final String TIMESTAMP = "timeStamp";
    public static final String SMS_TYPE = "SMSType";
    public static final String TIME_TO_LIVE = "timeToLive";
    public static final String CONTACTID = "contactId";
    public static final String SCHEDULE_SMS_TABLE_NAME = "ScheduleSMS";
    public static final String SMS_TABLE_NAME = "sms";
    public static final String CONTACT_TABLE_NAME = "contact";
    public static final String FULL_NAME = "fullName";
    public static final String CONTACT_NO = "contactNO";
    public static final String DISPLAY_NAME = "displayName";
    public static final String CONTACT_IMAGE_LOCAL_URI = "contactImageLocalURI";
    public static final String CONTACT_IMAGE_URL = "contactImageURL";
    public static final String USERID = "userId";
    public static final String EMAIL = "email";
    public static final String APPLICATION_ID = "applicationId";
    public static final String CONNECTED = "connected";
    public static final String LAST_SEEN_AT_TIME = "lastSeenAt";
    public static final String MESSAGE_CONTENT_TYPE = "messageContentType";
    public static final String CONVERSATION_ID = "conversationId";
    public static final String TOPIC_ID = "topicId";
    public static final String CHANNEL_DISPLAY_NAME = "channelName";
    public static final String TYPE = "type";
    public static final String CHANNEL_KEY = "channelKey";
    public static final String USER_COUNT = "userCount";
    public static final String STATUS = "status";
    public static final String ADMIN_ID = "adminId";
    public static final String BLOCKED = "blocked";
    public static final String BLOCKED_BY = "blockedBy";
    public static final String UNREAD_COUNT = "unreadCount";
    public static final String TOPIC_DETAIL = "topicDetail";
    public static final String CREATED = "created";
    public static final String SENDER_USER_NAME = "senderUserName";
    public static final String CHANNEL = "channel";
    public static final String CHANNEL_USER_X = "channel_User_X";
    public static final String KEY = "key";
    public static final String CONVERSATION = "conversation";
    public static final String CREATE_SCHEDULE_SMS_TABLE = "create table ScheduleSMS( _id integer primary key autoincrement  ,sms text not null, timeStamp INTEGER ,toField varchar(20) not null, SMSType varchar(20) not null ,contactId varchar(20) , smsKeyString varChar(50), storeOnDevice INTEGER DEFAULT 1, source INTEGER, timeToLive integer) ;";
    public static final String CREATE_SMS_TABLE = "create table sms ( id integer primary key autoincrement, keyString var(100), toNumbers varchar(1000), contactNumbers varchar(2000), message text not null, type integer, read integer default 0, delivered integer default 0, storeOnDevice integer default 1, sentToServer integer default 1, createdAt integer, scheduledAt integer, source integer, timeToLive integer, fileMetaKeyStrings varchar(2000), filePaths varchar(2000), thumbnailUrl varchar(2000), size integer, name varchar(2000), contentType varchar(200), metaFileKeyString varchar(2000), blobKeyString varchar(2000), canceled integer default 0, deleted integer default 0,applicationId varchar(2000) null,messageContentType integer default 0,conversationId integer default 0,topicId varchar(300) null,channelKey integer default 0,status varchar(200) default 0,UNIQUE (keyString,contactNumbers,channelKey))";
    private static final String SMS_BACKUP = "sms_backup";
    public static final String INSERT_INTO_SMS_FROM_SMS_BACKUP_QUERY = "INSERT INTO sms (id,keyString,toNumbers,contactNumbers,message,type,read,delivered,storeOnDevice,sentToServer,createdAt,scheduledAt,source,timeToLive,fileMetaKeyStrings,filePaths,thumbnailUrl,size,name,contentType,metaFileKeyString,blobKeyString,canceled,deleted,applicationId,messageContentType,conversationId,topicId) SELECT id,keyString,toNumbers,contactNumbers,message,type,read,delivered,storeOnDevice,sentToServer,createdAt,scheduledAt,source,timeToLive,fileMetaKeyStrings,filePaths,thumbnailUrl,size,name,contentType,metaFileKeyString,blobKeyString,canceled,deleted,applicationId,messageContentType,conversationId,topicId FROM sms_backup";
    private static final String DROP_SMS_BACKUP = "DROP TABLE sms_backup";
    private static final String ALTER_SMS_TABLE_FOR_DELETE_COLUMN = "ALTER TABLE sms ADD COLUMN deleted integer default 0";
    private static final String ALTER_CONTACT_TABLE_FOR_APPLICATION_ID_COLUMN = "ALTER TABLE contact ADD COLUMN applicationId varchar(2000) null";
    private static final String ALTER_SMS_TABLE_FOR__APPLICATION_ID_COLUMN = "ALTER TABLE sms ADD COLUMN applicationId varchar(2000) null";
    private static final String ALTER_SMS_TABLE_FOR_CONTENT_TYPE_COLUMN = "ALTER TABLE sms ADD COLUMN messageContentType integer default 0";
    private static final String ALTER_CONTACT_TABLE_FOR_CONNECTED_COLUMN = "ALTER TABLE contact ADD COLUMN connected integer default 0";
    private static final String ALTER_CONTACT_TABLE_FOR_LAST_SEEN_AT_COLUMN = "ALTER TABLE contact ADD COLUMN lastSeenAt integer default 0";
    private static final String ALTER_MESSAGE_TABLE_FOR_CONVERSATION_ID_COLUMN = "ALTER TABLE sms ADD COLUMN conversationId integer default 0";
    private static final String ALTER_MESSAGE_TABLE_FOR_TOPIC_ID_COLUMN = "ALTER TABLE sms ADD COLUMN topicId varchar(300) null";
    private static final String ALTER_CONTACT_TABLE_UNREAD_COUNT_COLUMN = "ALTER TABLE contact ADD COLUMN unreadCount integer default 0";
    private static final String ALTER_CHANNEL_TABLE_UNREAD_COUNT_COLUMN = "ALTER TABLE channel ADD COLUMN unreadCount integer default 0";
    private static final String ALTER_CONTACT_TABLE_BLOCKED_COLUMN = "ALTER TABLE contact ADD COLUMN blocked integer default 0";
    private static final String ALTER_CONTACT_TABLE_BLOCKED_BY_COLUMN = "ALTER TABLE contact ADD COLUMN blockedBy integer default 0";
    private static final String ALTER_SMS_TABLE = "ALTER TABLE sms RENAME TO sms_backup";
    private static final String CREATE_CONTACT_TABLE = " CREATE TABLE contact ( userId VARCHAR(50) primary key, fullName VARCHAR(200), contactNO VARCHAR(15), displayName VARCHAR(25), contactImageURL VARCHAR(200), contactImageLocalURI VARCHAR(200), email VARCHAR(100), applicationId VARCHAR(2000) null, connected integer default 0,lastSeenAt integer, unreadCount integer default 0,blocked integer default 0, blockedBy integer default 0  ) ";
    private static final String CREATE_CHANNEL_TABLE = " CREATE TABLE channel ( _id integer primary key autoincrement, channelKey integer , channelName varchar(200), adminId varchar(100), type integer default 0, unreadCount integer default 0, userCountinteger  )";
    private static final String CREATE_CHANNEL_USER_X_TABLE = " CREATE TABLE channel_User_X ( _id integer primary key autoincrement, channelKey integer , userId varchar(100), unreadCount integer, status integer, UNIQUE (channelKey, userId))";
    private static final String CREATE_CONVERSATION_TABLE = " CREATE TABLE conversation ( _id integer primary key autoincrement, key integer , topicId varchar(100) , userId varchar(100) ,channelKey integer ,topicDetail varchar(2500))";
    private static final String CREATE_INDEX_SMS_TYPE = "CREATE INDEX IF NOT EXISTS INDEX_SMS_TYPE ON sms (type)";
    private static final String TAG = "MobiComDatabaseHelper";
    private static MobiComDatabaseHelper sInstance;
    private Context context;

    private MobiComDatabaseHelper(Context context) {
        this(context, "MCK_" + MobiComKitClientService.getApplicationKey(context), null, 13);
        this.context = context;
    }

    public MobiComDatabaseHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, name, factory, version);
    }

    public static MobiComDatabaseHelper getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new MobiComDatabaseHelper(context.getApplicationContext());
        }
        return sInstance;
    }

    public void onCreate(SQLiteDatabase database) {
        if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)"sms")) {
            database.execSQL(CREATE_SMS_TABLE);
        }
        if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)SCHEDULE_SMS_TABLE_NAME)) {
            database.execSQL(CREATE_SCHEDULE_SMS_TABLE);
        }
        if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME)) {
            database.execSQL(CREATE_CONTACT_TABLE);
        }
        if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)CHANNEL)) {
            database.execSQL(CREATE_CHANNEL_TABLE);
        }
        if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)CONVERSATION)) {
            database.execSQL(CREATE_CONVERSATION_TABLE);
        }
        if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)CHANNEL_USER_X)) {
            database.execSQL(CREATE_CHANNEL_USER_X_TABLE);
        }
        database.execSQL(CREATE_INDEX_SMS_TYPE);
    }

    public void onUpgrade(SQLiteDatabase database, int oldVersion, int newVersion) {
        if (newVersion > oldVersion) {
            Log.i((String)TAG, (String)("Upgrading database from version " + oldVersion + " to " + newVersion + ", which will destroy all old data"));
            if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)"sms")) {
                database.execSQL(CREATE_SMS_TABLE);
            }
            if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)SCHEDULE_SMS_TABLE_NAME)) {
                database.execSQL(CREATE_SCHEDULE_SMS_TABLE);
            }
            if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)CHANNEL)) {
                database.execSQL(CREATE_CHANNEL_TABLE);
            }
            if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)CHANNEL_USER_X)) {
                database.execSQL(CREATE_CHANNEL_USER_X_TABLE);
            }
            if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)CONVERSATION)) {
                database.execSQL(CREATE_CONVERSATION_TABLE);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)"sms", (String)"deleted")) {
                database.execSQL(ALTER_SMS_TABLE_FOR_DELETE_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)"sms", (String)APPLICATION_ID)) {
                database.execSQL(ALTER_SMS_TABLE_FOR__APPLICATION_ID_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)APPLICATION_ID)) {
                database.execSQL(ALTER_CONTACT_TABLE_FOR_APPLICATION_ID_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)UNREAD_COUNT)) {
                database.execSQL(ALTER_CONTACT_TABLE_UNREAD_COUNT_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)CONNECTED)) {
                database.execSQL(ALTER_CONTACT_TABLE_FOR_CONNECTED_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)LAST_SEEN_AT_TIME)) {
                database.execSQL(ALTER_CONTACT_TABLE_FOR_LAST_SEEN_AT_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)BLOCKED)) {
                database.execSQL(ALTER_CONTACT_TABLE_BLOCKED_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)BLOCKED_BY)) {
                database.execSQL(ALTER_CONTACT_TABLE_BLOCKED_BY_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)"sms", (String)MESSAGE_CONTENT_TYPE)) {
                database.execSQL(ALTER_SMS_TABLE_FOR_CONTENT_TYPE_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)"sms", (String)CONVERSATION_ID)) {
                database.execSQL(ALTER_MESSAGE_TABLE_FOR_CONVERSATION_ID_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)"sms", (String)TOPIC_ID)) {
                database.execSQL(ALTER_MESSAGE_TABLE_FOR_TOPIC_ID_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CHANNEL, (String)UNREAD_COUNT)) {
                database.execSQL(ALTER_CHANNEL_TABLE_UNREAD_COUNT_COLUMN);
            }
            database.execSQL(CREATE_INDEX_SMS_TYPE);
            database.execSQL(ALTER_SMS_TABLE);
            database.execSQL(CREATE_SMS_TABLE);
            database.execSQL(INSERT_INTO_SMS_FROM_SMS_BACKUP_QUERY);
            database.execSQL(DROP_SMS_BACKUP);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        new UserClientService(MobiComDatabaseHelper.this.context).updateCodeVersion(MobiComUserPreference.getInstance(MobiComDatabaseHelper.this.context).getDeviceKeyString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
        } else {
            this.onCreate(database);
        }
    }

    public synchronized void close() {
    }

    public int delDatabase() {
        SQLiteDatabase db = this.getWritableDatabase();
        db.execSQL("delete from ScheduleSMS");
        db.execSQL("delete from sms");
        db.execSQL("delete from contact");
        db.execSQL("delete from channel");
        db.execSQL("delete from channel_User_X");
        db.execSQL("delete from conversation");
        return 0;
    }
}

