/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.channel.service;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.applozic.mobicomkit.api.HttpRequestUtils;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.people.ChannelCreate;
import com.applozic.mobicomkit.channel.database.ChannelDatabaseService;
import com.applozic.mobicomkit.feed.ApiResponse;
import com.applozic.mobicomkit.feed.ChannelFeed;
import com.applozic.mobicomkit.feed.ChannelFeedApiResponse;
import com.applozic.mobicomkit.feed.ChannelName;
import com.applozic.mobicomkit.sync.SyncChannelFeed;
import com.applozic.mobicommons.json.GsonUtils;
import java.net.URLEncoder;

public class ChannelClientService
extends MobiComKitClientService {
    private static final String CHANNEL_INFO_URL = "/rest/ws/group/info";
    private static final String CHANNEL_SYNC_URL = "/rest/ws/group/list";
    private static final String CREATE_CHANNEL_URL = "/rest/ws/group/create";
    private static final String ADD_MEMBER_TO_CHANNEL_URL = "/rest/ws/group/add/member";
    private static final String REMOVE_MEMBER_FROM_CHANNEL_URL = "/rest/ws/group/remove/member";
    private static final String CHANNEL_NAME_CHANGE_URL = "/rest/ws/group/change/name";
    private static final String CHANNEL_LEFT_URL = "/rest/ws/group/left";
    private static final String UPDATED_AT = "updatedAt";
    private static final String USER_ID = "userId";
    private static final String NEW_CHANNEL_NAME = "newName";
    private static final String GROUP_ID = "groupId";
    private static final String TAG = "ChannelClientService";
    private static ChannelClientService channelClientService;
    private Context context;
    private ChannelDatabaseService channelDatabaseService;
    private HttpRequestUtils httpRequestUtils;

    private ChannelClientService(Context context) {
        super(context);
        this.context = context;
        this.channelDatabaseService = ChannelDatabaseService.getInstance(context);
        this.httpRequestUtils = new HttpRequestUtils(context);
    }

    public static ChannelClientService getInstance(Context context) {
        if (channelClientService == null) {
            channelClientService = new ChannelClientService(context);
        }
        return channelClientService;
    }

    public String getChannelInfoUrl() {
        return this.getBaseUrl() + CHANNEL_INFO_URL;
    }

    public String getChannelSyncUrl() {
        return this.getBaseUrl() + CHANNEL_SYNC_URL;
    }

    public String getCreateChannelUrl() {
        return this.getBaseUrl() + CREATE_CHANNEL_URL;
    }

    public String getAddMemberToGroup() {
        return this.getBaseUrl() + ADD_MEMBER_TO_CHANNEL_URL;
    }

    public String getRemoveMemberUrl() {
        return this.getBaseUrl() + REMOVE_MEMBER_FROM_CHANNEL_URL;
    }

    public String getUpdateNewChannelNameUrl() {
        return this.getBaseUrl() + CHANNEL_NAME_CHANGE_URL;
    }

    public String getChannelLeftUrl() {
        return this.getBaseUrl() + CHANNEL_LEFT_URL;
    }

    public ChannelFeed getChannelInfo(Integer channelKey) {
        String response = "";
        try {
            response = this.httpRequestUtils.getResponse(this.getCredentials(), this.getChannelInfoUrl() + "?groupId=" + channelKey, "application/json", "application/json");
            ChannelFeedApiResponse channelFeedApiResponse = (ChannelFeedApiResponse)GsonUtils.getObjectFromJson((String)response, ChannelFeedApiResponse.class);
            Log.i((String)TAG, (String)("Channel info response  is :" + response));
            if (channelFeedApiResponse != null && channelFeedApiResponse.isSuccess()) {
                ChannelFeed channelFeed = channelFeedApiResponse.getResponse();
                return channelFeed;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public SyncChannelFeed getChannelFeed(String lastChannelSyncTime) {
        String url = this.getChannelSyncUrl() + "?" + UPDATED_AT + "=" + lastChannelSyncTime;
        try {
            String response = this.httpRequestUtils.getResponse(this.getCredentials(), url, "application/json", "application/json");
            Log.i((String)TAG, (String)("Channel sync call response: " + response));
            return (SyncChannelFeed)GsonUtils.getObjectFromJson((String)response, SyncChannelFeed.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ChannelFeed createChannel(ChannelCreate channelCreate) {
        ChannelFeed channelFeed = null;
        try {
            String jsonFromObject = GsonUtils.getJsonFromObject((Object)channelCreate, channelCreate.getClass());
            String createChannelResponse = this.httpRequestUtils.postData(this.getCredentials(), this.getCreateChannelUrl(), "application/json", "application/json", jsonFromObject);
            Log.i((String)TAG, (String)("Create channel Response :" + createChannelResponse));
            ChannelFeedApiResponse channelFeedApiResponse = (ChannelFeedApiResponse)GsonUtils.getObjectFromJson((String)createChannelResponse, ChannelFeedApiResponse.class);
            if (channelFeedApiResponse != null && channelFeedApiResponse.isSuccess()) {
                channelFeed = channelFeedApiResponse.getResponse();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return channelFeed;
    }

    public synchronized ApiResponse addMemberToChannel(Integer channelKey, String userId) {
        ApiResponse apiResponse = null;
        try {
            if (channelKey != null && !TextUtils.isEmpty((CharSequence)userId)) {
                String url = this.getAddMemberToGroup() + "?" + GROUP_ID + "=" + URLEncoder.encode(String.valueOf(channelKey), "UTF-8") + "&" + USER_ID + "=" + URLEncoder.encode(userId, "UTF-8");
                String response = this.httpRequestUtils.getResponse(this.getCredentials(), url, "application/json", "application/json");
                apiResponse = (ApiResponse)GsonUtils.getObjectFromJson((String)response, ApiResponse.class);
                if (apiResponse != null) {
                    Log.i((String)TAG, (String)("Channel add member call response: " + apiResponse.getStatus()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return apiResponse;
    }

    public synchronized ApiResponse removeMemberFromChannel(Integer channelKey, String userId) {
        ApiResponse apiResponse = null;
        try {
            if (channelKey != null && !TextUtils.isEmpty((CharSequence)userId)) {
                String url = this.getRemoveMemberUrl() + "?" + GROUP_ID + "=" + URLEncoder.encode(String.valueOf(channelKey), "UTF-8") + "&" + USER_ID + "=" + URLEncoder.encode(userId, "UTF-8");
                String response = this.httpRequestUtils.getResponse(this.getCredentials(), url, "application/json", "application/json");
                apiResponse = (ApiResponse)GsonUtils.getObjectFromJson((String)response, ApiResponse.class);
                if (apiResponse != null) {
                    Log.i((String)TAG, (String)("Channel remove member response: " + apiResponse.getStatus()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return apiResponse;
    }

    public synchronized ApiResponse updateChannelName(ChannelName channelName) {
        ApiResponse apiResponse = null;
        try {
            if (channelName != null && channelName.getGroupId() != null && !TextUtils.isEmpty((CharSequence)channelName.getNewName())) {
                String channelNameUpdateJson = GsonUtils.getJsonFromObject((Object)channelName, ChannelName.class);
                String response = this.httpRequestUtils.postData(this.getCredentials(), this.getUpdateNewChannelNameUrl(), "application/json", "application/json", channelNameUpdateJson);
                apiResponse = (ApiResponse)GsonUtils.getObjectFromJson((String)response, ApiResponse.class);
                if (apiResponse != null) {
                    Log.i((String)TAG, (String)("Update Channel name response: " + apiResponse.getStatus()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return apiResponse;
    }

    public synchronized ApiResponse leaveMemberFromChannel(Integer channelKey) {
        ApiResponse apiResponse = null;
        try {
            if (channelKey != null) {
                String url = this.getChannelLeftUrl() + "?" + GROUP_ID + "=" + URLEncoder.encode(String.valueOf(channelKey), "UTF-8");
                String response = this.httpRequestUtils.getResponse(this.getCredentials(), url, "application/json", "application/json");
                apiResponse = (ApiResponse)GsonUtils.getObjectFromJson((String)response, ApiResponse.class);
                if (apiResponse != null) {
                    Log.i((String)TAG, (String)("Channel leave member call response: " + apiResponse.getStatus()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return apiResponse;
    }
}

