/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation.service;

import android.content.Context;
import android.util.Log;
import com.applozic.mobicomkit.api.HttpRequestUtils;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.conversation.database.ConversationDatabaseService;
import com.applozic.mobicomkit.feed.ApiResponse;
import com.applozic.mobicomkit.feed.ChannelFeed;
import com.applozic.mobicomkit.feed.ChannelFeedApiResponse;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Conversation;

public class ConversationClientService
extends MobiComKitClientService {
    private static final String CREATE_CONVERSATION_URL = "/rest/ws/conversation/id";
    private static final String CONVERSATION_URL = "/rest/ws/conversation/topicId";
    private static final String TAG = "ConversationClient";
    private static ConversationClientService conversationClientService;
    private Context context;
    private ConversationDatabaseService conversationDatabaseService;
    private HttpRequestUtils httpRequestUtils;

    private ConversationClientService(Context context) {
        super(context);
        this.context = context;
        this.httpRequestUtils = new HttpRequestUtils(context);
    }

    public static synchronized ConversationClientService getInstance(Context context) {
        if (conversationClientService == null) {
            conversationClientService = new ConversationClientService(context);
        }
        return conversationClientService;
    }

    public String getCreateConversationUrl() {
        return this.getBaseUrl() + CREATE_CONVERSATION_URL;
    }

    public String getConversationUrl() {
        return this.getBaseUrl() + CONVERSATION_URL;
    }

    public ChannelFeed createConversation(Conversation conversation) {
        ChannelFeed channelFeed = null;
        try {
            String jsonFromObject = GsonUtils.getJsonFromObject((Object)conversation, conversation.getClass());
            String createChannelResponse = this.httpRequestUtils.postData(this.getCredentials(), this.getCreateConversationUrl(), "application/json", "application/json", jsonFromObject);
            Log.i((String)TAG, (String)("Create Conversation reponse:" + createChannelResponse));
            ChannelFeedApiResponse channelFeedApiResponse = (ChannelFeedApiResponse)GsonUtils.getObjectFromJson((String)createChannelResponse, ChannelFeedApiResponse.class);
            if (channelFeedApiResponse != null && channelFeedApiResponse.isSuccess()) {
                channelFeed = channelFeedApiResponse.getResponse();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return channelFeed;
    }

    public Conversation getConversation(Integer conversationId) {
        String response = "";
        try {
            if (conversationId != null) {
                response = this.httpRequestUtils.getResponse(this.getCredentials(), this.getConversationUrl() + "?id=" + String.valueOf(conversationId), "application/json", "application/json");
                ApiResponse apiResponse = (ApiResponse)GsonUtils.getObjectFromJson((String)response, ApiResponse.class);
                Log.i((String)TAG, (String)("Conversation response  is :" + response));
                if (apiResponse != null && apiResponse.isSuccess()) {
                    return (Conversation)apiResponse.getResponse();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

