/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.account.register;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import com.applozic.mobicomkit.api.HttpRequestUtils;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.register.RegistrationResponse;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.User;
import com.applozic.mobicomkit.api.conversation.ApplozicMqttIntentService;
import com.applozic.mobicomkit.api.conversation.SyncCallService;
import com.applozic.mobicomkit.exception.InvalidApplicationException;
import com.applozic.mobicomkit.exception.UnAuthoriseException;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.google.gson.Gson;
import java.net.ConnectException;
import java.util.TimeZone;

public class RegisterUserClientService
extends MobiComKitClientService {
    public static final String CREATE_ACCOUNT_URL = "/rest/ws/register/client?";
    public static final Short MOBICOMKIT_VERSION_CODE = 106;
    private static final String TAG = "RegisterUserClient";
    private static final String INVALID_APP_ID = "INVALID_APPLICATIONID";
    private HttpRequestUtils httpRequestUtils;

    public RegisterUserClientService(Context context) {
        this.context = context;
        this.httpRequestUtils = new HttpRequestUtils(context);
    }

    public String getCreateAccountUrl() {
        return this.getBaseUrl() + CREATE_ACCOUNT_URL;
    }

    public RegistrationResponse createAccount(User user) throws Exception {
        user.setDeviceType(Short.valueOf("1"));
        user.setPrefContactAPI(Short.valueOf("2"));
        user.setTimezone(TimeZone.getDefault().getID());
        MobiComUserPreference mobiComUserPreference = MobiComUserPreference.getInstance(this.context);
        Gson gson = new Gson();
        user.setAppVersionCode(MOBICOMKIT_VERSION_CODE);
        user.setApplicationId(RegisterUserClientService.getApplicationKey(this.context));
        user.setRegistrationId(mobiComUserPreference.getDeviceRegistrationId());
        if (RegisterUserClientService.getAppModuleName(this.context) != null) {
            user.setAppModuleName(RegisterUserClientService.getAppModuleName(this.context));
        }
        Log.i((String)TAG, (String)("Net status" + Utils.isInternetAvailable((Context)this.context)));
        if (!Utils.isInternetAvailable((Context)this.context)) {
            throw new ConnectException("No Internet Connection");
        }
        Log.i((String)TAG, (String)("Registration json " + gson.toJson((Object)user)));
        String response = this.httpRequestUtils.postJsonToServer(this.getCreateAccountUrl(), gson.toJson((Object)user));
        Log.i((String)TAG, (String)("Registration response is: " + response));
        if (TextUtils.isEmpty((CharSequence)response) || response.contains("<html")) {
            throw new Exception("503 Service Unavailable");
        }
        if (response.contains(INVALID_APP_ID)) {
            throw new InvalidApplicationException("Invalid Application Id");
        }
        RegistrationResponse registrationResponse = (RegistrationResponse)gson.fromJson(response, RegistrationResponse.class);
        if (registrationResponse.isPasswordInvalid()) {
            throw new UnAuthoriseException("Invalid uername/password");
        }
        Log.i((String)"Registration response ", (String)("is " + registrationResponse));
        if (registrationResponse.getNotificationResponse() != null) {
            Log.e((String)"Registration response ", (String)("" + registrationResponse.getNotificationResponse()));
        }
        mobiComUserPreference.setCountryCode(user.getCountryCode());
        mobiComUserPreference.setUserId(user.getUserId());
        mobiComUserPreference.setContactNumber(user.getContactNumber());
        mobiComUserPreference.setEmailVerified(user.isEmailVerified());
        mobiComUserPreference.setDisplayName(user.getDisplayName());
        mobiComUserPreference.setMqttBrokerUrl(registrationResponse.getBrokerUrl());
        mobiComUserPreference.setDeviceKeyString(registrationResponse.getDeviceKey());
        mobiComUserPreference.setEmailIdValue(user.getEmail());
        mobiComUserPreference.setImageLink(user.getImageLink());
        mobiComUserPreference.setSuUserKeyString(registrationResponse.getUserKey());
        mobiComUserPreference.setLastSyncTime(String.valueOf(registrationResponse.getCurrentTimeStamp()));
        mobiComUserPreference.setLastSeenAtSyncTime(String.valueOf(registrationResponse.getCurrentTimeStamp()));
        mobiComUserPreference.setChannelSyncTime(String.valueOf(registrationResponse.getCurrentTimeStamp()));
        mobiComUserPreference.setUserBlockSyncTime("10000");
        mobiComUserPreference.setPassword(user.getPassword());
        mobiComUserPreference.setAuthenticationType(String.valueOf(user.getAuthenticationTypeId()));
        new Thread(new Runnable(){

            @Override
            public void run() {
                SyncCallService.getInstance(RegisterUserClientService.this.context).getLatestMessagesGroupByPeople();
            }
        }).start();
        Intent intent = new Intent(this.context, ApplozicMqttIntentService.class);
        intent.putExtra("connectedPublish", true);
        this.context.startService(intent);
        return registrationResponse;
    }

    public RegistrationResponse createAccount(String email, String userId, String phoneNumber, String displayName, String imageLink, String pushNotificationId) throws Exception {
        MobiComUserPreference mobiComUserPreference = MobiComUserPreference.getInstance(this.context);
        String url = mobiComUserPreference.getUrl();
        mobiComUserPreference.clearAll();
        mobiComUserPreference.setUrl(url);
        return this.updateAccount(email, userId, phoneNumber, displayName, imageLink, pushNotificationId);
    }

    private RegistrationResponse updateAccount(String email, String userId, String phoneNumber, String displayName, String imageLink, String pushNotificationId) throws Exception {
        MobiComUserPreference mobiComUserPreference = MobiComUserPreference.getInstance(this.context);
        User user = new User();
        user.setUserId(userId);
        user.setEmail(email);
        user.setImageLink(imageLink);
        user.setRegistrationId(pushNotificationId);
        user.setDisplayName(displayName);
        user.setContactNumber(phoneNumber);
        RegistrationResponse registrationResponse = this.createAccount(user);
        Intent intent = new Intent(this.context, ApplozicMqttIntentService.class);
        intent.putExtra("connectedPublish", true);
        this.context.startService(intent);
        return registrationResponse;
    }

    public RegistrationResponse updatePushNotificationId(String pushNotificationId) throws Exception {
        MobiComUserPreference pref = MobiComUserPreference.getInstance(this.context);
        RegistrationResponse registrationResponse = null;
        User user = this.getUserDetail();
        if (!TextUtils.isEmpty((CharSequence)pushNotificationId)) {
            pref.setDeviceRegistrationId(pushNotificationId);
        }
        user.setRegistrationId(pushNotificationId);
        if (pref.isRegistered()) {
            registrationResponse = this.createAccount(user);
        }
        return registrationResponse;
    }

    private User getUserDetail() {
        MobiComUserPreference pref = MobiComUserPreference.getInstance(this.context);
        User user = new User();
        user.setEmail(pref.getEmailIdValue());
        user.setUserId(pref.getUserId());
        user.setContactNumber(pref.getContactNumber());
        user.setDisplayName(pref.getDisplayName());
        user.setImageLink(pref.getImageLink());
        user.setPassword(pref.getPassword());
        user.setAuthenticationTypeId(Short.valueOf(pref.getAuthenticationType()));
        return user;
    }
}

