/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api;

import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;

public class HttpRequestUtils {
    private Context context;
    private static final String TAG = "HttpRequestUtils";
    private static String SOURCE_HEADER = "Source";
    private static String SOURCE_HEADER_VALUE = "1";
    public static String APPLICATION_KEY_HEADER = "Application-Key";
    public static String USERID_HEADER = "UserId-Enabled";
    public static String USERID_HEADER_VALUE = "true";
    public static String DEVICE_KEY_HEADER = "Device-Key";
    public static String APP_MODULE_NAME_KEY_HEADER = "App-Module-Name";

    public HttpRequestUtils(Context context) {
        this.context = context;
    }

    private void log(String message) {
        Log.i((String)TAG, (String)message);
    }

    public String postData(PasswordAuthentication credentials, String urlString, String contentType, String accept, String data) {
        Log.i((String)TAG, (String)("Calling url: " + urlString));
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            if (!TextUtils.isEmpty((CharSequence)contentType)) {
                connection.setRequestProperty("Content-Type", contentType);
            }
            if (!TextUtils.isEmpty((CharSequence)accept)) {
                connection.setRequestProperty("Accept", accept);
            }
            this.addGlobalHeaders(connection);
            connection.connect();
            if (connection == null) {
                return null;
            }
            byte[] dataBytes = data.getBytes("UTF-8");
            DataOutputStream os = new DataOutputStream(connection.getOutputStream());
            os.write(dataBytes);
            os.flush();
            os.close();
            BufferedReader br = null;
            if (connection.getResponseCode() == 200) {
                InputStream inputStream = connection.getInputStream();
                br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            }
            StringBuilder sb = new StringBuilder();
            try {
                if (br != null) {
                    String line;
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Log.i((String)TAG, (String)("Response: " + sb.toString()));
            return sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.e((String)TAG, (String)"Http call failed");
        return null;
    }

    public String getStringFromUrl(String url) throws Exception {
        return null;
    }

    public String postJsonToServer(String StringUrl, String data) throws Exception {
        URL url = new URL(StringUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.connect();
        byte[] dataBytes = data.getBytes("UTF-8");
        DataOutputStream os = new DataOutputStream(connection.getOutputStream());
        os.write(dataBytes);
        os.flush();
        os.close();
        BufferedReader br = null;
        if (connection.getResponseCode() == 200) {
            InputStream inputStream = connection.getInputStream();
            br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        } else {
            Log.i((String)TAG, (String)("Response code postJson is :" + connection.getResponseCode()));
        }
        StringBuilder sb = new StringBuilder();
        try {
            if (br != null) {
                String line;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.i((String)TAG, (String)("Response: " + sb.toString()));
        return sb.toString();
    }

    public String getStringFromUrlWithPost(String url, String data) throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponse(PasswordAuthentication credentials, String urlString, String contentType, String accept) {
        Log.i((String)TAG, (String)("Calling url: " + urlString));
        HttpURLConnection connection = null;
        try {
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod("GET");
            connection.setUseCaches(false);
            connection.setDoInput(true);
            if (!TextUtils.isEmpty((CharSequence)contentType)) {
                connection.setRequestProperty("Content-Type", contentType);
            }
            if (!TextUtils.isEmpty((CharSequence)accept)) {
                connection.setRequestProperty("Accept", accept);
            }
            this.addGlobalHeaders(connection);
            connection.connect();
            if (connection == null) {
                String string = null;
                return string;
            }
            BufferedReader br = null;
            if (connection.getResponseCode() == 200) {
                InputStream inputStream = connection.getInputStream();
                br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            } else {
                Log.i((String)TAG, (String)("Response code for getResponse is  :" + connection.getResponseCode()));
            }
            StringBuilder sb = new StringBuilder();
            try {
                if (br != null) {
                    String line;
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String string = sb.toString();
            return string;
        }
        catch (ConnectException e) {
            Log.i((String)TAG, (String)"failed to connect Internet is not working");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.disconnect();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public void addGlobalHeaders(HttpURLConnection connection) {
        try {
            MobiComUserPreference userPreferences;
            connection.setRequestProperty(APPLICATION_KEY_HEADER, MobiComKitClientService.getApplicationKey(this.context));
            connection.setRequestProperty(SOURCE_HEADER, SOURCE_HEADER_VALUE);
            connection.setRequestProperty(USERID_HEADER, USERID_HEADER_VALUE);
            connection.setRequestProperty(DEVICE_KEY_HEADER, MobiComUserPreference.getInstance(this.context).getDeviceKeyString());
            if (MobiComKitClientService.getAppModuleName(this.context) != null) {
                connection.setRequestProperty(APP_MODULE_NAME_KEY_HEADER, MobiComKitClientService.getAppModuleName(this.context));
            }
            if ((userPreferences = MobiComUserPreference.getInstance(this.context)).isRegistered()) {
                String userCredentials = this.getCredentials().getUserName() + ":" + String.valueOf(this.getCredentials().getPassword());
                String basicAuth = "Basic " + Base64.encodeToString((byte[])userCredentials.getBytes(), (int)2);
                connection.setRequestProperty("Authorization", basicAuth);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PasswordAuthentication getCredentials() {
        MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
        if (!userPreferences.isRegistered()) {
            return null;
        }
        return new PasswordAuthentication(userPreferences.getUserId(), userPreferences.getDeviceKeyString().toCharArray());
    }
}

