/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.contact.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.database.MobiComDatabaseHelper;
import com.applozic.mobicommons.people.contact.Contact;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ContactDatabase {
    public static final String CONTACT = "contact";
    private static final String TAG = "ContactDatabaseService";
    Context context = null;
    private MobiComUserPreference userPreferences;
    private MobiComDatabaseHelper dbHelper;

    public ContactDatabase(Context context) {
        this.context = context;
        this.userPreferences = MobiComUserPreference.getInstance(context);
        this.dbHelper = MobiComDatabaseHelper.getInstance(context);
    }

    public Contact getContact(Cursor cursor) {
        return this.getContact(cursor, null);
    }

    public Contact getContact(Cursor cursor, String primaryKeyAliash) {
        Contact contact = new Contact();
        contact.setFullName(cursor.getString(cursor.getColumnIndex("fullName")));
        contact.setUserId(cursor.getString(cursor.getColumnIndex(primaryKeyAliash == null ? "userId" : primaryKeyAliash)));
        contact.setLocalImageUrl(cursor.getString(cursor.getColumnIndex("contactImageLocalURI")));
        contact.setImageURL(cursor.getString(cursor.getColumnIndex("contactImageURL")));
        String contactNumber = cursor.getString(cursor.getColumnIndex("contactNO"));
        if (TextUtils.isEmpty((CharSequence)contactNumber)) {
            contact.setContactNumber(cursor.getString(cursor.getColumnIndex(primaryKeyAliash == null ? "userId" : primaryKeyAliash)));
        } else {
            contact.setContactNumber(cursor.getString(cursor.getColumnIndex("contactNO")));
        }
        contact.setApplicationId(cursor.getString(cursor.getColumnIndex("applicationId")));
        Long connected = cursor.getLong(cursor.getColumnIndex("connected"));
        contact.setConnected(connected != 0L && connected.intValue() == 1);
        contact.setLastSeenAt(Long.valueOf(cursor.getLong(cursor.getColumnIndex("lastSeenAt"))));
        contact.processContactNumbers(this.context);
        contact.setUnreadCount(Integer.valueOf(cursor.getInt(cursor.getColumnIndex("unreadCount"))));
        Boolean userBlocked = cursor.getInt(cursor.getColumnIndex("blocked")) == 1;
        contact.setBlocked(userBlocked.booleanValue());
        Boolean userBlockedBy = cursor.getInt(cursor.getColumnIndex("blockedBy")) == 1;
        contact.setBlockedBy(userBlockedBy.booleanValue());
        return contact;
    }

    public List<Contact> getContactList(Cursor cursor) {
        ArrayList<Contact> smsList = new ArrayList<Contact>();
        cursor.moveToFirst();
        if (cursor.getCount() > 0) {
            do {
                smsList.add(this.getContact(cursor));
            } while (cursor.moveToNext());
        }
        return smsList;
    }

    public List<Contact> getAllContactListExcludingLoggedInUser() {
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        String structuredNameWhere = "contactNO != ?";
        Cursor cursor = db.query(CONTACT, null, structuredNameWhere, new String[]{MobiComUserPreference.getInstance(this.context).getUserId()}, null, null, "fullName asc");
        List<Contact> contactList = this.getContactList(cursor);
        cursor.close();
        this.dbHelper.close();
        return contactList;
    }

    public List<Contact> getAllContact() {
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        Cursor cursor = db.query(CONTACT, null, null, null, null, null, "fullName asc");
        List<Contact> contactList = this.getContactList(cursor);
        cursor.close();
        this.dbHelper.close();
        return contactList;
    }

    public Contact getContactById(String id) {
        String structuredNameWhere = "userId =?";
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        Cursor cursor = db.query(CONTACT, null, structuredNameWhere, new String[]{id}, null, null, null);
        Contact contact = null;
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                contact = this.getContact(cursor);
            }
            cursor.close();
        }
        this.dbHelper.close();
        return contact;
    }

    public void updateContact(Contact contact) {
        ContentValues contentValues = this.prepareContactValues(contact);
        this.dbHelper.getWritableDatabase().update(CONTACT, contentValues, "userId=?", new String[]{contact.getUserId()});
        this.dbHelper.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnectedOrDisconnectedStatus(String userId, Date date, boolean connected) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("connected", Integer.valueOf(connected ? 1 : 0));
        contentValues.put("lastSeenAt", Long.valueOf(date.getTime()));
        try {
            this.dbHelper.getWritableDatabase().update(CONTACT, contentValues, "userId=?", new String[]{userId});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastSeenTimeAt(String userId, long lastSeenTime) {
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put("lastSeenAt", Long.valueOf(lastSeenTime));
            this.dbHelper.getWritableDatabase().update(CONTACT, contentValues, "userId=?", new String[]{userId});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserBlockStatus(String userId, boolean userBlocked) {
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put("blocked", Integer.valueOf(userBlocked ? 1 : 0));
            int n = this.dbHelper.getWritableDatabase().update(CONTACT, contentValues, "userId=?", new String[]{userId});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserBlockByStatus(String userId, boolean userBlockedBy) {
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put("blockedBy", Integer.valueOf(userBlockedBy ? 1 : 0));
            int n = this.dbHelper.getWritableDatabase().update(CONTACT, contentValues, "userId=?", new String[]{userId});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.dbHelper.close();
        }
    }

    public void addContact(Contact contact) {
        if (TextUtils.isEmpty((CharSequence)contact.getContactNumber())) {
            contact.setContactNumber(contact.getUserId());
        }
        ContentValues contentValues = this.prepareContactValues(contact);
        this.dbHelper.getWritableDatabase().insert(CONTACT, null, contentValues);
        this.dbHelper.close();
    }

    public ContentValues prepareContactValues(Contact contact) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("fullName", this.getFullNameForUpdate(contact));
        contentValues.put("contactNO", contact.getContactNumber());
        if (!TextUtils.isEmpty((CharSequence)contact.getImageURL())) {
            contentValues.put("contactImageURL", contact.getImageURL());
        }
        if (!TextUtils.isEmpty((CharSequence)contact.getLocalImageUrl())) {
            contentValues.put("contactImageLocalURI", contact.getLocalImageUrl());
        }
        contentValues.put("userId", contact.getUserId());
        if (!TextUtils.isEmpty((CharSequence)contact.getEmailId())) {
            contentValues.put("email", contact.getEmailId());
        }
        if (!TextUtils.isEmpty((CharSequence)contact.getApplicationId())) {
            contentValues.put("applicationId", contact.getApplicationId());
        }
        contentValues.put("connected", Integer.valueOf(contact.isConnected() ? 1 : 0));
        if (contact.getLastSeenAt() != 0L) {
            contentValues.put("lastSeenAt", Long.valueOf(contact.getLastSeenAt()));
        }
        if (contact.getUnreadCount() != null && contact.getUnreadCount() != 0) {
            contentValues.put("unreadCount", contact.getUnreadCount());
        }
        if (contact.isBlocked()) {
            contentValues.put("blocked", Boolean.valueOf(contact.isBlocked()));
        }
        if (contact.isBlockedBy()) {
            contentValues.put("blockedBy", Boolean.valueOf(contact.isBlockedBy()));
        }
        return contentValues;
    }

    private String getFullNameForUpdate(Contact contact) {
        Contact contactFromDB;
        String fullName = contact.getDisplayName();
        if (TextUtils.isEmpty((CharSequence)contact.getFullName()) && (contactFromDB = this.getContactById(contact.getUserId())) != null) {
            fullName = contactFromDB.getFullName();
        }
        return fullName;
    }

    public boolean isContactPresent(String userId) {
        boolean present;
        SQLiteDatabase database = this.dbHelper.getWritableDatabase();
        Cursor cursor = database.rawQuery("SELECT COUNT(*) FROM contact WHERE userId = ?", new String[]{userId});
        cursor.moveToFirst();
        boolean bl = present = cursor.getInt(0) > 0;
        if (cursor != null) {
            cursor.close();
        }
        return present;
    }

    public void addAllContact(List<Contact> contactList) {
        for (Contact contact : contactList) {
            this.addContact(contact);
        }
    }

    public void deleteContact(Contact contact) {
        this.deleteContactById(contact.getUserId());
    }

    public void deleteContactById(String id) {
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        db.delete(CONTACT, "userId=?", new String[]{id});
        this.dbHelper.close();
    }

    public void deleteAllContact(List<Contact> contacts) {
        for (Contact contact : contacts) {
            this.deleteContact(contact);
        }
    }

    public Loader<Cursor> getSearchCursorLoader(final String searchString) {
        return new CursorLoader(this.context, null, null, null, null, "displayName asc"){

            public Cursor loadInBackground() {
                SQLiteDatabase db = ContactDatabase.this.dbHelper.getReadableDatabase();
                String query = "select userId as _id, fullName, contactNO, displayName,contactImageURL,contactImageLocalURI,email,applicationId,connected,lastSeenAt,unreadCount,blocked,blockedBy from contact";
                if (!TextUtils.isEmpty((CharSequence)searchString)) {
                    query = query + " where fullName like '%" + searchString + "%'";
                }
                query = query + " order by fullName,userId asc";
                Cursor cursor = db.rawQuery(query, null);
                return cursor;
            }
        };
    }
}

