/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.notification;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.SyncCallService;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.feed.GcmMessageResponse;
import com.applozic.mobicomkit.feed.MqttMessageResponse;
import com.applozic.mobicommons.json.GsonUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class MobiComPushReceiver {
    public static final String MTCOM_PREFIX = "APPLOZIC_";
    public static final List<String> notificationKeyList = new ArrayList<String>();
    private static final String TAG = "MobiComPushReceiver";
    private static Queue<String> notificationIdList = new LinkedList<String>();
    public static final String BLOCKED_TO = "BLOCKED_TO";
    public static final String UNBLOCKED_TO = "UNBLOCKED_TO";

    public static boolean isMobiComPushNotification(Intent intent) {
        Log.i((String)TAG, (String)"checking for Applozic notification.");
        return MobiComPushReceiver.isMobiComPushNotification(intent.getExtras());
    }

    public static boolean isMobiComPushNotification(Bundle bundle) {
        String payLoad = bundle.getString("collapse_key");
        Log.i((String)TAG, (String)("Received notification: " + payLoad));
        if (payLoad != null && payLoad.contains(MTCOM_PREFIX) || notificationKeyList.contains(payLoad)) {
            return true;
        }
        for (String key : notificationKeyList) {
            payLoad = bundle.getString(key);
            if (payLoad == null) continue;
            return true;
        }
        return false;
    }

    public static synchronized boolean processPushNotificationId(String id) {
        if (id != null && notificationIdList != null && notificationIdList.contains(id)) {
            if (notificationIdList.size() > 0) {
                notificationIdList.remove(id);
            }
            return true;
        }
        return false;
    }

    public static synchronized void addPushNotificationId(String notificationId) {
        try {
            if (notificationIdList != null && notificationIdList.size() < 20) {
                notificationIdList.add(notificationId);
            }
            if (notificationIdList != null && notificationIdList.size() == 20) {
                for (int i = 1; i <= 14; ++i) {
                    if (notificationIdList.size() <= 0) continue;
                    notificationIdList.remove();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void processMessage(Context context, Bundle bundle) {
        if (bundle != null) {
            String message = bundle.getString("collapse_key");
            String deleteConversationForContact = bundle.getString(notificationKeyList.get(5));
            String deleteMessage = bundle.getString(notificationKeyList.get(4));
            String payloadForDelivered = bundle.getString(notificationKeyList.get(3));
            String userConnected = bundle.getString(notificationKeyList.get(10));
            String userDisconnected = bundle.getString(notificationKeyList.get(11));
            MobiComPushReceiver.processMessage(context, bundle, message, deleteConversationForContact, deleteMessage, payloadForDelivered, userConnected, userDisconnected);
        }
    }

    public static void processMessage(Context context, Bundle bundle, String message, String deleteConversationForContact, String deleteMessage, String payloadForDelivered, String userConnected, String userDisconnected) {
        SyncCallService syncCallService = SyncCallService.getInstance(context);
        try {
            String userUnBlockedResponse;
            String userBlockedResponse;
            String conversationReadResponse;
            String messageSent;
            String keyString;
            String[] splitKeyString;
            MqttMessageResponse messageResponseForDelivered;
            String playloadDeliveredAndRead = bundle.getString(notificationKeyList.get(7));
            if (!TextUtils.isEmpty((CharSequence)payloadForDelivered)) {
                messageResponseForDelivered = (MqttMessageResponse)GsonUtils.getObjectFromJson((String)payloadForDelivered, MqttMessageResponse.class);
                if (MobiComPushReceiver.processPushNotificationId(messageResponseForDelivered.getId())) {
                    return;
                }
                MobiComPushReceiver.addPushNotificationId(messageResponseForDelivered.getId());
                splitKeyString = messageResponseForDelivered.getMessage().toString().split(",");
                keyString = splitKeyString[0];
                syncCallService.updateDeliveryStatus(keyString);
            }
            if (!TextUtils.isEmpty((CharSequence)playloadDeliveredAndRead)) {
                messageResponseForDelivered = (MqttMessageResponse)GsonUtils.getObjectFromJson((String)playloadDeliveredAndRead, MqttMessageResponse.class);
                if (MobiComPushReceiver.processPushNotificationId(messageResponseForDelivered.getId())) {
                    return;
                }
                MobiComPushReceiver.addPushNotificationId(messageResponseForDelivered.getId());
                splitKeyString = messageResponseForDelivered.getMessage().toString().split(",");
                keyString = splitKeyString[0];
                syncCallService.updateReadStatus(keyString);
            }
            if (!TextUtils.isEmpty((CharSequence)deleteConversationForContact)) {
                MqttMessageResponse deleteConversationResponse = (MqttMessageResponse)GsonUtils.getObjectFromJson((String)deleteConversationForContact, MqttMessageResponse.class);
                if (MobiComPushReceiver.processPushNotificationId(deleteConversationResponse.getId())) {
                    return;
                }
                MobiComPushReceiver.addPushNotificationId(deleteConversationResponse.getId());
                MobiComConversationService conversationService = new MobiComConversationService(context);
                conversationService.deleteConversationFromDevice(deleteConversationResponse.getMessage().toString());
                BroadcastService.sendConversationDeleteBroadcast(context, BroadcastService.INTENT_ACTIONS.DELETE_CONVERSATION.toString(), deleteConversationResponse.getMessage().toString(), 0, "success");
            }
            if (!TextUtils.isEmpty((CharSequence)userConnected)) {
                MqttMessageResponse userConnectedResponse = (MqttMessageResponse)GsonUtils.getObjectFromJson((String)userConnected, MqttMessageResponse.class);
                if (MobiComPushReceiver.processPushNotificationId(userConnectedResponse.getId())) {
                    return;
                }
                MobiComPushReceiver.addPushNotificationId(userConnectedResponse.getId());
                syncCallService.updateConnectedStatus(userConnectedResponse.getMessage().toString(), new Date(), true);
            }
            if (!TextUtils.isEmpty((CharSequence)userDisconnected)) {
                MqttMessageResponse userDisconnectedResponse = (MqttMessageResponse)GsonUtils.getObjectFromJson((String)userDisconnected, MqttMessageResponse.class);
                if (MobiComPushReceiver.processPushNotificationId(userDisconnectedResponse.getId())) {
                    return;
                }
                MobiComPushReceiver.addPushNotificationId(userDisconnectedResponse.getId());
                String[] parts = userDisconnectedResponse.getMessage().toString().split(",");
                String userId = parts[0];
                Date lastSeenAt = new Date();
                if (parts.length >= 2) {
                    lastSeenAt = new Date(Long.valueOf(parts[1]));
                }
                syncCallService.updateConnectedStatus(userId, lastSeenAt, false);
            }
            if (!TextUtils.isEmpty((CharSequence)deleteMessage)) {
                MqttMessageResponse deleteSingleMessageResponse = (MqttMessageResponse)GsonUtils.getObjectFromJson((String)deleteMessage, MqttMessageResponse.class);
                if (MobiComPushReceiver.processPushNotificationId(deleteSingleMessageResponse.getId())) {
                    return;
                }
                MobiComPushReceiver.addPushNotificationId(deleteSingleMessageResponse.getId());
                String deleteMessageKeyAndUserId = deleteSingleMessageResponse.getMessage().toString();
                syncCallService.deleteMessage(deleteMessageKeyAndUserId.split(",")[0]);
            }
            if (!TextUtils.isEmpty((CharSequence)(messageSent = bundle.getString(notificationKeyList.get(1))))) {
                GcmMessageResponse syncSentMessageResponse = (GcmMessageResponse)GsonUtils.getObjectFromJson((String)messageSent, GcmMessageResponse.class);
                if (MobiComPushReceiver.processPushNotificationId(syncSentMessageResponse.getId())) {
                    return;
                }
                MobiComPushReceiver.addPushNotificationId(syncSentMessageResponse.getId());
                syncCallService.syncMessages(null);
            }
            String messageKey = bundle.getString(notificationKeyList.get(0));
            GcmMessageResponse syncMessageResponse = null;
            if (!TextUtils.isEmpty((CharSequence)messageKey)) {
                syncMessageResponse = (GcmMessageResponse)GsonUtils.getObjectFromJson((String)messageKey, GcmMessageResponse.class);
                if (MobiComPushReceiver.processPushNotificationId(syncMessageResponse.getId())) {
                    return;
                }
                MobiComPushReceiver.addPushNotificationId(syncMessageResponse.getId());
                Message messageObj = syncMessageResponse.getMessage();
                if (!TextUtils.isEmpty((CharSequence)messageObj.getKeyString())) {
                    syncCallService.syncMessages(messageObj.getKeyString());
                } else {
                    syncCallService.syncMessages(null);
                }
            }
            if (!TextUtils.isEmpty((CharSequence)(conversationReadResponse = bundle.getString(notificationKeyList.get(9))))) {
                MqttMessageResponse updateDeliveryStatusForContactResponse = (MqttMessageResponse)GsonUtils.getObjectFromJson((String)conversationReadResponse, MqttMessageResponse.class);
                if (notificationKeyList.get(9).equals(updateDeliveryStatusForContactResponse.getType())) {
                    if (MobiComPushReceiver.processPushNotificationId(updateDeliveryStatusForContactResponse.getId())) {
                        return;
                    }
                    MobiComPushReceiver.addPushNotificationId(updateDeliveryStatusForContactResponse.getId());
                    syncCallService.updateDeliveryStatusForContact(updateDeliveryStatusForContactResponse.getMessage().toString(), true);
                }
            }
            if (!TextUtils.isEmpty((CharSequence)(userBlockedResponse = bundle.getString(notificationKeyList.get(15))))) {
                MqttMessageResponse syncUserBlock = (MqttMessageResponse)GsonUtils.getObjectFromJson((String)userBlockedResponse, MqttMessageResponse.class);
                if (MobiComPushReceiver.processPushNotificationId(syncUserBlock.getId())) {
                    return;
                }
                MobiComPushReceiver.addPushNotificationId(syncUserBlock.getId());
                String[] splitKeyString2 = syncUserBlock.getMessage().toString().split(":");
                String type = splitKeyString2[0];
                if (splitKeyString2.length >= 2) {
                    String userId = splitKeyString2[1];
                    if (BLOCKED_TO.equals(type)) {
                        syncCallService.updateUserBlocked(userId, true);
                    } else {
                        syncCallService.updateUserBlockedBy(userId, true);
                    }
                }
            }
            if (!TextUtils.isEmpty((CharSequence)(userUnBlockedResponse = bundle.getString(notificationKeyList.get(16))))) {
                MqttMessageResponse syncUserUnBlock = (MqttMessageResponse)GsonUtils.getObjectFromJson((String)userUnBlockedResponse, MqttMessageResponse.class);
                if (MobiComPushReceiver.processPushNotificationId(syncUserUnBlock.getId())) {
                    return;
                }
                MobiComPushReceiver.addPushNotificationId(syncUserUnBlock.getId());
                String[] splitKeyString3 = syncUserUnBlock.getMessage().toString().split(":");
                String type = splitKeyString3[0];
                if (splitKeyString3.length >= 2) {
                    String userId = splitKeyString3[1];
                    if (UNBLOCKED_TO.equals(type)) {
                        syncCallService.updateUserBlocked(userId, false);
                    } else {
                        syncCallService.updateUserBlockedBy(userId, false);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void processMessageAsync(final Context context, final Bundle bundle) {
        if (MobiComUserPreference.getInstance(context).isLoggedIn()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    MobiComPushReceiver.processMessage(context, bundle);
                }
            }).start();
        }
    }

    public static void processMessageAsync(Context context, Intent intent) {
        MobiComPushReceiver.processMessageAsync(context, intent.getExtras());
    }

    static {
        notificationKeyList.add("APPLOZIC_01");
        notificationKeyList.add("APPLOZIC_02");
        notificationKeyList.add("APPLOZIC_03");
        notificationKeyList.add("APPLOZIC_04");
        notificationKeyList.add("APPLOZIC_05");
        notificationKeyList.add("APPLOZIC_06");
        notificationKeyList.add("APPLOZIC_07");
        notificationKeyList.add("APPLOZIC_08");
        notificationKeyList.add("APPLOZIC_09");
        notificationKeyList.add("APPLOZIC_10");
        notificationKeyList.add("APPLOZIC_11");
        notificationKeyList.add("APPLOZIC_12");
        notificationKeyList.add("APPLOZIC_13");
        notificationKeyList.add("APPLOZIC_14");
        notificationKeyList.add("APPLOZIC_15");
        notificationKeyList.add("APPLOZIC_16");
        notificationKeyList.add("APPLOZIC_17");
    }
}

