/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.contact;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import android.util.Log;
import com.applozic.mobicomkit.contact.VCFContactData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public class MobiComVCFParser {
    public static final String BEGIN_VCARD = "BEGIN:VCARD";
    public static final String END_VCARD = "END:VCARD";
    public static final String VERSION = "VERSION:2.1";
    public VCFContactData vcfContactData;

    public static boolean validateData(String data) {
        return data != null && data.replaceAll("[\n\r]", "").startsWith(BEGIN_VCARD) && data.replaceAll("[\n\r]", "").endsWith(END_VCARD);
    }

    public VCFContactData parseCVFContactData(String filePath) throws Exception {
        File file = new File(filePath);
        FileReader fin = new FileReader(file);
        BufferedReader in = new BufferedReader(fin);
        StringBuffer contactBuffer = new StringBuffer();
        StringBuffer imageByteCode = null;
        String sLine = in.readLine();
        while (sLine != null) {
            if (sLine.equalsIgnoreCase(BEGIN_VCARD)) {
                this.vcfContactData = new VCFContactData();
            } else {
                String[] tokens;
                if (sLine.equalsIgnoreCase(END_VCARD)) {
                    this.vcfContactData.setTelephoneNumber(contactBuffer.toString());
                    if (imageByteCode != null) {
                        this.vcfContactData.setProfilePic(this.stringToBitMap(imageByteCode.toString()));
                    }
                    return this.vcfContactData;
                }
                if (sLine.startsWith("FN:")) {
                    tokens = sLine.split(":");
                    if (tokens.length == 2) {
                        this.vcfContactData.setName(tokens[1]);
                    }
                } else if (sLine.startsWith("TEL;")) {
                    tokens = sLine.split(":");
                    if (tokens.length == 2) {
                        contactBuffer.append(tokens[1] + "\n");
                    }
                } else if (sLine.startsWith("PHOTO")) {
                    tokens = sLine.split(":");
                    if (tokens.length >= 2) {
                        imageByteCode = new StringBuffer().append(tokens[1]);
                    }
                } else if (sLine.startsWith("EMAIL")) {
                    tokens = sLine.split(":");
                    if (tokens.length >= 2) {
                        this.vcfContactData.setEmail(tokens[1]);
                    }
                } else if (imageByteCode != null) {
                    imageByteCode.append(sLine);
                }
            }
            sLine = in.readLine();
        }
        return null;
    }

    public Bitmap stringToBitMap(String encodedString) {
        try {
            byte[] encodeByte = Base64.decode((String)encodedString, (int)0);
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])encodeByte, (int)0, (int)encodeByte.length);
            return bitmap;
        }
        catch (Exception e) {
            Log.e((String)"MobiComVCFParser", (String)encodedString, (Throwable)e);
            return null;
        }
    }
}

