/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.channel.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.database.MobiComDatabaseHelper;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.ChannelUserMapper;
import java.util.ArrayList;
import java.util.List;

public class ChannelDatabaseService {
    private static final String TAG = "ChannelDatabaseService";
    private static final String CHANNEL = "channel";
    private static final String CHANNEL_USER_X = "channel_User_X";
    private static ChannelDatabaseService channelDatabaseService;
    private Context context;
    private MobiComUserPreference mobiComUserPreference;
    private MobiComDatabaseHelper dbHelper;

    private ChannelDatabaseService(Context context) {
        this.context = context;
        this.mobiComUserPreference = MobiComUserPreference.getInstance(context);
        this.dbHelper = MobiComDatabaseHelper.getInstance(context);
    }

    public static synchronized ChannelDatabaseService getInstance(Context context) {
        if (channelDatabaseService == null) {
            channelDatabaseService = new ChannelDatabaseService(context);
        }
        return channelDatabaseService;
    }

    public static ChannelUserMapper getChannelUser(Cursor cursor) {
        ChannelUserMapper channelUserMapper = new ChannelUserMapper();
        channelUserMapper.setUserKey(cursor.getString(cursor.getColumnIndex("userId")));
        channelUserMapper.setKey(Integer.valueOf(cursor.getInt(cursor.getColumnIndex("channelKey"))));
        channelUserMapper.setUnreadCount((int)cursor.getShort(cursor.getColumnIndex("unreadCount")));
        return channelUserMapper;
    }

    public static List<ChannelUserMapper> getListOfUsers(Cursor cursor) {
        ArrayList<ChannelUserMapper> channelUserMapper = new ArrayList<ChannelUserMapper>();
        cursor.moveToFirst();
        if (cursor.getCount() > 0) {
            do {
                channelUserMapper.add(ChannelDatabaseService.getChannelUser(cursor));
            } while (cursor.moveToNext());
        }
        return channelUserMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChannel(Channel channel) {
        try {
            ContentValues contentValues = this.prepareChannelValues(channel);
            this.dbHelper.getWritableDatabase().insertWithOnConflict(CHANNEL, null, contentValues, 5);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.dbHelper.close();
        }
    }

    public ContentValues prepareChannelValues(Channel channel) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("channelName", channel.getName());
        contentValues.put("channelKey", channel.getKey());
        contentValues.put("type", channel.getType());
        contentValues.put("adminId", channel.getAdminKey());
        if (channel.getUserCount() != 0) {
            contentValues.put("userCount", Integer.valueOf(channel.getUserCount()));
        }
        if (channel.getUnreadCount() != 0) {
            contentValues.put("unreadCount", Integer.valueOf(channel.getUnreadCount()));
        }
        return contentValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChannelUserMapper(ChannelUserMapper channelUserMapper) {
        try {
            ContentValues contentValues = this.prepareChannelUserMapperValues(channelUserMapper);
            this.dbHelper.getWritableDatabase().insertWithOnConflict(CHANNEL_USER_X, null, contentValues, 5);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.dbHelper.close();
        }
    }

    public ContentValues prepareChannelUserMapperValues(ChannelUserMapper channelUserMapper) {
        ContentValues contentValues = new ContentValues();
        if (channelUserMapper != null) {
            if (channelUserMapper.getKey() != null) {
                contentValues.put("channelKey", channelUserMapper.getKey());
            }
            if (channelUserMapper.getUserKey() != null) {
                contentValues.put("userId", channelUserMapper.getUserKey());
            }
            if (channelUserMapper.getUserKey() != null) {
                contentValues.put("unreadCount", Integer.valueOf(channelUserMapper.getUnreadCount()));
            }
            if (channelUserMapper.getStatus() != 0) {
                contentValues.put("status", Short.valueOf(channelUserMapper.getStatus()));
            }
        }
        return contentValues;
    }

    public Channel getChannelByChannelKey(Integer channelKey) {
        Channel channel = null;
        try {
            String structuredNameWhere = "channelKey =?";
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            Cursor cursor = db.query(CHANNEL, null, structuredNameWhere, new String[]{String.valueOf(channelKey)}, null, null, null);
            if (cursor != null) {
                if (cursor.getCount() > 0) {
                    cursor.moveToFirst();
                    channel = this.getChannel(cursor);
                }
                cursor.close();
            }
            this.dbHelper.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return channel;
    }

    public List<ChannelUserMapper> getChannelUserList(Integer channelKey) {
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            String structuredNameWhere = "";
            structuredNameWhere = structuredNameWhere + "channelKey = ?";
            Cursor cursor = db.query(CHANNEL_USER_X, null, structuredNameWhere, new String[]{String.valueOf(channelKey)}, null, null, null);
            List<ChannelUserMapper> channelUserMappers = ChannelDatabaseService.getListOfUsers(cursor);
            cursor.close();
            this.dbHelper.close();
            return channelUserMappers;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Channel getChannel(Cursor cursor) {
        Channel channel = new Channel();
        channel.setKey(Integer.valueOf(cursor.getInt(cursor.getColumnIndex("channelKey"))));
        channel.setName(cursor.getString(cursor.getColumnIndex("channelName")));
        channel.setAdminKey(cursor.getString(cursor.getColumnIndex("adminId")));
        channel.setType(Short.valueOf(cursor.getShort(cursor.getColumnIndex("type"))));
        int count = cursor.getInt(cursor.getColumnIndex("unreadCount"));
        if (count > 0) {
            channel.setUnreadCount(count);
        }
        return channel;
    }

    public List<Channel> getAllChannels() {
        List<Channel> contactList = null;
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            Cursor cursor = db.query(CHANNEL, null, null, null, null, null, "channelName asc");
            contactList = this.getChannelList(cursor);
            cursor.close();
            this.dbHelper.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contactList;
    }

    public List<Channel> getChannelList(Cursor cursor) {
        ArrayList<Channel> channelList = new ArrayList<Channel>();
        cursor.moveToFirst();
        if (cursor.getCount() > 0) {
            do {
                channelList.add(this.getChannel(cursor));
            } while (cursor.moveToNext());
        }
        return channelList;
    }

    public void updateChannel(Channel channel) {
        ContentValues contentValues = this.prepareChannelValues(channel);
        this.dbHelper.getWritableDatabase().update(CHANNEL, contentValues, "channelKey=?", new String[]{String.valueOf(channel.getKey())});
        this.dbHelper.close();
    }

    public void updateChannel(ChannelUserMapper channelUserMapper) {
        ContentValues contentValues = this.prepareChannelUserMapperValues(channelUserMapper);
        this.dbHelper.getWritableDatabase().update(CHANNEL_USER_X, contentValues, "channelKey=?  and userId=?", new String[]{String.valueOf(channelUserMapper.getKey()), String.valueOf(channelUserMapper.getUserKey())});
        this.dbHelper.close();
    }

    public boolean isChannelPresent(Integer channelKey) {
        boolean present;
        SQLiteDatabase database = this.dbHelper.getWritableDatabase();
        Cursor cursor = database.rawQuery("SELECT COUNT(*) FROM channel WHERE channelKey=?", new String[]{String.valueOf(channelKey)});
        cursor.moveToFirst();
        boolean bl = present = cursor.getInt(0) > 0;
        if (cursor != null) {
            cursor.close();
        }
        this.dbHelper.close();
        return present;
    }

    public boolean isChannelUserPresent(Integer channelKey, String userId) {
        boolean present;
        SQLiteDatabase database = this.dbHelper.getWritableDatabase();
        Cursor cursor = database.rawQuery("SELECT COUNT(*) FROM channel_User_X WHERE channelKey=? and userId=?", new String[]{String.valueOf(channelKey), String.valueOf(userId)});
        cursor.moveToFirst();
        boolean bl = present = cursor.getInt(0) > 0;
        if (cursor != null) {
            cursor.close();
        }
        this.dbHelper.close();
        return present;
    }
}

