/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api;

import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import com.applozic.mobicomkit.api.HttpRequestUtils;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicommons.commons.core.utils.Utils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.http.auth.UsernamePasswordCredentials;

public class MobiComKitClientService {
    protected Context context;
    public static final String BASE_URL_METADATA = "com.applozic.server.url";
    public static final String MQTT_BASE_URL_METADATA = "com.applozic.mqtt.server.url";
    public static String APPLICATION_KEY_HEADER = "Application-Key";
    public static String APPLICATION_KEY_HEADER_VALUE_METADATA = "com.applozic.application.key";
    public static final String FILE_URL = "/rest/ws/aws/file/";
    protected String DEFAULT_URL = "https://apps.applozic.com";
    protected String FILE_BASE_URL = "https://applozic.appspot.com";
    protected String DEFAULT_MQTT_URL = "tcp://apps.applozic.com";

    public MobiComKitClientService() {
    }

    public MobiComKitClientService(Context context) {
        this.context = context;
    }

    protected String getBaseUrl() {
        String SELECTED_BASE_URL = MobiComUserPreference.getInstance(this.context).getUrl();
        if (!TextUtils.isEmpty((CharSequence)SELECTED_BASE_URL)) {
            return SELECTED_BASE_URL;
        }
        String BASE_URL = Utils.getMetaDataValue((Context)this.context, (String)BASE_URL_METADATA);
        if (!TextUtils.isEmpty((CharSequence)BASE_URL)) {
            return BASE_URL;
        }
        return this.DEFAULT_URL;
    }

    protected String getMqttBaseUrl() {
        String MQTT_BASE_URL = Utils.getMetaDataValue((Context)this.context, (String)MQTT_BASE_URL_METADATA);
        if (!TextUtils.isEmpty((CharSequence)MQTT_BASE_URL)) {
            return MQTT_BASE_URL;
        }
        return this.DEFAULT_MQTT_URL;
    }

    public UsernamePasswordCredentials getCredentials() {
        MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
        if (!userPreferences.isRegistered()) {
            return null;
        }
        return new UsernamePasswordCredentials(userPreferences.getUserId(), userPreferences.getDeviceKeyString());
    }

    public HttpURLConnection openHttpConnection(String urlString) throws IOException {
        HttpURLConnection httpConn;
        URL url = new URL(urlString);
        URLConnection conn = url.openConnection();
        if (!(conn instanceof HttpURLConnection)) {
            throw new IOException("Not an HTTP connection");
        }
        try {
            httpConn = (HttpURLConnection)conn;
            httpConn.setAllowUserInteraction(false);
            httpConn.setInstanceFollowRedirects(true);
            httpConn.setRequestMethod("GET");
            String userCredentials = this.getCredentials().getUserName() + ":" + this.getCredentials().getPassword();
            String basicAuth = "Basic " + Base64.encodeToString((byte[])userCredentials.getBytes(), (int)2);
            httpConn.setRequestProperty("Authorization", basicAuth);
            httpConn.setRequestProperty(APPLICATION_KEY_HEADER, MobiComKitClientService.getApplicationKey(this.context));
            httpConn.setRequestProperty(HttpRequestUtils.USERID_HEADER, HttpRequestUtils.USERID_HEADER_VALUE);
            httpConn.connect();
        }
        catch (Exception ex) {
            throw new IOException("Error connecting");
        }
        return httpConn;
    }

    public static String getApplicationKey(Context context) {
        return Utils.getMetaDataValue((Context)context, (String)APPLICATION_KEY_HEADER_VALUE_METADATA);
    }

    public String getFileUrl() {
        return this.FILE_BASE_URL + FILE_URL;
    }
}

