/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.channel.service;

import android.content.Context;
import android.util.Log;
import com.applozic.mobicomkit.api.HttpRequestUtils;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.people.ChannelCreate;
import com.applozic.mobicomkit.channel.database.ChannelDatabaseService;
import com.applozic.mobicomkit.feed.ChannelFeed;
import com.applozic.mobicomkit.feed.ChannelFeedApiResponse;
import com.applozic.mobicomkit.sync.SyncChannelFeed;
import com.applozic.mobicommons.json.GsonUtils;

public class ChannelClientService
extends MobiComKitClientService {
    private static final String CHANNEL_INFO_URL = "/rest/ws/group/info";
    private static final String CHANNEL_SYNC_URL = "/rest/ws/group/list";
    private static final String CREATE_CHANNEL_URL = "/rest/ws/group/create";
    private static final String UPDATED_AT = "updatedAt";
    private static final String TAG = "ChannelClientService";
    private static ChannelClientService channelClientService;
    private Context context;
    private ChannelDatabaseService channelDatabaseService;
    private HttpRequestUtils httpRequestUtils;

    private ChannelClientService(Context context) {
        this.context = context;
        this.channelDatabaseService = ChannelDatabaseService.getInstance(context);
        this.httpRequestUtils = new HttpRequestUtils(context);
    }

    public static ChannelClientService getInstance(Context context) {
        if (channelClientService == null) {
            channelClientService = new ChannelClientService(context);
        }
        return channelClientService;
    }

    public String getChannelInfoUrl() {
        return this.getBaseUrl() + CHANNEL_INFO_URL;
    }

    public String getChannelSyncUrl() {
        return this.getBaseUrl() + CHANNEL_SYNC_URL;
    }

    public String getCreateChannelUrl() {
        return this.getBaseUrl() + CREATE_CHANNEL_URL;
    }

    public ChannelFeed getChannelInfo(Integer channelKey) {
        String response = "";
        try {
            response = this.httpRequestUtils.getResponse(this.getCredentials(), this.getChannelInfoUrl() + "?groupId=" + channelKey, "application/json", "application/json");
            ChannelFeedApiResponse channelFeedApiResponse = (ChannelFeedApiResponse)GsonUtils.getObjectFromJson((String)response, ChannelFeedApiResponse.class);
            Log.i((String)TAG, (String)("Channel info response  is :" + response));
            if (channelFeedApiResponse.isSuccess()) {
                ChannelFeed channelFeed = channelFeedApiResponse.getResponse();
                return channelFeed;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public SyncChannelFeed getChannelFeed(String lastChannelSyncTime) {
        String url = this.getChannelSyncUrl() + "?" + UPDATED_AT + "=" + lastChannelSyncTime;
        try {
            String response = this.httpRequestUtils.getResponse(this.getCredentials(), url, "application/json", "application/json");
            Log.i((String)TAG, (String)("Channel sync call response: " + response));
            return (SyncChannelFeed)GsonUtils.getObjectFromJson((String)response, SyncChannelFeed.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ChannelFeed createChannel(ChannelCreate channelCreate) {
        ChannelFeed channelFeed = null;
        try {
            String jsonFromObject = GsonUtils.getJsonFromObject((Object)channelCreate, channelCreate.getClass());
            String createChannelResponse = this.httpRequestUtils.postData(this.getCredentials(), this.getCreateChannelUrl(), "application/json", "application/json", jsonFromObject);
            Log.i((String)TAG, (String)("Create channel Response :" + createChannelResponse));
            ChannelFeedApiResponse channelFeedApiResponse = (ChannelFeedApiResponse)GsonUtils.getObjectFromJson((String)createChannelResponse, ChannelFeedApiResponse.class);
            if (channelFeedApiResponse.isSuccess()) {
                channelFeed = channelFeedApiResponse.getResponse();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return channelFeed;
    }
}

