/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicommons.commons.core.utils.DBUtils;

public class MobiComDatabaseHelper
extends SQLiteOpenHelper {
    public static final int DB_VERSION = 3;
    public static final String _ID = "_id";
    public static final String SMS_KEY_STRING = "smsKeyString";
    public static final String STORE_ON_DEVICE_COLUMN = "storeOnDevice";
    public static final String TO_FIELD = "toField";
    public static final String SMS = "sms";
    public static final String TIMESTAMP = "timeStamp";
    public static final String SMS_TYPE = "SMSType";
    public static final String TIME_TO_LIVE = "timeToLive";
    public static final String CONTACTID = "contactId";
    public static final String SCHEDULE_SMS_TABLE_NAME = "ScheduleSMS";
    public static final String SMS_TABLE_NAME = "sms";
    public static final String CONTACT_TABLE_NAME = "contact";
    public static final String FULL_NAME = "fullName";
    public static final String CONTACT_NO = "contactNO";
    public static final String DISPLAY_NAME = "displayName";
    public static final String CONTACT_IMAGE_LOCAL_URI = "contactImageLocalURI";
    public static final String CONTACT_IMAGE_URL = "contactImageURL";
    public static final String USERID = "userId";
    public static final String EMAIL = "email";
    public static final String APPLICATION_ID = "applicationId";
    public static final String CREATE_SCHEDULE_SMS_TABLE = "create table ScheduleSMS( _id integer primary key autoincrement  ,sms text not null, timeStamp INTEGER ,toField varchar(20) not null, SMSType varchar(20) not null ,contactId varchar(20) , smsKeyString varChar(50), storeOnDevice INTEGER DEFAULT 1, source INTEGER, timeToLive integer) ;";
    public static final String CREATE_SMS_TABLE = "create table sms ( id integer primary key autoincrement, keyString var(100), toNumbers varchar(1000) not null, contactNumbers varchar(2000) not null, broadcastGroupId integer, message text not null, type integer, read integer default 0, delivered integer default 0, storeOnDevice integer default 1, sentToServer integer default 1, createdAt integer, scheduledAt integer, source integer, timeToLive integer, fileMetaKeyStrings varchar(2000), filePaths varchar(2000), thumbnailUrl varchar(2000), size integer, name varchar(2000), contentType varchar(200), metaFileKeyString varchar(2000), blobKeyString varchar(2000), canceled integer default 0, deleted integer default 0,applicationId varchar(2000) null,UNIQUE (keyString, contactNumbers))";
    private static final String ALTER_SMS_TABLE_FOR_DELETE_COLUMN = "ALTER TABLE sms ADD COLUMN deleted integer default 0";
    private static final String ALTER_CONTACT_TABLE_FOR_APPLICATION_ID_COLUMN = "ALTER TABLE contact ADD COLUMN applicationId varchar(2000) null";
    private static final String ALTER_SMS_TABLE_FOR__APPLICATION_ID_COLUMN = "ALTER TABLE sms ADD COLUMN applicationId varchar(2000) null";
    private static final String CREATE_CONTACT_TABLE = " CREATE TABLE contact ( userId VARCHAR(50) primary key, fullName VARCHAR(200), contactNO VARCHAR(15), displayName VARCHAR(25), contactImageURL VARCHAR(200), contactImageLocalURI VARCHAR(200), email VARCHAR(100), applicationId VARCHAR(2000) null ) ";
    private static final String CREATE_INDEX_SMS_TYPE = "CREATE INDEX IF NOT EXISTS INDEX_SMS_TYPE ON sms (type)";
    private static final String TAG = "MobiComDatabaseHelper";
    private static MobiComDatabaseHelper sInstance;
    private Context context;

    private MobiComDatabaseHelper(Context context) {
        this(context, "MCK_" + MobiComKitClientService.getApplicationKey(context), null, 3);
        this.context = context;
    }

    public MobiComDatabaseHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, name, factory, version);
    }

    public static MobiComDatabaseHelper getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new MobiComDatabaseHelper(context.getApplicationContext());
        }
        return sInstance;
    }

    public void onCreate(SQLiteDatabase database) {
        if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)"sms")) {
            database.execSQL(CREATE_SMS_TABLE);
        }
        if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)SCHEDULE_SMS_TABLE_NAME)) {
            database.execSQL(CREATE_SCHEDULE_SMS_TABLE);
        }
        if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME)) {
            database.execSQL(CREATE_CONTACT_TABLE);
        }
        database.execSQL(CREATE_INDEX_SMS_TYPE);
    }

    public void onUpgrade(SQLiteDatabase database, int oldVersion, int newVersion) {
        if (newVersion > oldVersion) {
            Log.i((String)TAG, (String)("Upgrading database from version " + oldVersion + " to " + newVersion + ", which will destroy all old data"));
            if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)"sms")) {
                database.execSQL(CREATE_SMS_TABLE);
            }
            if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)SCHEDULE_SMS_TABLE_NAME)) {
                database.execSQL(CREATE_SCHEDULE_SMS_TABLE);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)"sms", (String)"deleted")) {
                database.execSQL(ALTER_SMS_TABLE_FOR_DELETE_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)"sms", (String)APPLICATION_ID)) {
                database.execSQL(ALTER_SMS_TABLE_FOR__APPLICATION_ID_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)APPLICATION_ID)) {
                database.execSQL(ALTER_CONTACT_TABLE_FOR_APPLICATION_ID_COLUMN);
            }
            database.execSQL(CREATE_INDEX_SMS_TYPE);
        } else {
            this.onCreate(database);
        }
    }

    public synchronized void close() {
    }

    public int delDatabase() {
        SQLiteDatabase db = this.getWritableDatabase();
        db.execSQL("delete from ScheduleSMS");
        db.execSQL("delete from sms");
        db.execSQL("delete from contact");
        db.close();
        return 0;
    }
}

