/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit;

import android.content.Context;
import android.content.SharedPreferences;
import com.applozic.mobicomkit.api.MobiComKitClientService;

public class ApplozicClient {
    private static final String HANDLE_DISPLAY_NAME = "CLIENT_HANDLE_DISPLAY_NAME";
    private static final String HANDLE_DIAL = "CLIENT_HANDLE_DIAL";
    public static ApplozicClient applozicClient;
    public SharedPreferences sharedPreferences;
    private Context context;

    private ApplozicClient(Context context) {
        this.context = context;
        this.sharedPreferences = context.getSharedPreferences(MobiComKitClientService.getApplicationKey(context), 0);
    }

    public static ApplozicClient getInstance(Context context) {
        if (applozicClient == null) {
            applozicClient = new ApplozicClient(context);
        }
        return applozicClient;
    }

    public boolean isHandleDisplayName() {
        return this.sharedPreferences.getBoolean(HANDLE_DISPLAY_NAME, true);
    }

    public ApplozicClient setHandleDisplayName(boolean enable) {
        this.sharedPreferences.edit().putBoolean(HANDLE_DISPLAY_NAME, enable).commit();
        return this;
    }

    public boolean isHandleDial() {
        return this.sharedPreferences.getBoolean(HANDLE_DIAL, false);
    }

    public ApplozicClient setHandleDial(boolean enable) {
        this.sharedPreferences.edit().putBoolean(HANDLE_DIAL, enable).commit();
        return this;
    }
}

