/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.android.service;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.PowerManager;
import android.support.v4.content.LocalBroadcastManager;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.paho.android.service.DatabaseMessageStore;
import org.eclipse.paho.android.service.MessageStore;
import org.eclipse.paho.android.service.MqttConnection;
import org.eclipse.paho.android.service.MqttServiceBinder;
import org.eclipse.paho.android.service.MqttTraceHandler;
import org.eclipse.paho.android.service.Status;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;

public class MqttService
extends Service
implements MqttTraceHandler {
    static final String TAG = "MqttService";
    private String traceCallbackId;
    private boolean traceEnabled = false;
    MessageStore messageStore;
    private NetworkConnectionIntentReceiver networkConnectionMonitor;
    private BackgroundDataPreferenceReceiver backgroundDataPreferenceMonitor;
    private volatile boolean backgroundDataEnabled = true;
    private MqttServiceBinder mqttServiceBinder;
    private Map<String, MqttConnection> connections = new ConcurrentHashMap<String, MqttConnection>();

    void callbackToActivity(String clientHandle, Status status, Bundle dataBundle) {
        Intent callbackIntent = new Intent("MqttService.callbackToActivity.v0");
        if (clientHandle != null) {
            callbackIntent.putExtra("MqttService.clientHandle", clientHandle);
        }
        callbackIntent.putExtra("MqttService.callbackStatus", (Serializable)((Object)status));
        if (dataBundle != null) {
            callbackIntent.putExtras(dataBundle);
        }
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(callbackIntent);
    }

    public String getClient(String serverURI, String clientId, String contextId, MqttClientPersistence persistence) {
        String clientHandle = serverURI + ":" + clientId + ":" + contextId;
        if (!this.connections.containsKey(clientHandle)) {
            MqttConnection client = new MqttConnection(this, serverURI, clientId, persistence, clientHandle);
            this.connections.put(clientHandle, client);
        }
        return clientHandle;
    }

    public void connect(String clientHandle, MqttConnectOptions connectOptions, String invocationContext, String activityToken) throws MqttSecurityException, MqttException {
        MqttConnection client = this.getConnection(clientHandle);
        client.connect(connectOptions, invocationContext, activityToken);
    }

    void reconnect() {
        this.traceDebug(TAG, "Reconnect to server, client size=" + this.connections.size());
        for (MqttConnection client : this.connections.values()) {
            this.traceDebug("Reconnect Client:", client.getClientId() + '/' + client.getServerURI());
            if (!this.isOnline()) continue;
            client.reconnect();
        }
    }

    public void close(String clientHandle) {
        MqttConnection client = this.getConnection(clientHandle);
        client.close();
    }

    public void disconnect(String clientHandle, String invocationContext, String activityToken) {
        MqttConnection client = this.getConnection(clientHandle);
        client.disconnect(invocationContext, activityToken);
        this.connections.remove(clientHandle);
        this.stopSelf();
    }

    public void disconnect(String clientHandle, long quiesceTimeout, String invocationContext, String activityToken) {
        MqttConnection client = this.getConnection(clientHandle);
        client.disconnect(quiesceTimeout, invocationContext, activityToken);
        this.connections.remove(clientHandle);
        this.stopSelf();
    }

    public boolean isConnected(String clientHandle) {
        MqttConnection client = this.getConnection(clientHandle);
        return client.isConnected();
    }

    public IMqttDeliveryToken publish(String clientHandle, String topic, byte[] payload, int qos, boolean retained, String invocationContext, String activityToken) throws MqttPersistenceException, MqttException {
        MqttConnection client = this.getConnection(clientHandle);
        return client.publish(topic, payload, qos, retained, invocationContext, activityToken);
    }

    public IMqttDeliveryToken publish(String clientHandle, String topic, MqttMessage message, String invocationContext, String activityToken) throws MqttPersistenceException, MqttException {
        MqttConnection client = this.getConnection(clientHandle);
        return client.publish(topic, message, invocationContext, activityToken);
    }

    public void subscribe(String clientHandle, String topic, int qos, String invocationContext, String activityToken) {
        MqttConnection client = this.getConnection(clientHandle);
        client.subscribe(topic, qos, invocationContext, activityToken);
    }

    public void subscribe(String clientHandle, String[] topic, int[] qos, String invocationContext, String activityToken) {
        MqttConnection client = this.getConnection(clientHandle);
        client.subscribe(topic, qos, invocationContext, activityToken);
    }

    public void unsubscribe(String clientHandle, String topic, String invocationContext, String activityToken) {
        MqttConnection client = this.getConnection(clientHandle);
        client.unsubscribe(topic, invocationContext, activityToken);
    }

    public void unsubscribe(String clientHandle, String[] topic, String invocationContext, String activityToken) {
        MqttConnection client = this.getConnection(clientHandle);
        client.unsubscribe(topic, invocationContext, activityToken);
    }

    public IMqttDeliveryToken[] getPendingDeliveryTokens(String clientHandle) {
        MqttConnection client = this.getConnection(clientHandle);
        return client.getPendingDeliveryTokens();
    }

    private MqttConnection getConnection(String clientHandle) {
        MqttConnection client = this.connections.get(clientHandle);
        if (client == null) {
            throw new IllegalArgumentException("Invalid ClientHandle");
        }
        return client;
    }

    public Status acknowledgeMessageArrival(String clientHandle, String id) {
        if (this.messageStore.discardArrived(clientHandle, id)) {
            return Status.OK;
        }
        return Status.ERROR;
    }

    public void onCreate() {
        super.onCreate();
        this.mqttServiceBinder = new MqttServiceBinder(this);
        this.messageStore = new DatabaseMessageStore(this, (Context)this);
    }

    public void onDestroy() {
        for (MqttConnection client : this.connections.values()) {
            client.disconnect(null, null);
        }
        if (this.mqttServiceBinder != null) {
            this.mqttServiceBinder = null;
        }
        this.unregisterBroadcastReceivers();
        if (this.messageStore != null) {
            this.messageStore.close();
        }
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        String activityToken = intent.getStringExtra("MqttService.activityToken");
        this.mqttServiceBinder.setActivityToken(activityToken);
        return this.mqttServiceBinder;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.registerBroadcastReceivers();
        return 1;
    }

    public void setTraceCallbackId(String traceCallbackId) {
        this.traceCallbackId = traceCallbackId;
    }

    public void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    @Override
    public void traceDebug(String tag, String message) {
        this.traceCallback("debug", tag, message);
    }

    @Override
    public void traceError(String tag, String message) {
        this.traceCallback("error", tag, message);
    }

    private void traceCallback(String severity, String tag, String message) {
        if (this.traceCallbackId != null && this.traceEnabled) {
            Bundle dataBundle = new Bundle();
            dataBundle.putString("MqttService.callbackAction", "trace");
            dataBundle.putString("MqttService.traceSeverity", severity);
            dataBundle.putString("MqttService.traceTag", tag);
            dataBundle.putString("MqttService.errorMessage", message);
            this.callbackToActivity(this.traceCallbackId, Status.ERROR, dataBundle);
        }
    }

    @Override
    public void traceException(String tag, String message, Exception e) {
        if (this.traceCallbackId != null) {
            Bundle dataBundle = new Bundle();
            dataBundle.putString("MqttService.callbackAction", "trace");
            dataBundle.putString("MqttService.traceSeverity", "exception");
            dataBundle.putString("MqttService.errorMessage", message);
            dataBundle.putSerializable("MqttService.exception", (Serializable)e);
            dataBundle.putString("MqttService.traceTag", tag);
            this.callbackToActivity(this.traceCallbackId, Status.ERROR, dataBundle);
        }
    }

    private void registerBroadcastReceivers() {
        if (this.networkConnectionMonitor == null) {
            this.networkConnectionMonitor = new NetworkConnectionIntentReceiver();
            this.registerReceiver(this.networkConnectionMonitor, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        if (Build.VERSION.SDK_INT < 14) {
            ConnectivityManager cm = (ConnectivityManager)this.getSystemService("connectivity");
            this.backgroundDataEnabled = cm.getBackgroundDataSetting();
            if (this.backgroundDataPreferenceMonitor == null) {
                this.backgroundDataPreferenceMonitor = new BackgroundDataPreferenceReceiver();
                this.registerReceiver(this.backgroundDataPreferenceMonitor, new IntentFilter("android.net.conn.BACKGROUND_DATA_SETTING_CHANGED"));
            }
        }
    }

    private void unregisterBroadcastReceivers() {
        if (this.networkConnectionMonitor != null) {
            this.unregisterReceiver(this.networkConnectionMonitor);
            this.networkConnectionMonitor = null;
        }
        if (Build.VERSION.SDK_INT < 14 && this.backgroundDataPreferenceMonitor != null) {
            this.unregisterReceiver(this.backgroundDataPreferenceMonitor);
        }
    }

    public boolean isOnline() {
        ConnectivityManager cm = (ConnectivityManager)this.getSystemService("connectivity");
        return cm.getActiveNetworkInfo() != null && cm.getActiveNetworkInfo().isAvailable() && cm.getActiveNetworkInfo().isConnected() && this.backgroundDataEnabled;
    }

    public void notifyClientsOffline() {
        for (MqttConnection connection : this.connections.values()) {
            connection.offline();
        }
    }

    private class BackgroundDataPreferenceReceiver
    extends BroadcastReceiver {
        private BackgroundDataPreferenceReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            ConnectivityManager cm = (ConnectivityManager)MqttService.this.getSystemService("connectivity");
            MqttService.this.traceDebug(MqttService.TAG, "Reconnect since BroadcastReceiver.");
            if (cm.getBackgroundDataSetting()) {
                if (!MqttService.this.backgroundDataEnabled) {
                    MqttService.this.backgroundDataEnabled = true;
                    MqttService.this.reconnect();
                }
            } else {
                MqttService.this.backgroundDataEnabled = false;
                MqttService.this.notifyClientsOffline();
            }
        }
    }

    private class NetworkConnectionIntentReceiver
    extends BroadcastReceiver {
        private NetworkConnectionIntentReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            MqttService.this.traceDebug(MqttService.TAG, "Internal network status receive.");
            PowerManager pm = (PowerManager)MqttService.this.getSystemService("power");
            PowerManager.WakeLock wl = pm.newWakeLock(1, "MQTT");
            wl.acquire();
            MqttService.this.traceDebug(MqttService.TAG, "Reconnect for Network recovery.");
            if (MqttService.this.isOnline()) {
                MqttService.this.traceDebug(MqttService.TAG, "Online,reconnect.");
                MqttService.this.reconnect();
            } else {
                MqttService.this.notifyClientsOffline();
            }
            wl.release();
        }
    }
}

