/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.MobiComMessageService;
import java.util.List;

public class SyncCallService {
    private static final String TAG = "SyncCall";
    private static SyncCallService syncCallService;
    private MobiComMessageService mobiComMessageService;
    private MobiComConversationService mobiComConversationService;

    private SyncCallService(Context context) {
        this.mobiComMessageService = new MobiComMessageService(context, MessageIntentService.class);
        this.mobiComConversationService = new MobiComConversationService(context);
    }

    public static synchronized SyncCallService getInstance(Context context) {
        if (syncCallService == null) {
            syncCallService = new SyncCallService(context);
        }
        return syncCallService;
    }

    public synchronized void updateDeliveryStatus(String key) {
        this.mobiComMessageService.updateDeliveryStatus(key);
    }

    public synchronized List<Message> getLatestMessagesGroupByPeople() {
        return this.mobiComConversationService.getLatestMessagesGroupByPeople(null);
    }

    public synchronized List<Message> getLatestMessagesGroupByPeople(Long createdAt) {
        return this.mobiComConversationService.getLatestMessagesGroupByPeople(createdAt);
    }

    public synchronized void syncMessages(String key) {
        if (!TextUtils.isEmpty((CharSequence)key) && this.mobiComMessageService.isMessagePresent(key)) {
            Log.d((String)TAG, (String)"Message is already present, MQTT reached before GCM.");
        } else {
            this.mobiComMessageService.syncMessages();
        }
    }

    public synchronized void updateDeliveryStatusForContact(String contactId) {
        this.mobiComMessageService.updateDeliveryStatusForContact(contactId);
    }
}

