/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.account.user;

import android.app.NotificationManager;
import android.content.Context;
import android.util.Log;
import com.applozic.mobicomkit.api.ApplozicMqttService;
import com.applozic.mobicomkit.api.HttpRequestUtils;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.database.MobiComDatabaseHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;
import org.json.JSONObject;

public class UserClientService
extends MobiComKitClientService {
    private static final String TAG = "UserClientService";
    public static final String SHARED_PREFERENCE_VERSION_UPDATE_KEY = "mck.version.update";
    public static final String PHONE_NUMBER_UPDATE_URL = "/rest/ws/registration/phone/number/update";
    public static final String NOTIFY_CONTACTS_ABOUT_JOINING_MT = "/rest/ws/registration/notify/contacts";
    public static final String VERIFICATION_CONTACT_NUMBER_URL = "/rest/ws/verification/number";
    public static final String VERIFICATION_CODE_CONTACT_NUMBER_URL = "/rest/ws/verification/code";
    public static final String APP_VERSION_UPDATE_URL = "/rest/ws/registration/version/update";
    public static final String SETTING_UPDATE_URL = "/rest/ws/setting/single/update";
    public static final String TIMEZONE_UPDATAE_URL = "/rest/ws/setting/updateTZ";
    public static final String USER_INFO_URL = "/rest/ws/user/info?";
    public static final Short MOBICOMKIT_VERSION_CODE = 105;
    private HttpRequestUtils httpRequestUtils;

    public UserClientService(Context context) {
        super(context);
        this.httpRequestUtils = new HttpRequestUtils(context);
    }

    public String getPhoneNumberUpdateUrl() {
        return this.getBaseUrl() + PHONE_NUMBER_UPDATE_URL;
    }

    public String getNotifyContactsAboutJoiningMt() {
        return this.getBaseUrl() + NOTIFY_CONTACTS_ABOUT_JOINING_MT;
    }

    public String getVerificationContactNumberUrl() {
        return this.getBaseUrl() + VERIFICATION_CONTACT_NUMBER_URL;
    }

    public String getVerificationCodeContactNumberUrl() {
        return this.getBaseUrl() + VERIFICATION_CODE_CONTACT_NUMBER_URL;
    }

    public String getAppVersionUpdateUrl() {
        return this.getBaseUrl() + APP_VERSION_UPDATE_URL;
    }

    public String getSettingUpdateUrl() {
        return this.getBaseUrl() + SETTING_UPDATE_URL;
    }

    public String getTimezoneUpdataeUrl() {
        return this.getBaseUrl() + TIMEZONE_UPDATAE_URL;
    }

    public String getUserInfoUrl() {
        return this.getBaseUrl() + USER_INFO_URL;
    }

    public void logout() {
        this.logout(false);
    }

    public void logout(boolean fromLogin) {
        MobiComUserPreference mobiComUserPreference = MobiComUserPreference.getInstance(this.context);
        String userKeyString = mobiComUserPreference.getSuUserKeyString();
        String url = mobiComUserPreference.getUrl();
        NotificationManager notificationManager = (NotificationManager)this.context.getSystemService("notification");
        notificationManager.cancelAll();
        mobiComUserPreference.clearAll();
        MessageDatabaseService.recentlyAddedMessage.clear();
        MobiComDatabaseHelper.getInstance(this.context).delDatabase();
        mobiComUserPreference.setUrl(url);
        if (!fromLogin) {
            ApplozicMqttService.getInstance(this.context).disconnectPublish(userKeyString, "0");
        }
    }

    public String updateTimezone(String osuUserKeyString) {
        String response = null;
        try {
            response = this.httpRequestUtils.getStringFromUrl(this.getTimezoneUpdataeUrl() + "?suUserKeyString=" + osuUserKeyString + "&timeZone=" + URLEncoder.encode(TimeZone.getDefault().getID(), "UTF-8"));
            Log.i((String)TAG, (String)("Response from sendDeviceTimezoneToServer : " + response));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    public boolean sendVerificationCodeToServer(String verificationCode) {
        try {
            String response = this.httpRequestUtils.getResponse(this.getCredentials(), this.getVerificationCodeContactNumberUrl() + "?verificationCode=" + verificationCode, "application/json", "application/json");
            JSONObject json = new JSONObject(response);
            return json.has("code") && json.get("code").equals("200");
        }
        catch (Exception e) {
            Log.e((String)"Verification Code", (String)("Got Exception while submitting verification code to server: " + e));
            return false;
        }
    }

    public void updateCodeVersion(final String deviceKeyString) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String url = UserClientService.this.getAppVersionUpdateUrl() + "?appVersionCode=" + MOBICOMKIT_VERSION_CODE + "&deviceKeyString=" + deviceKeyString;
                String response = UserClientService.this.httpRequestUtils.getResponse(UserClientService.this.getCredentials(), url, "text/plain", "text/plain");
                Log.i((String)UserClientService.TAG, (String)("Version update response: " + response));
            }
        }).start();
    }

    public String updatePhoneNumber(String contactNumber) throws UnsupportedEncodingException {
        return this.httpRequestUtils.getResponse(this.getCredentials(), this.getPhoneNumberUpdateUrl() + "?phoneNumber=" + URLEncoder.encode(contactNumber, "UTF-8"), "text/plain", "text/plain");
    }

    public void notifyFriendsAboutJoiningThePlatform() {
        String response = this.httpRequestUtils.getResponse(this.getCredentials(), this.getNotifyContactsAboutJoiningMt(), "text/plain", "text/plain");
        Log.i((String)TAG, (String)("Response for notify contact about joining MT: " + response));
    }

    public String sendPhoneNumberForVerification(String contactNumber, String countryCode, boolean viaSms) {
        try {
            String viaSmsParam = "";
            if (viaSms) {
                viaSmsParam = "&viaSms=true";
            }
            return this.httpRequestUtils.getResponse(this.getCredentials(), this.getVerificationContactNumberUrl() + "?countryCode=" + countryCode + "&contactNumber=" + URLEncoder.encode(contactNumber, "UTF-8") + viaSmsParam, "application/json", "application/json");
        }
        catch (Exception e) {
            Log.e((String)"Verification Code", (String)("Got Exception while submitting contact number for verification to server: " + e));
            return null;
        }
    }

    public void updateSetting(final String key, final String value) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>(2);
                    nameValuePairs.add((NameValuePair)new BasicNameValuePair("key", key));
                    nameValuePairs.add((NameValuePair)new BasicNameValuePair("value", value));
                    String response = UserClientService.this.httpRequestUtils.postData(UserClientService.this.getCredentials(), UserClientService.this.getSettingUpdateUrl(), "text/plain", "text/plain", null, nameValuePairs);
                    Log.i((String)UserClientService.TAG, (String)("Response from setting update : " + response));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public Map<String, String> getUserInfo(Set<String> userIds) throws JSONException, UnsupportedEncodingException {
        if (userIds == null && userIds.isEmpty()) {
            return new HashMap<String, String>();
        }
        String userIdParam = "";
        for (String userId : userIds) {
            userIdParam = userIdParam + "&userIds=" + URLEncoder.encode(userId, "UTF-8");
        }
        String response = this.httpRequestUtils.getResponse(this.getCredentials(), this.getUserInfoUrl() + userIdParam, "application/json", "application/json");
        Log.i((String)TAG, (String)("Response: " + response));
        JSONObject jsonObject = new JSONObject(response);
        HashMap<String, String> info = new HashMap<String, String>();
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = jsonObject.getString(key);
            info.put(key, value);
        }
        return info;
    }
}

