/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import android.net.Uri;
import android.util.Log;
import android.widget.Toast;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.UserClientService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageClientService;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.api.conversation.selfdestruct.DisappearingMessageTask;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.sync.SyncMessageFeed;
import com.applozic.mobicommons.commons.core.utils.Support;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.people.contact.Contact;
import com.applozic.mobicommons.personalization.PersonalizedMessage;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MobiComMessageService {
    public static final long DELAY = 60000L;
    private static final String TAG = "MobiComMessageService";
    public static Map<String, Uri> map = new HashMap<String, Uri>();
    public static Map<String, Message> mtMessages = new LinkedHashMap<String, Message>();
    protected Context context;
    protected MobiComConversationService conversationService;
    protected MessageDatabaseService messageDatabaseService;
    protected MessageClientService messageClientService;
    protected Class messageIntentServiceClass;
    protected BaseContactService baseContactService;

    public MobiComMessageService(Context context, Class messageIntentServiceClass) {
        this.context = context;
        this.messageDatabaseService = new MessageDatabaseService(context);
        this.messageClientService = new MessageClientService(context);
        this.conversationService = new MobiComConversationService(context);
        this.messageIntentServiceClass = messageIntentServiceClass;
        this.baseContactService = new AppContactService(context);
    }

    public Message processMessage(Message messageToProcess, String tofield) {
        Message message = this.prepareMessage(messageToProcess, tofield);
        if (message.getType().equals(Message.MessageType.MT_INBOX.getValue())) {
            this.addMTMessage(message);
        } else if (message.getType().equals(Message.MessageType.MT_OUTBOX.getValue())) {
            BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.SYNC_MESSAGE.toString(), message);
            this.messageDatabaseService.createMessage(message);
        }
        Log.i((String)TAG, (String)("Sending message: " + message));
        return message;
    }

    public Message prepareMessage(Message messageToProcess, String tofield) {
        Contact contact;
        Message message = new Message(messageToProcess);
        message.setMessageId(messageToProcess.getMessageId());
        message.setKeyString(messageToProcess.getKeyString());
        message.setPairedMessageKeyString(messageToProcess.getPairedMessageKeyString());
        if (message.getMessage() != null && PersonalizedMessage.isPersonalized((String)message.getMessage()) && (contact = this.baseContactService.getContactById(tofield)) != null) {
            message.setMessage(PersonalizedMessage.prepareMessageFromTemplate((String)message.getMessage(), (Contact)contact));
        }
        return message;
    }

    public Contact addMTMessage(Message message) {
        MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
        message.processContactIds(this.context);
        Contact receiverContact = this.baseContactService.getContactById(message.getTo());
        if (message.getMessage() != null && PersonalizedMessage.isPersonalized((String)message.getMessage())) {
            message.setMessage(PersonalizedMessage.prepareMessageFromTemplate((String)message.getMessage(), (Contact)receiverContact));
        }
        this.messageDatabaseService.createMessage(message);
        Contact contact = this.baseContactService.getContactById(message.getTo());
        BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.SYNC_MESSAGE.toString(), message);
        if (BroadcastService.currentUserId == null) {
            MobiComUserPreference.getInstance(this.context).setNewMessageFlag(true);
            BroadcastService.sendNotificationBroadcast(this.context, message);
        }
        Log.i((String)TAG, (String)("Updating delivery status: " + message.getPairedMessageKeyString() + ", " + userPreferences.getUserId() + ", " + userPreferences.getContactNumber()));
        this.messageClientService.updateDeliveryStatus(message.getPairedMessageKeyString(), userPreferences.getUserId(), userPreferences.getContactNumber());
        return contact;
    }

    public synchronized void syncMessages() {
        Log.i((String)TAG, (String)"Starting syncMessages");
        MobiComUserPreference userpref = MobiComUserPreference.getInstance(this.context);
        SyncMessageFeed syncMessageFeed = this.messageClientService.getMessageFeed(userpref.getDeviceKeyString(), userpref.getLastSyncTime());
        Log.i((String)TAG, (String)("Got sync response " + syncMessageFeed));
        if (syncMessageFeed != null && syncMessageFeed.getMessages() != null) {
            this.processContactFromMessages(syncMessageFeed.getMessages());
        }
        if (syncMessageFeed != null && syncMessageFeed.isRegIdInvalid() && Utils.hasFroyo()) {
            Log.i((String)TAG, (String)"Going to call GCM device registration");
        }
        if (syncMessageFeed != null && syncMessageFeed.getMessages() != null) {
            List<Message> messageList = syncMessageFeed.getMessages();
            Log.i((String)TAG, (String)("got messages : " + messageList.size()));
            for (Message message : messageList) {
                String[] toList;
                Log.i((String)TAG, (String)("calling syncMessages : " + message.getTo() + " " + message.getMessage()));
                for (String tofield : toList = message.getTo().trim().replace("undefined,", "").split(",")) {
                    this.processMessage(message, tofield);
                    MobiComUserPreference.getInstance(this.context).setLastInboxSyncTime(message.getCreatedAtTime());
                }
            }
            userpref.setLastSyncTime(String.valueOf(syncMessageFeed.getLastSyncTime()));
        }
    }

    public synchronized void syncMessagesWithServer(String syncMessage) {
        Toast.makeText((Context)this.context, (CharSequence)syncMessage, (int)1).show();
        new Thread(new Runnable(){

            @Override
            public void run() {
                MobiComMessageService.this.syncMessages();
            }
        }).start();
    }

    public void processContactFromMessages(List<Message> messages) {
        try {
            if (!ApplozicClient.getInstance(this.context).isHandleDisplayName()) {
                return;
            }
            Log.i((String)TAG, (String)("message size" + messages.size()));
            HashSet<String> userIds = new HashSet<String>();
            for (Message msg : messages) {
                if (this.baseContactService.isContactExists(msg.getContactIds())) continue;
                userIds.add(msg.getContactIds());
            }
            if (userIds.isEmpty()) {
                return;
            }
            try {
                Map<String, String> userIdsHashMap = new UserClientService(this.context).getUserInfo(userIds);
                for (Map.Entry<String, String> keyValue : userIdsHashMap.entrySet()) {
                    Contact contact = new Contact();
                    contact.setUserId(keyValue.getKey());
                    contact.setFullName(keyValue.getValue());
                    this.baseContactService.add(contact);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void putMtextToDatabase(String payloadForMtextReceived) {
        JSONObject json = null;
        try {
            json = new JSONObject(payloadForMtextReceived);
            String smsKeyString = json.getString("keyString");
            String receiverNumber = json.getString("contactNumber");
            String body = json.getString("message");
            Integer timeToLive = json.isNull("timeToLive") ? null : Integer.valueOf(Integer.parseInt(json.getString("timeToLive")));
            Message mTextMessageReceived = new Message();
            mTextMessageReceived.setTo(json.getString("senderContactNumber"));
            mTextMessageReceived.setCreatedAtTime(System.currentTimeMillis());
            mTextMessageReceived.setMessage(body);
            mTextMessageReceived.setSendToDevice(Boolean.FALSE);
            mTextMessageReceived.setSent(Boolean.TRUE);
            mTextMessageReceived.setDeviceKeyString(MobiComUserPreference.getInstance(this.context).getDeviceKeyString());
            mTextMessageReceived.setType(Message.MessageType.MT_INBOX.getValue());
            mTextMessageReceived.setSource(Message.Source.MT_MOBILE_APP.getValue());
            mTextMessageReceived.setTimeToLive(timeToLive);
            if (json.has("fileMetaKeyStrings")) {
                JSONArray fileMetaKeyStringsJSONArray = json.getJSONArray("fileMetaKeyStrings");
                ArrayList<String> fileMetaKeyStrings = new ArrayList<String>();
                for (int i = 0; i < fileMetaKeyStringsJSONArray.length(); ++i) {
                    JSONObject fileMeta = fileMetaKeyStringsJSONArray.getJSONObject(i);
                    fileMetaKeyStrings.add(fileMeta.toString());
                }
                mTextMessageReceived.setFileMetaKeyStrings(fileMetaKeyStrings);
            }
            mTextMessageReceived.processContactIds(this.context);
            mTextMessageReceived.setTo(mTextMessageReceived.getTo());
            Contact receiverContact = this.baseContactService.getContactById(receiverNumber);
            if (mTextMessageReceived.getMessage() != null && PersonalizedMessage.isPersonalized((String)mTextMessageReceived.getMessage())) {
                mTextMessageReceived.setMessage(PersonalizedMessage.prepareMessageFromTemplate((String)mTextMessageReceived.getMessage(), (Contact)receiverContact));
            }
            try {
                this.messageClientService.sendMessageToServer(mTextMessageReceived);
            }
            catch (Exception ex) {
                Log.i((String)TAG, (String)("Received message error " + ex.getMessage()));
            }
            this.messageClientService.updateDeliveryStatus(smsKeyString, null, receiverNumber);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return;
        }
    }

    public void addWelcomeMessage(String welcome_message) {
        Message message = new Message();
        MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
        message.setContactIds(new Support(this.context).getSupportNumber());
        message.setTo(new Support(this.context).getSupportNumber());
        message.setMessage(welcome_message);
        message.setStoreOnDevice(Boolean.TRUE);
        message.setSendToDevice(Boolean.FALSE);
        message.setType(Message.MessageType.MT_INBOX.getValue());
        message.setDeviceKeyString(userPreferences.getDeviceKeyString());
        message.setSource(Message.Source.MT_MOBILE_APP.getValue());
        this.conversationService.sendMessage(message, this.messageIntentServiceClass);
    }

    public void updateDeliveryStatus(String key) {
        Log.i((String)TAG, (String)("Got the delivery report for key: " + key));
        String[] keyParts = key.split(",");
        Message message = this.messageDatabaseService.getMessage(keyParts[0]);
        if (message != null) {
            message.setDelivered(Boolean.TRUE);
            this.messageDatabaseService.updateMessageDeliveryReport(keyParts[0], null);
            BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.MESSAGE_DELIVERY.toString(), message);
            if (message.getTimeToLive() != null && message.getTimeToLive() != 0) {
                Timer timer = new Timer();
                timer.schedule((TimerTask)new DisappearingMessageTask(this.context, new MobiComConversationService(this.context), message), message.getTimeToLive() * 60 * 1000);
            }
        } else {
            Log.i((String)TAG, (String)("Message is not present in table, keyString: " + keyParts[0]));
        }
        map.remove(key);
        mtMessages.remove(key);
    }

    public void createEmptyMessages(List<Contact> contactList) {
        for (Contact contact : contactList) {
            this.createEmptyMessage(contact);
        }
        BroadcastService.sendLoadMoreBroadcast(this.context, true);
    }

    public void createEmptyMessage(Contact contact) {
        Message sms = new Message();
        MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
        sms.setContactIds(contact.getFormattedContactNumber());
        sms.setTo(contact.getContactNumber());
        sms.setCreatedAtTime(0L);
        sms.setStoreOnDevice(Boolean.TRUE);
        sms.setSendToDevice(Boolean.FALSE);
        sms.setType(Message.MessageType.MT_OUTBOX.getValue());
        sms.setDeviceKeyString(userPreferences.getDeviceKeyString());
        sms.setSource(Message.Source.MT_MOBILE_APP.getValue());
        this.messageDatabaseService.createMessage(sms);
    }
}

