/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.applozic.mobicomkit.api.HttpRequestUtils;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.api.conversation.schedule.ScheduledMessageUtil;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.sync.SmsSyncRequest;
import com.applozic.mobicomkit.sync.SyncMessageFeed;
import com.applozic.mobicommons.json.AnnotationExclusionStrategy;
import com.applozic.mobicommons.json.ArrayAdapterFactory;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.contact.Contact;
import com.applozic.mobicommons.people.group.Group;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapterFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class MessageClientService
extends MobiComKitClientService {
    public static final int SMS_SYNC_BATCH_SIZE = 5;
    public static final String DEVICE_KEY = "deviceKeyString";
    public static final String LAST_SYNC_KEY = "lastSyncTime";
    public static final String FILE_META = "fileMeta";
    public static final String MTEXT_DELIVERY_URL = "/rest/ws/sms/mtext/delivered?";
    public static final String SERVER_SYNC_URL = "/rest/ws/mobicomkit/sync/messages";
    public static final String SEND_MESSAGE_URL = "/rest/ws/mobicomkit/v1/message/send";
    public static final String SYNC_SMS_URL = "/rest/ws/sms/add/batch";
    public static final String MESSAGE_LIST_URL = "/rest/ws/mobicomkit/v1/message/list";
    public static final String MESSAGE_DELETE_URL = "/rest/ws/mobicomkit/v1/message/delete";
    public static final String UPDATE_DELIVERY_FLAG_URL = "/rest/ws/sms/update/delivered";
    public static final String MESSAGE_THREAD_DELETE_URL = "/rest/ws/sms/deleteConversion";
    public static final String ARGUMRNT_SAPERATOR = "&";
    private static final String TAG = "MessageClientService";
    private Context context;
    private MessageDatabaseService messageDatabaseService;
    private HttpRequestUtils httpRequestUtils;

    public MessageClientService(Context context) {
        super(context);
        this.context = context;
        this.messageDatabaseService = new MessageDatabaseService(context);
        this.httpRequestUtils = new HttpRequestUtils(context);
    }

    public String getMtextDeliveryUrl() {
        return this.getBaseUrl() + MTEXT_DELIVERY_URL;
    }

    public String getServerSyncUrl() {
        return this.getBaseUrl() + SERVER_SYNC_URL;
    }

    public String getSendMessageUrl() {
        return this.getBaseUrl() + SEND_MESSAGE_URL;
    }

    public String getSyncSmsUrl() {
        return this.getBaseUrl() + SYNC_SMS_URL;
    }

    public String getMessageListUrl() {
        return this.getBaseUrl() + MESSAGE_LIST_URL;
    }

    public String getMessageDeleteUrl() {
        return this.getBaseUrl() + MESSAGE_DELETE_URL;
    }

    public String getUpdateDeliveryFlagUrl() {
        return this.getBaseUrl() + UPDATE_DELIVERY_FLAG_URL;
    }

    public String getMessageThreadDeleteUrl() {
        return this.getBaseUrl() + MESSAGE_THREAD_DELETE_URL;
    }

    public String updateDeliveryStatus(Message message, String contactNumber, String countryCode) {
        try {
            String argString = "?smsKeyString=" + message.getKeyString() + "&contactNumber=" + URLEncoder.encode(contactNumber, "UTF-8") + "&deviceKeyString=" + message.getDeviceKeyString() + "&countryCode=" + countryCode;
            String URL2 = this.getUpdateDeliveryFlagUrl() + argString;
            return this.httpRequestUtils.getStringFromUrl(URL2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void updateDeliveryStatus(String messageKeyString, String userId, String receiverNumber) {
        try {
            if (TextUtils.isEmpty((CharSequence)messageKeyString) || TextUtils.isEmpty((CharSequence)userId)) {
                return;
            }
            this.httpRequestUtils.getStringFromUrl(this.getMtextDeliveryUrl() + "smsKeyString=" + messageKeyString + "&userId=" + userId + "&contactNumber=" + URLEncoder.encode(receiverNumber, "UTF-8"));
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Exception while updating delivery report for MT message", (Throwable)ex);
        }
    }

    public static synchronized void syncPendingMessages(Context context) {
        new MessageClientService(context).syncPendingMessages(true);
    }

    public void syncPendingMessages(Boolean broadcast) {
        List<Message> pendingMessages = this.messageDatabaseService.getPendingMessages();
        Log.i((String)TAG, (String)("Found " + pendingMessages.size() + " pending messages to sync."));
        for (Message message : pendingMessages) {
            Log.i((String)TAG, (String)("Syncing pending message: " + message));
            this.sendPendingMessageToServer(message, broadcast);
        }
    }

    public boolean syncMessagesWithServer(List<Message> messageList) {
        Log.i((String)TAG, (String)("Total messages to sync: " + messageList.size()));
        ArrayList<Message> messages = new ArrayList<Message>(messageList);
        do {
            try {
                SmsSyncRequest smsSyncRequest = new SmsSyncRequest();
                if (messages.size() > 5) {
                    ArrayList<Message> subList = new ArrayList<Message>(messages.subList(0, 5));
                    smsSyncRequest.setSmsList(subList);
                    messages.removeAll(subList);
                } else {
                    smsSyncRequest.setSmsList(new ArrayList<Message>(messages));
                    messages.clear();
                }
                String response = this.syncMessages(smsSyncRequest);
                Log.i((String)TAG, (String)("response from sync sms url::" + response));
                String[] keyStrings = null;
                if (!TextUtils.isEmpty((CharSequence)response) && !response.equals("error")) {
                    keyStrings = response.trim().split(",");
                }
                if (keyStrings == null) continue;
                int i = 0;
                for (Message message : smsSyncRequest.getSmsList()) {
                    if (!TextUtils.isEmpty((CharSequence)keyStrings[i])) {
                        message.setKeyString(keyStrings[i]);
                        this.messageDatabaseService.createMessage(message);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)TAG, (String)("exception" + e));
                return false;
            }
        } while (messages.size() > 0);
        return true;
    }

    public void sendPendingMessageToServer(Message message, boolean broadcast) {
        if (message.hasAttachment()) {
            return;
        }
        String response = this.sendMessage(message);
        if (TextUtils.isEmpty((CharSequence)response) || response.contains("<html>")) {
            return;
        }
        String[] responseString = response.split(",");
        String keyString = responseString[0];
        String createdAt = responseString[1];
        message.setSentMessageTimeAtServer(Long.parseLong(createdAt));
        message.setKeyString(keyString);
        if (broadcast) {
            BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.MESSAGE_SYNC_ACK_FROM_SERVER.toString(), message);
        }
        this.messageDatabaseService.updateMessageSyncStatus(message, keyString);
    }

    public void sendMessageToServer(Message message) throws Exception {
        this.sendMessageToServer(message, null);
    }

    public void sendMessageToServer(Message message, Class intentClass) throws Exception {
        this.processMessage(message);
        if (message.getScheduledAt() != null && message.getScheduledAt() != 0L && intentClass != null) {
            new ScheduledMessageUtil(this.context, intentClass).createScheduleMessage(message, this.context);
        }
    }

    public void processMessage(Message message) throws Exception {
        boolean isBroadcast = message.getMessageId() == null;
        MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
        message.setSent(Boolean.TRUE);
        message.setSendToDevice(Boolean.FALSE);
        message.setSuUserKeyString(userPreferences.getSuUserKeyString());
        message.processContactIds(this.context);
        long messageId = -1L;
        ArrayList<String> fileKeys = new ArrayList<String>();
        String keyString = null;
        keyString = UUID.randomUUID().toString();
        message.setKeyString(keyString);
        message.setSentToServer(false);
        messageId = this.messageDatabaseService.createMessage(message);
        if (isBroadcast) {
            BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.SYNC_MESSAGE.toString(), message);
        }
        if (message.isUploadRequired()) {
            for (String filePath : message.getFilePaths()) {
                try {
                    String fileMetaResponse = new FileClientService(this.context).uploadBlobImage(filePath);
                    if (fileMetaResponse == null) {
                        this.messageDatabaseService.updateCanceledFlag(messageId, 1);
                        BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.UPLOAD_ATTACHMENT_FAILED.toString(), message);
                        return;
                    }
                    JsonParser jsonParser = new JsonParser();
                    ArrayList<FileMeta> metaFileList = new ArrayList<FileMeta>();
                    JsonObject jsonObject = jsonParser.parse(fileMetaResponse).getAsJsonObject();
                    if (jsonObject.has(FILE_META)) {
                        Gson gson = new Gson();
                        metaFileList.add((FileMeta)gson.fromJson(jsonObject.get(FILE_META), FileMeta.class));
                    }
                    for (FileMeta fileMeta : metaFileList) {
                        fileKeys.add(fileMeta.getKeyString());
                    }
                    message.setFileMetas(metaFileList);
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)("Error uploading file to server: " + filePath));
                    this.messageDatabaseService.updateCanceledFlag(messageId, 1);
                    BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.UPLOAD_ATTACHMENT_FAILED.toString(), message);
                    return;
                }
            }
            message.setFileMetaKeyStrings(fileKeys);
        }
        if (messageId != -1L) {
            this.messageDatabaseService.updateMessageFileMetas(messageId, message);
        }
        String createdAt = null;
        try {
            String[] response = new MessageClientService(this.context).sendMessage(message).split(",");
            keyString = response[0];
            createdAt = response[1];
            if (!TextUtils.isEmpty((CharSequence)keyString)) {
                message.setSentMessageTimeAtServer(Long.parseLong(createdAt));
                message.setSentToServer(true);
                message.setKeyString(keyString);
            }
            this.messageDatabaseService.updateMessageFileMetas(messageId, message);
            this.messageDatabaseService.updateMessage(messageId, message.getSentMessageTimeAtServer(), keyString, message.isSentToServer());
            if (!TextUtils.isEmpty((CharSequence)keyString)) {
                // empty if block
            }
            BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.MESSAGE_SYNC_ACK_FROM_SERVER.toString(), message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String syncMessages(SmsSyncRequest smsSyncRequest) throws Exception {
        String data = GsonUtils.getJsonFromObject((Object)smsSyncRequest, SmsSyncRequest.class);
        return this.httpRequestUtils.postData(this.credentials, this.getSyncSmsUrl(), "application/json", null, data);
    }

    public String sendMessage(Message message) {
        String jsonFromObject = GsonUtils.getJsonFromObject((Object)message, message.getClass());
        Log.i((String)TAG, (String)("Sending message to server: " + jsonFromObject));
        return this.httpRequestUtils.postData(this.credentials, this.getSendMessageUrl(), "application/json", null, jsonFromObject);
    }

    public SyncMessageFeed getMessageFeed(String deviceKeyString, String lastSyncKeyString) {
        String url = this.getServerSyncUrl() + "?" + DEVICE_KEY + "=" + deviceKeyString + ARGUMRNT_SAPERATOR + LAST_SYNC_KEY + "=" + lastSyncKeyString;
        try {
            Log.i((String)TAG, (String)("Calling message feed url: " + url));
            String response = this.httpRequestUtils.getResponse(this.credentials, url, "application/json", "application/json");
            Log.i((String)TAG, (String)("Response: " + response));
            Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new ArrayAdapterFactory()).setExclusionStrategies(new ExclusionStrategy[]{new AnnotationExclusionStrategy()}).create();
            return (SyncMessageFeed)gson.fromJson(response, SyncMessageFeed.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void deleteConversationThreadFromServer(Contact contact) {
        if (TextUtils.isEmpty((CharSequence)contact.getContactIds())) {
            return;
        }
        try {
            String url = this.getMessageThreadDeleteUrl() + "?contactNumber=" + URLEncoder.encode(contact.getContactIds(), "UTF-8") + "&requestSource=1";
            String response = this.httpRequestUtils.getResponse(this.credentials, url, "text/plain", "text/plain");
            Log.i((String)TAG, (String)("Delete messages response from server: " + response + contact.getContactIds()));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public String syncDeleteConversationThreadFromServer(Contact contact) {
        String response = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)contact.getContactIds())) {
                String url = this.getMessageThreadDeleteUrl() + "?contactNumber=" + URLEncoder.encode(contact.getContactIds(), "UTF-8") + "&requestSource=1" + "&suUserKeyString=" + URLEncoder.encode(MobiComUserPreference.getInstance(this.context).getSuUserKeyString(), "UTF-8");
                response = this.httpRequestUtils.getResponse(this.credentials, url, "text/plain", "text/plain");
                Log.i((String)TAG, (String)("Delete messages response from server: " + response + contact.getContactIds()));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return response;
    }

    public void deleteMessage(Message message, Contact contact) {
        String contactNumberParameter = "";
        if (contact != null && !TextUtils.isEmpty((CharSequence)contact.getContactIds())) {
            try {
                contactNumberParameter = "&to=" + URLEncoder.encode(contact.getContactIds(), "UTF-8") + "&contactNumber=" + URLEncoder.encode(contact.getContactIds(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (message.isSentToServer()) {
            this.httpRequestUtils.getResponse(this.credentials, this.getMessageDeleteUrl() + "?key=" + message.getKeyString() + contactNumberParameter, "text/plain", "text/plain");
        }
    }

    public String getMessages(Contact contact, Group group, Long startTime, Long endTime) throws UnsupportedEncodingException {
        String contactNumber = contact != null ? contact.getFormattedContactNumber() : "";
        String params = "";
        if (TextUtils.isEmpty((CharSequence)contactNumber) && contact != null && !TextUtils.isEmpty((CharSequence)contact.getUserId())) {
            params = "userId=" + contact.getUserId() + ARGUMRNT_SAPERATOR;
        }
        params = params + (TextUtils.isEmpty((CharSequence)contactNumber) ? "" : "contactNumber=" + URLEncoder.encode(contactNumber, "utf-8") + ARGUMRNT_SAPERATOR);
        params = params + (endTime != null && endTime.intValue() != 0 ? "endTime=" + endTime + ARGUMRNT_SAPERATOR : "");
        params = params + (startTime != null && startTime.intValue() != 0 ? "startTime=" + startTime + ARGUMRNT_SAPERATOR : "");
        params = params + (group != null && group.getGroupId() != null ? "broadcastGroupId=" + group.getGroupId() + ARGUMRNT_SAPERATOR : "");
        params = params + "startIndex=0&pageSize=50";
        return this.httpRequestUtils.getResponse(this.credentials, this.getMessageListUrl() + "?" + params, "application/json", "application/json");
    }

    public String deleteMessage(Message message) {
        return this.deleteMessage(message.getKeyString());
    }

    public String deleteMessage(String keyString) {
        return this.httpRequestUtils.getResponse(this.credentials, this.getMessageDeleteUrl() + "?key=" + keyString, "text/plain", "text/plain");
    }

    public void updateMessageDeliveryReport(final Message message, final String contactNumber) throws Exception {
        message.setDelivered(Boolean.TRUE);
        this.messageDatabaseService.updateMessageDeliveryReport(message.getKeyString(), contactNumber);
        BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.MESSAGE_DELIVERY.toString(), message);
        new Thread(new Runnable(){

            @Override
            public void run() {
                MessageClientService.this.updateDeliveryStatus(message, contactNumber, MobiComUserPreference.getInstance(MessageClientService.this.context).getCountryCode());
            }
        }).start();
        if (MobiComUserPreference.getInstance(this.context).isWebHookEnable()) {
            this.processWebHook(message);
        }
    }

    public void processWebHook(Message message) {
    }
}

