/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.notification;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.MobiComMessageService;
import com.applozic.mobicomkit.api.notification.MessageDeleteContent;
import com.applozic.mobicomkit.api.people.ContactContent;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.contact.ContactService;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;

public class MobiComPushReceiver {
    public static final String MTCOM_PREFIX = "MT_";
    public static final List<String> notificationKeyList = new ArrayList<String>();
    private static final String TAG = "MobiComPushReceiver";

    public static boolean isMobiComPushNotification(Context context, Intent intent) {
        String payLoad = intent.getStringExtra("collapse_key");
        Log.i((String)TAG, (String)("Received notification: " + payLoad));
        if (payLoad != null && payLoad.contains(MTCOM_PREFIX) || notificationKeyList.contains(payLoad)) {
            return true;
        }
        for (String key : notificationKeyList) {
            payLoad = intent.getStringExtra(key);
            if (payLoad == null) continue;
            return true;
        }
        return false;
    }

    public static void processMessage(Context context, Intent intent) {
        Bundle extras = intent.getExtras();
        if (extras != null) {
            Gson gson;
            String message = intent.getStringExtra("collapse_key");
            String deleteConversationForContact = intent.getStringExtra(notificationKeyList.get(6));
            String deleteSms = intent.getStringExtra(notificationKeyList.get(4));
            String multipleMessageDelete = intent.getStringExtra(notificationKeyList.get(5));
            String mtexterUser = intent.getStringExtra(notificationKeyList.get(7));
            String payloadForDelivered = intent.getStringExtra(notificationKeyList.get(2));
            MobiComMessageService messageService = new MobiComMessageService(context, MessageIntentService.class);
            if (!TextUtils.isEmpty((CharSequence)payloadForDelivered)) {
                messageService.updateDeliveryStatus(payloadForDelivered);
            }
            if (!TextUtils.isEmpty((CharSequence)deleteConversationForContact)) {
                MobiComConversationService conversationService = new MobiComConversationService(context);
                conversationService.deleteConversationFromDevice(deleteConversationForContact);
                BroadcastService.sendConversationDeleteBroadcast(context, BroadcastService.INTENT_ACTIONS.DELETE_CONVERSATION.toString(), deleteConversationForContact, "success");
            }
            if (!TextUtils.isEmpty((CharSequence)mtexterUser)) {
                Log.i((String)TAG, (String)("Received GCM message MTEXTER_USER: " + mtexterUser));
                if (mtexterUser.contains("{")) {
                    gson = new Gson();
                    ContactContent contactContent = (ContactContent)gson.fromJson(mtexterUser, ContactContent.class);
                    ContactService.addUsersToContact(context, contactContent.getContactNumber(), contactContent.getAppVersion(), true);
                } else {
                    String[] details = mtexterUser.split(",");
                    ContactService.addUsersToContact(context, details[0], Short.parseShort(details[1]), true);
                }
            }
            if (!TextUtils.isEmpty((CharSequence)multipleMessageDelete)) {
                gson = new GsonBuilder().setPrettyPrinting().create();
                MessageDeleteContent messageDeleteContent = (MessageDeleteContent)gson.fromJson(multipleMessageDelete, MessageDeleteContent.class);
                for (String deletedSmsKeyString : messageDeleteContent.getDeleteKeyStrings()) {
                    MobiComPushReceiver.processDeleteSingleMessageRequest(context, deletedSmsKeyString, messageDeleteContent.getContactNumber());
                }
            }
            if (!TextUtils.isEmpty((CharSequence)deleteSms)) {
                String contactNumbers = deleteSms.split(",").length > 1 ? deleteSms.split(",")[1] : null;
                MobiComPushReceiver.processDeleteSingleMessageRequest(context, deleteSms.split(",")[0], contactNumbers);
            }
            if (!notificationKeyList.get(1).equalsIgnoreCase(message)) {
                if (notificationKeyList.get(0).equalsIgnoreCase(message)) {
                    messageService.syncMessages();
                } else if (notificationKeyList.get(3).equalsIgnoreCase(message)) {
                    // empty if block
                }
            }
        }
    }

    private static void processDeleteSingleMessageRequest(Context context, String deletedSmsKeyString, String contactNumber) {
        MobiComConversationService conversationService = new MobiComConversationService(context);
        contactNumber = conversationService.deleteMessageFromDevice(deletedSmsKeyString, contactNumber);
        BroadcastService.sendMessageDeleteBroadcast(context, BroadcastService.INTENT_ACTIONS.DELETE_MESSAGE.toString(), deletedSmsKeyString, contactNumber);
    }

    public static void processMessageAsync(final Context context, final Intent intent) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                MobiComPushReceiver.processMessage(context, intent);
            }
        }).start();
    }

    static {
        notificationKeyList.add("MT_SYNC");
        notificationKeyList.add("MT_MARK_ALL_MESSAGE_AS_READ");
        notificationKeyList.add("MT_DELIVERED");
        notificationKeyList.add("MT_SYNC_PENDING");
        notificationKeyList.add("MT_DELETE_MESSAGE");
        notificationKeyList.add("MT_DELETE_MULTIPLE_MESSAGE");
        notificationKeyList.add("MT_DELETE_MESSAGE_CONTACT");
        notificationKeyList.add("MTEXTER_USER");
        notificationKeyList.add("MT_CONTACT_VERIFIED");
        notificationKeyList.add("MT_CONTACT_UPDATED");
        notificationKeyList.add("MT_DEVICE_CONTACT_SYNC");
        notificationKeyList.add("MT_EMAIL_VERIFIED");
        notificationKeyList.add("MT_DEVICE_CONTACT_MESSAGE");
        notificationKeyList.add("MT_CANCEL_CALL");
        notificationKeyList.add("MT_MESSAGE");
    }
}

