/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.JsonMarker;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicommons.commons.core.utils.ContactNumberUtils;
import com.applozic.mobicommons.file.FileUtils;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Message
extends JsonMarker {
    private Long createdAtTime = new Date().getTime();
    private String to;
    private String message;
    private String keyString;
    private String deviceKeyString;
    private String suUserKeyString;
    private boolean sent;
    private Boolean delivered;
    private Short type = MessageType.MT_OUTBOX.getValue();
    private boolean storeOnDevice;
    private String contactIds = "";
    private Long broadcastGroupId;
    private boolean sendToDevice;
    private Long scheduledAt;
    private Short source = Source.MT_MOBILE_APP.getValue();
    private Integer timeToLive;
    private boolean sentToServer = true;
    private List<String> fileMetaKeyStrings;
    private List<String> filePaths;
    private String pairedMessageKeyString;
    private long sentMessageTimeAtServer;
    private boolean canceled = false;
    private List<FileMeta> fileMetas;
    @SerializedName(value="id")
    private Long messageId;
    private boolean read = false;
    private boolean attDownloadInProgress;

    public Message() {
    }

    public Message(String to, String body) {
        this.to = to;
        this.message = body;
    }

    public Message(Message message) {
        this.setMessage(message.getMessage());
        this.setContactIds(message.getContactIds());
        this.setCreatedAtTime(message.getCreatedAtTime());
        this.setDeviceKeyString(message.getDeviceKeyString());
        this.setSendToDevice(message.isSendToDevice());
        this.setTo(message.getTo());
        this.setType(message.getType());
        this.setSent(message.isSent());
        this.setDelivered(message.getDelivered());
        this.setStoreOnDevice(message.isStoreOnDevice());
        this.setScheduledAt(message.getScheduledAt());
        this.setSentToServer(message.isSentToServer());
        this.setSource(message.getSource());
        this.setTimeToLive(message.getTimeToLive());
        this.setFileMetas(message.getFileMetas());
        this.setFileMetaKeyStrings(message.getFileMetaKeyStrings());
        this.setFilePaths(message.getFilePaths());
        this.setBroadcastGroupId(message.getBroadcastGroupId());
        this.setRead(message.isRead());
    }

    public long getSentMessageTimeAtServer() {
        return this.sentMessageTimeAtServer;
    }

    public void setSentMessageTimeAtServer(long sentMessageTimeAtServer) {
        this.sentMessageTimeAtServer = sentMessageTimeAtServer;
    }

    public boolean isAttDownloadInProgress() {
        return this.attDownloadInProgress;
    }

    public void setAttDownloadInProgress(boolean attDownloadInProgress) {
        this.attDownloadInProgress = attDownloadInProgress;
    }

    public boolean isRead() {
        return this.read || this.isTypeOutbox() || this.getScheduledAt() != null;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public boolean isSelfDestruct() {
        return this.getTimeToLive() != null;
    }

    public boolean isUploadRequired() {
        return this.hasAttachment() && (this.fileMetas == null || this.fileMetas.isEmpty());
    }

    public boolean hasAttachment() {
        return this.filePaths != null && !this.filePaths.isEmpty() || this.fileMetas != null && !this.fileMetas.isEmpty();
    }

    public boolean isAttachmentUploadInProgress() {
        return this.filePaths != null && !this.filePaths.isEmpty() && (this.getFileMetaKeyStrings() == null || this.getFileMetaKeyStrings().isEmpty());
    }

    public boolean isAttachmentDownloaded() {
        return this.filePaths != null && !this.filePaths.isEmpty() && FileUtils.isFileExist((String)this.filePaths.get(0));
    }

    public boolean isCall() {
        return MessageType.CALL_INCOMING.getValue().equals(this.type) || MessageType.CALL_OUTGOING.getValue().equals(this.type);
    }

    public boolean isOutgoingCall() {
        return MessageType.CALL_OUTGOING.getValue().equals(this.type);
    }

    public boolean isIncomingCall() {
        return MessageType.CALL_INCOMING.getValue().equals(this.type);
    }

    public Long getMessageId() {
        return this.messageId;
    }

    public void setMessageId(Long messageId) {
        this.messageId = messageId;
    }

    public boolean isDummyEmptyMessage() {
        return this.getCreatedAtTime() != null && this.getCreatedAtTime() == 0L && TextUtils.isEmpty((CharSequence)this.getMessage());
    }

    public boolean isLocalMessage() {
        return TextUtils.isEmpty((CharSequence)this.getKeyString()) && this.isSentToServer();
    }

    public String getKeyString() {
        return this.keyString;
    }

    public void setKeyString(String keyString) {
        this.keyString = keyString;
    }

    public Long getCreatedAtTime() {
        return this.createdAtTime;
    }

    public void setCreatedAtTime(Long createdAtTime) {
        this.createdAtTime = createdAtTime;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getMessage() {
        return this.message == null ? "" : this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isSent() {
        return this.sent;
    }

    public void setSent(boolean sent) {
        this.sent = sent;
    }

    public Boolean getDelivered() {
        return this.delivered != null ? this.delivered : false;
    }

    public void setDelivered(Boolean delivered) {
        this.delivered = delivered;
    }

    public boolean isStoreOnDevice() {
        return this.storeOnDevice;
    }

    public void setStoreOnDevice(boolean storeOnDevice) {
        this.storeOnDevice = storeOnDevice;
    }

    public String getDeviceKeyString() {
        return this.deviceKeyString;
    }

    public void setDeviceKeyString(String deviceKeyString) {
        this.deviceKeyString = deviceKeyString;
    }

    public String getSuUserKeyString() {
        return this.suUserKeyString;
    }

    public void setSuUserKeyString(String suUserKeyString) {
        this.suUserKeyString = suUserKeyString;
    }

    public Short getType() {
        return this.type;
    }

    public void setType(Short type) {
        this.type = type;
    }

    public void processContactIds(Context context) {
        MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(context);
        if (TextUtils.isEmpty((CharSequence)this.getContactIds())) {
            if (userPreferences.getCountryCode() != null) {
                this.setContactIds(ContactNumberUtils.getPhoneNumber((String)this.getTo(), (String)userPreferences.getCountryCode()));
            } else {
                this.setContactIds(this.getTo());
            }
        }
    }

    public String getContactIds() {
        return this.contactIds;
    }

    public void setContactIds(String contactIds) {
        this.contactIds = contactIds;
    }

    public Long getBroadcastGroupId() {
        return this.broadcastGroupId;
    }

    public void setBroadcastGroupId(Long broadcastGroupId) {
        this.broadcastGroupId = broadcastGroupId;
    }

    public boolean isSendToDevice() {
        return this.sendToDevice;
    }

    public void setSendToDevice(boolean sendToDevice) {
        this.sendToDevice = sendToDevice;
    }

    public Long getScheduledAt() {
        return this.scheduledAt;
    }

    public void setScheduledAt(Long scheduledAt) {
        this.scheduledAt = scheduledAt;
    }

    public boolean isSentToMany() {
        return !TextUtils.isEmpty((CharSequence)this.getTo()) && this.getTo().split(",").length > 1;
    }

    public boolean isSentToServer() {
        return this.sentToServer;
    }

    public void setSentToServer(boolean sentToServer) {
        this.sentToServer = sentToServer;
    }

    public boolean isTypeOutbox() {
        return MessageType.OUTBOX.getValue().equals(this.type) || MessageType.MT_OUTBOX.getValue().equals(this.type) || MessageType.OUTBOX_SENT_FROM_DEVICE.getValue().equals(this.type) || MessageType.CALL_OUTGOING.getValue().equals(this.type);
    }

    public boolean isSentViaApp() {
        return MessageType.MT_OUTBOX.getValue().equals(this.type);
    }

    public boolean isSentViaCarrier() {
        return MessageType.OUTBOX.getValue().equals(this.type);
    }

    public Short getSource() {
        return this.source;
    }

    public void setSource(Short source) {
        this.source = source;
    }

    public Integer getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(Integer timeToLive) {
        this.timeToLive = timeToLive;
    }

    public List<String> getFileMetaKeyStrings() {
        return this.fileMetaKeyStrings;
    }

    public void setFileMetaKeyStrings(List<String> fileMetaKeyStrings) {
        this.fileMetaKeyStrings = fileMetaKeyStrings;
    }

    public List<String> getFilePaths() {
        return this.filePaths;
    }

    public void setFilePaths(List<String> filePaths) {
        this.filePaths = filePaths;
    }

    public String getPairedMessageKeyString() {
        return this.pairedMessageKeyString;
    }

    public void setPairedMessageKeyString(String pairedMessageKeyString) {
        this.pairedMessageKeyString = pairedMessageKeyString;
    }

    public List<FileMeta> getFileMetas() {
        return this.fileMetas;
    }

    public void setFileMetas(List<FileMeta> fileMetas) {
        this.fileMetas = fileMetas;
        if (this.getFileMetas() != null && !this.getFileMetas().isEmpty()) {
            this.fileMetaKeyStrings = new ArrayList<String>();
            for (FileMeta filemeta : this.getFileMetas()) {
                this.fileMetaKeyStrings.add(filemeta.getKeyString());
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        if (this.getMessageId() != null && message.getMessageId() != null && this.getMessageId().equals(message.getMessageId())) {
            return true;
        }
        if (this.getKeyString() != null && message.getKeyString() != null) {
            return this.getKeyString().equals(message.getKeyString());
        }
        return false;
    }

    public int hashCode() {
        int result = this.keyString != null ? this.keyString.hashCode() : 0;
        result = 31 * result + (this.messageId != null ? this.messageId.hashCode() : 0);
        return result;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public String toString() {
        return "Message{createdAtTime=" + this.createdAtTime + ", id=" + this.messageId + ", to='" + this.to + '\'' + ", message='" + this.message + '\'' + ", keyString='" + this.keyString + '\'' + ", deviceKeyString='" + this.deviceKeyString + '\'' + ", suUserKeyString='" + this.suUserKeyString + '\'' + ", sent=" + this.sent + ", delivered=" + this.delivered + ", type=" + this.type + ", storeOnDevice=" + this.storeOnDevice + ", contactIds='" + this.contactIds + '\'' + ", sendToDevice=" + this.sendToDevice + ", scheduledAt=" + this.scheduledAt + ", source=" + this.source + ", timeToLive=" + this.timeToLive + ", pairedMessageKeyString=" + this.pairedMessageKeyString + ", sentToServer=" + this.sentToServer + ", broadcastGroupId=" + this.broadcastGroupId + ", fileMetaKeyStrings=" + this.getFileMetaKeyStrings() + ", filePaths=" + this.filePaths + ", fileMetas=" + this.fileMetas + '}';
    }

    public static enum MessageType {
        INBOX(Short.valueOf("0")),
        OUTBOX(Short.valueOf("1")),
        DRAFT(Short.valueOf("2")),
        OUTBOX_SENT_FROM_DEVICE(Short.valueOf("3")),
        MT_INBOX(Short.valueOf("4")),
        MT_OUTBOX(Short.valueOf("5")),
        CALL_INCOMING(Short.valueOf("6")),
        CALL_OUTGOING(Short.valueOf("7"));

        private Short value;

        private MessageType(Short c) {
            this.value = c;
        }

        public Short getValue() {
            return this.value;
        }
    }

    public static enum Source {
        DEVICE_NATIVE_APP(Short.valueOf("0")),
        WEB(Short.valueOf("1")),
        MT_MOBILE_APP(Short.valueOf("2")),
        API(Short.valueOf("3"));

        private Short value;

        private Source(Short c) {
            this.value = c;
        }

        public Short getValue() {
            return this.value;
        }
    }
}

