/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import com.applovin.impl.sdk.h;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.impl.sdk.utils.n;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.sdk.AppLovinSdk;

public abstract class MediationAdapterBase
implements MaxAdapter {
    protected static final String KEY_MUTED = "muted";
    private final AppLovinSdk mWrappingSdk;
    private final h mSdk;
    private final String mTag;

    protected static String mediationTag() {
        return "AppLovinSdk_9.4.0";
    }

    public MediationAdapterBase(AppLovinSdk appLovinSdk) {
        this.mWrappingSdk = appLovinSdk;
        this.mSdk = n.a(appLovinSdk);
        this.mTag = this.getClass().getSimpleName();
    }

    protected AppLovinSdk getWrappingSdk() {
        return this.mWrappingSdk;
    }

    protected h getSdk() {
        return this.mSdk;
    }

    protected void log(String string) {
        Log.i((String)this.mTag, (String)string);
    }

    protected void log(String string, Throwable throwable) {
        Log.i((String)this.mTag, (String)string, (Throwable)throwable);
    }

    protected void checkExistence(Class<?> ... classArray) {
        if (classArray != null && classArray.length > 0) {
            for (Class<?> clazz : classArray) {
                this.log("Found: " + clazz.getName());
            }
        }
    }

    protected void checkActivities(Context context, Class<?> ... classArray) {
        if (classArray != null && classArray.length > 0) {
            for (Class<?> clazz : classArray) {
                try {
                    ComponentName componentName = new ComponentName(context, clazz);
                    ActivityInfo activityInfo = context.getPackageManager().getActivityInfo(componentName, 128);
                    if (activityInfo == null) {
                        throw new PackageManager.NameNotFoundException("null_activity_info");
                    }
                    this.log("Found defined activity: " + clazz.getName());
                }
                catch (Throwable throwable) {
                    this.log("No activity found for: " + clazz);
                    throw new IllegalStateException("Activity " + clazz.getName() + " not defined", throwable);
                }
            }
        }
    }

    protected MaxReward getReward(MaxAdapterResponseParameters maxAdapterResponseParameters) {
        Bundle bundle = maxAdapterResponseParameters.getServerParameters();
        int n2 = BundleUtils.getInt("amount", 0, bundle);
        String string = BundleUtils.getString("currency", "", bundle);
        this.log("Creating reward: " + n2 + " " + string);
        return MaxReward.create(n2, string);
    }
}

