package com.applovin.nativeAds;

/**
 * Service which allows loading and pre-caching of native ads.
 */
public interface AppLovinNativeAdService
{
    /**
     * Load a native ad asynchronously.
     *
     * @param callback The native ad load callback to notify upon completion.
     */
    void loadNextAd(final AppLovinNativeAdLoadListener callback);

    /**
     * Pre-cache image and video resources of a native ad.
     *
     * @param ad       The native ad whose resources should be cached.
     * @param listener The listener to notify upon completion.
     */
    void precacheResources(final AppLovinNativeAd ad, final AppLovinNativeAdPrecacheListener listener);

    /**
     * @deprecated Manually preloading ads in the background has been deprecated and will be removed in a future SDK version.
     * Please use {@link AppLovinNativeAdService#loadNextAd(AppLovinNativeAdLoadListener)} to load ads.
     */
    @Deprecated
    void preloadAdForZoneId(final String zoneId);

    /**
     * @deprecated Manually preloading ads in the background has been deprecated and will be removed in a future SDK version.
     * Please use {@link AppLovinNativeAdService#loadNextAd(AppLovinNativeAdLoadListener)} to load ads.
     */
    @Deprecated
    boolean hasPreloadedAdForZoneId(final String zoneId);

    /**
     * @deprecated Loading multiple native ads has been deprecated and will be removed in a future SDK version. Please use  {@link AppLovinNativeAdService#loadNextAd} instead.
     */
    @Deprecated
    void loadNativeAds(final int numAdsToLoad, final AppLovinNativeAdLoadListener listener);

    /**
     * @deprecated Loading multiple native ads has been deprecated and will be removed in a future SDK version. Please use  {@link AppLovinNativeAdService#loadNextAd} instead.
     */
    @Deprecated
    void loadNativeAds(final int numAdsToLoad, final String zoneId, final AppLovinNativeAdLoadListener listener);
}
