package com.applovin.mediation;

public class MaxErrorCodes
{
    /**
     * Indicates that the system is in unexpected state.
     */
    public static final int UNSPECIFIED_ERROR = -1;

    /**
     * Indicates that no ads are currently eligible for your device.
     */
    public static final int NO_FILL = 204;

    /**
     * Indicates that a AppLovin servers have returned an invalid response
     */
    public static final int INVALID_RESPONSE = -800;

    /**
     * Indicates that an attempt to show a fullscreen ad (interstitial or rewarded) was made while another fullscreen ad is still showing.
     */
    public static final int FULLSCREEN_AD_ALREADY_SHOWING = -23;

    /**
     * Indicates that the mediation adapter has failed to load.
     */
    public static final int MEDIATION_ADAPTER_LOAD_FAILED = -5001;

    /**
     * Indicates that the mediation adapter was requested to render an ad that was not marked as ready.
     */
    public static final int MEDIATION_ADAPTER_AD_NOT_READY = -5002;

    /**
     * Indicates that the mediated ad has failed due to a timeout.
     */
    public static final int MEDIATION_ADAPTER_TIMEOUT = -5101;

    /**
     * Indicates that the mediated ad has failed immediately (due to a 0 timeout).
     */
    public static final int MEDIATION_ADAPTER_IMMEDIATE_TIMEOUT = -5102;

    /**
     * Indicates that the mediation adapter was disabled.
     */
    public static final int MEDIATION_ADAPTER_DISABLED = -5103;

    /**
     * Indicates that the mediation adapter is not of an expected type.
     */
    public static final int MEDIATION_ADAPTER_WRONG_TYPE = -5104;

    /**
     * Internal state of the SDK is invalid.
     */
    public static final int INVALID_INTERNAL_STATE = -5201;

    /**
     * Current ad type is not supported by the mediation framework.
     */
    public static final int FORMAT_TYPE_NOT_SUPPORTED = -5501;

    /**
     * Main activity reference garbage collected.
     */
    public static final int NO_ACTIVITY = -5601;
}
