package com.applovin.mediation;

/**
 * This interface represents an ad that has been served by AppLovin's mediation server and should be displayed to the user.
 */
public interface MaxAd
{
    /**
     * Get format of this ad.
     *
     * @return Loaded ad format. Guaranteed not to be null.
     */
    MaxAdFormat getFormat();

    /**
     * The ad unit id for which this ad was loaded.
     *
     * @return Ad unit identifier. Guaranteed not to be null.
     */
    String getAdUnitId();

    /**
     * Check if the ad is ready to be displayed.
     *
     * @return <code>true</code> if the ad is ready to be displayed.
     */
    boolean isReady();
}
