package com.applovin.mediation;

/**
 * This interface represents an ad that has been served by AppLovin's mediation server and should be displayed to the user.
 */
public interface MaxAd
{
    /**
     * @return Loaded ad format. Guaranteed not to be null.
     */
    MaxAdFormat getFormat();

    /**
     * @return Ad unit id for which this ad was loaded. Guaranteed not to be null.
     */
    String getAdUnitId();

    /**
     * @return The ad network for which this ad was loaded from. Guaranteed not to be null.
     */
    String getNetworkName();

    /**
     * @return The ad placement which was set for this ad. May be null.
     */
    String getPlacement();

    /**
     * The creative id tied to the ad, if any. It may not be available for some ad networks until {@code MaxFullscreenAdListener#onAdDisplayed()} is called.
     *
     * @return The ad's creative ID, if available. May be null.
     */
    String getCreativeId();
}
