package com.applovin.adview;

import android.content.Context;
import android.graphics.PointF;
import android.util.AttributeSet;

import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinSdk;

/**
 * This interface represents a controller for an Ad view. The controller is responsible for handling all view operations.
 *
 * @author Basil Shikin
 * @deprecated - This is for internal use only and will be removed in a later SDK version.
 */
@Deprecated
public interface AdViewController
{
    /**
     * Start loading next advertisement. This method will return immediately. An advertisement will be rendered by this view when available.
     */
    void loadNextAd();

    /**
     * Check if an ad is currently preloaded and ready to be displayed.
     *
     * @return True if a subsequent call to a show method will result in an immediate display. False if a call to a show method will require network activity first.
     */
    boolean isAdReadyToDisplay();

    /**
     * Set a callback that would be notified of ad loading events. These include add loaded and ad failed to load events
     *
     * @param callback A callback to be notified of ad loading events.
     */
    void setAdLoadListener(final AppLovinAdLoadListener callback);

    /**
     * Set a callback that would be notified of ad display events. These include add displayed and ad hidden.
     *
     * @param callback A callback to be notified of ad loading events.
     */
    void setAdDisplayListener(final AppLovinAdDisplayListener callback);

    /**
     * Set a callback that would be notified of ad click events.
     *
     * @param callback A callback to be notified of ad click events.
     */
    void setAdClickListener(final AppLovinAdClickListener callback);

    /**
     * Set a callback that would be notified of ad view events.
     *
     * @param callback A callback to be notified of ad view events.
     */
    void setAdViewEventListener(final AppLovinAdViewEventListener callback);

    /**
     * Render specified ad.
     *
     * @param ad Ad to render. Must not be null.
     */
    void renderAd(final AppLovinAd ad);

    /**
     * Initialize the controller using specified parameters
     *
     * @param parentView     Parent ad view. Must not be null.
     * @param context        Parent context. Must be an Activity. Must not be null.
     * @param size           Desired ad size. May be null.
     * @param zoneId         Desired zone id. May be null.
     * @param sdk            SDK to use. May be null.
     * @param viewAttributes View attributes. May be null.
     */
    void initializeAdView(final AppLovinAdView parentView, final Context context, final AppLovinAdSize size, final String zoneId, final AppLovinSdk sdk, final AttributeSet viewAttributes);

    /**
     * Cleanup view's resources
     */
    void destroy();

    /**
     * Get current ad size
     *
     * @return Get current size
     */
    AppLovinAdSize getSize();

    /**
     * Get current zone
     *
     * @return Get current zone id
     */
    String getZoneId();

    /**
     * Pause and clean current ad
     */
    void pause();

    /**
     * Resume rendering of the current ad
     */
    void resume();

    /**
     * This method is used to notify the controller of the fact that the view has been detached from the window.
     * <p>
     * <b>Please note:</b> This method is for internal use only.
     * </p>
     *
     * @hide
     */
    void onAttachedToWindow();

    /**
     * This method is used to notify the controller of the fact that the view has been detached from the window.
     * <p>
     * <p>
     * <b>Please note:</b> This method is for internal use only.
     * </p>
     *
     * @hide
     */
    void onDetachedFromWindow();

    /**
     * This method is used to expand current ad to full-screen.
     *
     * @param clickLocation The location on screen associated with this click.
     */
    void expandAd(final PointF clickLocation);

    /**
     * This method is used to contract an ad expanded with @link{expandAd()} back.
     */
    void contractAd();

    /**
     * @deprecated Placements have been deprecated and will be removed in a future SDK version. Please configure zones from the UI and use them instead.
     */
    @Deprecated
    void renderAd(final AppLovinAd ad, final String placement);
}
