/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.sdk;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class AppLovinAdSize {
    public static final int SPAN = -1;
    public static final AppLovinAdSize BANNER = new AppLovinAdSize(-1, 50, "BANNER");
    public static final AppLovinAdSize LEADER = new AppLovinAdSize(-1, 90, "LEADER");
    public static final AppLovinAdSize INTERSTITIAL = new AppLovinAdSize(-1, -1, "INTER");
    @Deprecated
    public static final AppLovinAdSize MREC = new AppLovinAdSize(300, 250, "MREC");
    @Deprecated
    public static final AppLovinAdSize NATIVE = new AppLovinAdSize("NATIVE");
    private final int a;
    private final int b;
    private final String c;

    private AppLovinAdSize(String string2) {
        this(0, 0, string2);
    }

    private AppLovinAdSize(int n2, int n3, String string2) {
        if (n2 < 0 && n2 != -1) {
            throw new IllegalArgumentException("Ad width must be a positive number. Number provided: " + n2);
        }
        if (n2 > 9999) {
            throw new IllegalArgumentException("Ad width must be less then 9999. Number provided: " + n2);
        }
        if (n3 < 0 && n3 != -1) {
            throw new IllegalArgumentException("Ad height must be a positive number. Number provided: " + n3);
        }
        if (n3 > 9999) {
            throw new IllegalArgumentException("Ad height must be less then 9999. Number provided: " + n3);
        }
        if (string2 == null) {
            throw new IllegalArgumentException("No label specified");
        }
        if (string2.length() > 9) {
            throw new IllegalArgumentException("Provided label is too long. Label provided: " + string2);
        }
        this.a = n2;
        this.b = n3;
        this.c = string2;
    }

    public int getWidth() {
        return this.a;
    }

    public int getHeight() {
        return this.b;
    }

    public String getLabel() {
        return this.c.toUpperCase(Locale.ENGLISH);
    }

    public String toString() {
        return this.getLabel();
    }

    public static AppLovinAdSize fromString(String string2) {
        if ("BANNER".equalsIgnoreCase(string2)) {
            return BANNER;
        }
        if ("MREC".equalsIgnoreCase(string2)) {
            return MREC;
        }
        if ("LEADER".equalsIgnoreCase(string2)) {
            return LEADER;
        }
        if ("INTERSTITIAL".equalsIgnoreCase(string2) || "INTER".equalsIgnoreCase(string2)) {
            return INTERSTITIAL;
        }
        if ("NATIVE".equalsIgnoreCase(string2)) {
            return NATIVE;
        }
        throw new IllegalArgumentException("Unknown Ad Size: " + string2);
    }

    public static Set<AppLovinAdSize> allSizes() {
        HashSet<AppLovinAdSize> hashSet = new HashSet<AppLovinAdSize>(4);
        hashSet.add(BANNER);
        hashSet.add(MREC);
        hashSet.add(INTERSTITIAL);
        hashSet.add(LEADER);
        return hashSet;
    }
}

