/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk;

import android.text.TextUtils;
import com.applovin.impl.sdk.ad.b;
import com.applovin.impl.sdk.ad.d;
import com.applovin.impl.sdk.ad.h;
import com.applovin.impl.sdk.ad.j;
import com.applovin.impl.sdk.l;
import com.applovin.impl.sdk.utils.i;
import com.applovin.impl.sdk.utils.n;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinAdType;
import java.util.Arrays;
import org.json.JSONObject;

public abstract class AppLovinAdBase
implements j,
AppLovinAd {
    protected final JSONObject adObject;
    protected final JSONObject fullResponse;
    protected final l sdk;
    protected final b source;
    private final int a;
    private d b;
    protected final Object adObjectLock;
    protected final Object fullResponseLock;
    private final long c;
    private h d;

    protected AppLovinAdBase(JSONObject jSONObject, JSONObject jSONObject2, b b2, l l2) {
        if (jSONObject == null) {
            throw new IllegalArgumentException("No ad object specified");
        }
        if (jSONObject2 == null) {
            throw new IllegalArgumentException("No response specified");
        }
        if (l2 == null) {
            throw new IllegalArgumentException("No sdk specified");
        }
        this.adObject = jSONObject;
        this.fullResponse = jSONObject2;
        this.source = b2;
        this.sdk = l2;
        this.adObjectLock = new Object();
        this.fullResponseLock = new Object();
        this.c = System.currentTimeMillis();
        char[] cArray = jSONObject.toString().toCharArray();
        Arrays.sort(cArray);
        this.a = new String(cArray).hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRawFullResponse() {
        Object object = this.fullResponseLock;
        synchronized (object) {
            return this.fullResponse.toString();
        }
    }

    public l getSdk() {
        return this.sdk;
    }

    public boolean hasVideoUrl() {
        this.sdk.x().e("AppLovinAdBase", "Attempting to invoke hasVideoUrl() from base ad class");
        return false;
    }

    public boolean hasShown() {
        return this.getBooleanFromAdObject("shown", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHasShown(boolean bl) {
        try {
            Object object = this.adObjectLock;
            synchronized (object) {
                this.adObject.put("shown", bl);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean shouldCancelHtmlCachingIfShown() {
        return this.getBooleanFromAdObject("chcis", false);
    }

    @Override
    public long getAdIdNumber() {
        return this.getLongFromAdObject("ad_id", -1L);
    }

    @Override
    public AppLovinAdSize getSize() {
        String string2 = this.getStringFromFullResponse("ad_size", null);
        return AppLovinAdSize.fromString(string2);
    }

    @Override
    public AppLovinAdType getType() {
        String string2 = this.getStringFromFullResponse("ad_type", null);
        return AppLovinAdType.fromString(string2);
    }

    @Override
    public String getZoneId() {
        return this.getAdZone().j() ? null : this.getStringFromFullResponse("zone_id", null);
    }

    public long getCreatedAtMillis() {
        return this.c;
    }

    @Override
    public boolean isVideoAd() {
        if (this.adObject.has("is_video_ad")) {
            return this.getBooleanFromAdObject("is_video_ad", false);
        }
        return this.hasVideoUrl();
    }

    @Override
    public String getAdValue(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = this.getJsonObjectFromAdObject("ad_values", null);
        if (jSONObject != null && jSONObject.length() > 0) {
            return i.b(jSONObject, string2, null, this.sdk);
        }
        return null;
    }

    public String getClCode() {
        String string2 = this.getStringFromAdObject("clcode", "");
        if (n.b(string2)) {
            return string2;
        }
        return this.getStringFromFullResponse("clcode", "");
    }

    public String getPrimaryKey() {
        return this.getStringFromAdObject("pk", "NA");
    }

    public String getSecondaryKey1() {
        return this.getStringFromAdObject("sk1", null);
    }

    public String getSecondaryKey2() {
        return this.getStringFromAdObject("sk2", null);
    }

    public long getFetchLatencyMillis() {
        return this.getLongFromFullResponse("ad_fetch_latency_millis", -1L);
    }

    public long getFetchResponseSize() {
        return this.getLongFromFullResponse("ad_fetch_response_size", -1L);
    }

    public d getAdZone() {
        if (this.b != null) {
            if (this.b.c() != null && this.b.d() != null) {
                return this.b;
            }
            if (this.getSize() == null && this.getType() == null) {
                return this.b;
            }
        }
        String string2 = this.getStringFromFullResponse("zone_id", null);
        this.b = com.applovin.impl.sdk.ad.d.a(this.getSize(), this.getType(), string2, this.sdk);
        return this.b;
    }

    public b getSource() {
        return this.source;
    }

    public h getDummyAd() {
        return this.d;
    }

    public void setDummyAd(h h2) {
        this.d = h2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsKeyForAdObject(String string2) {
        Object object = this.adObjectLock;
        synchronized (object) {
            return this.adObject.has(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getBooleanFromAdObject(String string2, Boolean bl) {
        Object object = this.adObjectLock;
        synchronized (object) {
            return i.a(this.adObject, string2, bl, this.sdk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float getFloatFromAdObject(String string2, float f2) {
        Object object = this.adObjectLock;
        synchronized (object) {
            return i.a(this.adObject, string2, f2, this.sdk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getIntFromAdObject(String string2, int n2) {
        Object object = this.adObjectLock;
        synchronized (object) {
            return i.b(this.adObject, string2, n2, this.sdk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONObject getJsonObjectFromAdObject(String string2, JSONObject jSONObject) {
        Object object = this.adObjectLock;
        synchronized (object) {
            return i.b(this.adObject, string2, jSONObject, this.sdk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getLongFromAdObject(String string2, long l2) {
        Object object = this.adObjectLock;
        synchronized (object) {
            return i.a(this.adObject, string2, l2, this.sdk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStringFromAdObject(String string2, String string3) {
        Object object = this.adObjectLock;
        synchronized (object) {
            return i.b(this.adObject, string2, string3, this.sdk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getBooleanFromFullResponse(String string2, boolean bl) {
        Object object = this.fullResponseLock;
        synchronized (object) {
            return i.a(this.fullResponse, string2, (Boolean)bl, this.sdk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float getFloatFromFullResponse(String string2, float f2) {
        Object object = this.fullResponseLock;
        synchronized (object) {
            return i.a(this.fullResponse, string2, f2, this.sdk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getIntFromFullResponse(String string2, int n2) {
        Object object = this.fullResponseLock;
        synchronized (object) {
            return i.b(this.fullResponse, string2, n2, this.sdk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONObject getJsonObjectFromFullResponse(String string2, JSONObject jSONObject) {
        Object object = this.fullResponseLock;
        synchronized (object) {
            return i.b(this.fullResponse, string2, jSONObject, this.sdk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getLongFromFullResponse(String string2, long l2) {
        Object object = this.fullResponseLock;
        synchronized (object) {
            return i.a(this.fullResponse, string2, l2, this.sdk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStringFromFullResponse(String string2, String string3) {
        Object object = this.fullResponseLock;
        synchronized (object) {
            return i.b(this.fullResponse, string2, string3, this.sdk);
        }
    }

    public boolean equals(Object object) {
        AppLovinAdBase appLovinAdBase;
        AppLovinAd appLovinAd;
        if (object instanceof h && (appLovinAd = (appLovinAdBase = (h)object).b()) != null) {
            object = appLovinAd;
        }
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        appLovinAdBase = (AppLovinAdBase)object;
        if (this.b != null ? !this.b.equals(((AppLovinAdBase)appLovinAdBase).b) : ((AppLovinAdBase)appLovinAdBase).b != null) {
            return false;
        }
        if (this.source != appLovinAdBase.source) {
            return false;
        }
        return this.a == ((AppLovinAdBase)appLovinAdBase).a;
    }

    public int hashCode() {
        return this.a;
    }

    public String toString() {
        return "AppLovinAd{adIdNumber=" + this.getAdIdNumber() + ", source=" + (Object)((Object)this.getSource()) + ", zoneId='" + this.getZoneId() + "'" + '}';
    }
}

