/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.sdk;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.ImageView;
import com.applovin.impl.sdk.utils.g;
import com.applovin.impl.sdk.utils.i;
import com.applovin.impl.sdk.utils.r;
import java.io.File;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class AppLovinSdkUtils {
    private static final Handler a = new Handler(Looper.getMainLooper());

    public static int dpToPx(Context context, int n2) {
        return (int)TypedValue.applyDimension((int)1, (float)n2, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static int pxToDp(Context context, int n2) {
        return (int)Math.ceil((float)n2 / context.getResources().getDisplayMetrics().density);
    }

    public static boolean isTablet(Context context) {
        Point point = g.a(context);
        int n2 = Math.min(point.x, point.y);
        return n2 >= AppLovinSdkUtils.dpToPx(context, 600);
    }

    public static boolean isValidString(String string2) {
        return !TextUtils.isEmpty((CharSequence)string2);
    }

    public static void safePopulateImageView(ImageView imageView, Uri uri, int n2) {
        AppLovinSdkUtils.a(imageView);
        File file = new File(uri.getPath());
        Bitmap bitmap = r.a(file, n2);
        if (bitmap != null) {
            imageView.setImageBitmap(bitmap);
        }
    }

    public static void safePopulateImageView(Context context, ImageView imageView, int n2, int n3) {
        AppLovinSdkUtils.a(imageView);
        Bitmap bitmap = r.a(context, n2, n3);
        if (bitmap != null) {
            imageView.setImageBitmap(bitmap);
        }
    }

    public static void safePopulateImageView(ImageView imageView, Bitmap bitmap) {
        AppLovinSdkUtils.a(imageView);
        if (imageView != null && bitmap != null) {
            imageView.setImageBitmap(bitmap);
        }
    }

    public static void runOnUiThread(Runnable runnable) {
        AppLovinSdkUtils.runOnUiThread(false, runnable);
    }

    public static void runOnUiThread(boolean bl, Runnable runnable) {
        if (!bl && r.b()) {
            runnable.run();
        } else {
            a.post(runnable);
        }
    }

    public static void runOnUiThreadDelayed(Runnable runnable, long l2) {
        AppLovinSdkUtils.runOnUiThreadDelayed(runnable, l2, a);
    }

    public static void runOnUiThreadDelayed(Runnable runnable, long l2, Handler handler) {
        if (l2 > 0L) {
            handler.postDelayed(runnable, l2);
        } else if (r.b()) {
            runnable.run();
        } else {
            handler.post(runnable);
        }
    }

    private static void a(ImageView imageView) {
        Drawable drawable2;
        if (imageView != null && (drawable2 = imageView.getDrawable()) instanceof BitmapDrawable) {
            BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable2;
            Bitmap bitmap = bitmapDrawable.getBitmap();
            bitmap.recycle();
        }
    }

    public static Map<String, String> toMap(JSONObject jSONObject) throws JSONException {
        return i.a(jSONObject);
    }

    public static final class Size {
        private int a;
        private int b;

        private Size() {
        }

        public Size(int n2, int n3) {
            this.a = n2;
            this.b = n3;
        }

        public int getWidth() {
            return this.a;
        }

        public int getHeight() {
            return this.b;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Size)) {
                return false;
            }
            Size size = (Size)object;
            return this.a == size.getWidth() && this.b == size.getHeight();
        }

        public String toString() {
            return this.a + "x" + this.b;
        }

        public int hashCode() {
            return this.b ^ (this.a << 16 | this.a >>> 16);
        }
    }
}

