/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.sdk;

import android.content.Context;
import android.text.TextUtils;
import com.applovin.impl.sdk.j;
import com.applovin.impl.sdk.q;
import com.applovin.impl.sdk.utils.c;
import com.applovin.impl.sdk.utils.e;
import com.applovin.nativeAds.AppLovinNativeAdService;
import com.applovin.sdk.AppLovinAdService;
import com.applovin.sdk.AppLovinEventService;
import com.applovin.sdk.AppLovinPostbackService;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.applovin.sdk.AppLovinSdkSettings;
import com.applovin.sdk.AppLovinUserService;
import com.applovin.sdk.AppLovinVariableService;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AppLovinSdk {
    public static final String VERSION = AppLovinSdk.getVersion();
    public static final int VERSION_CODE = AppLovinSdk.getVersionCode();
    private static final String TAG = "AppLovinSdk";
    private static final Map<String, AppLovinSdk> sdkInstances = new HashMap<String, AppLovinSdk>();
    private static final Object sdkInstancesLock = new Object();
    private final j mSdkImpl;

    public String getSdkKey() {
        return this.mSdkImpl.t();
    }

    public AppLovinSdkSettings getSettings() {
        return this.mSdkImpl.l();
    }

    public void setPluginVersion(String string2) {
        this.mSdkImpl.a(string2);
    }

    public void setMediationProvider(String string2) {
        this.mSdkImpl.c(string2);
    }

    public String getMediationProvider() {
        return this.mSdkImpl.n();
    }

    public AppLovinAdService getAdService() {
        return this.mSdkImpl.o();
    }

    public AppLovinNativeAdService getNativeAdService() {
        return this.mSdkImpl.p();
    }

    public AppLovinPostbackService getPostbackService() {
        return this.mSdkImpl.R();
    }

    public AppLovinEventService getEventService() {
        return this.mSdkImpl.q();
    }

    public AppLovinUserService getUserService() {
        return this.mSdkImpl.r();
    }

    public AppLovinVariableService getVariableService() {
        return this.mSdkImpl.s();
    }

    public void setUserIdentifier(String string2) {
        this.mSdkImpl.b(string2);
    }

    public String getUserIdentifier() {
        return this.mSdkImpl.i();
    }

    public void showMediationDebugger() {
        this.mSdkImpl.h();
    }

    public void initializeSdk() {
    }

    public void initializeSdk(SdkInitializationListener sdkInitializationListener) {
        this.mSdkImpl.a(sdkInitializationListener);
    }

    public static void initializeSdk(Context context) {
        AppLovinSdk.initializeSdk(context, null);
    }

    public static void initializeSdk(Context context, SdkInitializationListener sdkInitializationListener) {
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        AppLovinSdk appLovinSdk = AppLovinSdk.getInstance(context);
        if (appLovinSdk != null) {
            appLovinSdk.initializeSdk(sdkInitializationListener);
        } else {
            q.i(TAG, "Unable to initialize AppLovin SDK: SDK object not created");
        }
    }

    public AppLovinSdkConfiguration getConfiguration() {
        return this.mSdkImpl.m();
    }

    public static AppLovinSdk getInstance(Context context) {
        return AppLovinSdk.getInstance(new a(context), context);
    }

    public static AppLovinSdk getInstance(AppLovinSdkSettings appLovinSdkSettings, Context context) {
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        String string2 = c.a(context).a("applovin.sdk.key", "");
        return AppLovinSdk.getInstance(string2, appLovinSdkSettings, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AppLovinSdk getInstance(String string2, AppLovinSdkSettings appLovinSdkSettings, Context context) {
        if (appLovinSdkSettings == null) {
            throw new IllegalArgumentException("No userSettings specified");
        }
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        Object object = sdkInstancesLock;
        synchronized (object) {
            Object object2;
            if (sdkInstances.containsKey(string2)) {
                return sdkInstances.get(string2);
            }
            if (!TextUtils.isEmpty((CharSequence)string2) && string2.contains(File.separator)) {
                object2 = "\n**************************************************\nINVALID SDK KEY: " + string2 + "\n**************************************************\n";
                q.i(TAG, (String)object2);
                if (!sdkInstances.isEmpty()) {
                    return sdkInstances.values().iterator().next();
                }
                string2 = string2.replace(File.separator, "");
            }
            object2 = new j();
            ((j)object2).a(string2, appLovinSdkSettings, context);
            AppLovinSdk appLovinSdk = new AppLovinSdk((j)object2);
            ((j)object2).a(appLovinSdk);
            sdkInstances.put(string2, appLovinSdk);
            return appLovinSdk;
        }
    }

    public boolean isEnabled() {
        return this.mSdkImpl.d();
    }

    public boolean hasCriticalErrors() {
        return this.mSdkImpl.u();
    }

    @Deprecated
    Context getApplicationContext() {
        return this.mSdkImpl.E();
    }

    @Deprecated
    public q getLogger() {
        return this.mSdkImpl.v();
    }

    private AppLovinSdk(j j2) {
        this.mSdkImpl = j2;
    }

    private static String getVersion() {
        return "9.12.8";
    }

    private static int getVersionCode() {
        return 91208;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reinitializeAll(Boolean bl, Boolean bl2, Boolean bl3) {
        Object object = sdkInstancesLock;
        synchronized (object) {
            for (AppLovinSdk appLovinSdk : sdkInstances.values()) {
                Map<String, String> map;
                appLovinSdk.mSdkImpl.b();
                if (bl != null) {
                    appLovinSdk.mSdkImpl.v().c(TAG, "Toggled 'huc' to " + bl);
                    map = e.a("value", bl.toString());
                    appLovinSdk.getEventService().trackEvent("huc", map);
                }
                if (bl2 != null) {
                    appLovinSdk.mSdkImpl.v().c(TAG, "Toggled 'aru' to " + bl2);
                    map = e.a("value", bl2.toString());
                    appLovinSdk.getEventService().trackEvent("aru", map);
                }
                if (bl3 == null) continue;
                appLovinSdk.mSdkImpl.v().c(TAG, "Toggled 'dns' to " + bl3);
                map = e.a("value", bl3.toString());
                appLovinSdk.getEventService().trackEvent("dns", map);
            }
        }
    }

    public static List<AppLovinSdk> a() {
        return new ArrayList<AppLovinSdk>(sdkInstances.values());
    }

    public String toString() {
        return "AppLovinSdk{sdkKey='" + this.getSdkKey() + "', isEnabled=" + this.isEnabled() + ", isFirstSession=" + this.mSdkImpl.I() + '}';
    }

    private static class a
    extends AppLovinSdkSettings {
        a(Context context) {
            super(context);
        }
    }

    public static interface SdkInitializationListener {
        public void onSdkInitialized(AppLovinSdkConfiguration var1);
    }
}

