/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.mediation;

import android.app.Activity;
import android.text.TextUtils;
import com.applovin.impl.mediation.MaxAdapterParametersImpl;
import com.applovin.impl.mediation.b.b;
import com.applovin.impl.mediation.b.c;
import com.applovin.impl.mediation.b.e;
import com.applovin.impl.mediation.b.f;
import com.applovin.impl.mediation.b.g;
import com.applovin.impl.mediation.c.d;
import com.applovin.impl.mediation.c.h;
import com.applovin.impl.mediation.j;
import com.applovin.impl.sdk.d.s;
import com.applovin.impl.sdk.q;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.sdk.AppLovinSdkUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MediationServiceImpl {
    private final com.applovin.impl.sdk.j a;
    private final q b;

    public MediationServiceImpl(com.applovin.impl.sdk.j j2) {
        this.a = j2;
        this.b = j2.v();
    }

    public void loadAd(String string, MaxAdFormat maxAdFormat, com.applovin.impl.mediation.f f2, Activity activity, MaxAdListener maxAdListener) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("No ad unit ID specified");
        }
        if (activity == null) {
            throw new IllegalArgumentException("No activity specified");
        }
        if (maxAdListener == null) {
            throw new IllegalArgumentException("No listener specified");
        }
        if (!this.a.d()) {
            q.h("AppLovinSdk", "Attempted to load ad before SDK initialization. Please wait until after the SDK has initialized, e.g. AppLovinSdk.initializeSdk(Context, SdkInitializationListener).");
        }
        this.a.a();
        this.a.C().a(string, maxAdFormat, f2, activity, maxAdListener);
    }

    public void showFullscreenAd(MaxAd maxAd, String string, final Activity activity) {
        if (maxAd == null) {
            throw new IllegalArgumentException("No ad specified");
        }
        if (activity == null) {
            throw new IllegalArgumentException("No activity specified");
        }
        if (!(maxAd instanceof c)) {
            q.i("MediationService", "Unable to show ad for '" + maxAd.getAdUnitId() + "': only REWARDED or INTERSTITIAL ads are eligible for showFullscreenAd(). " + maxAd.getFormat() + " ad was provided.");
            throw new IllegalArgumentException("Provided ad is not a MediatedFullscreenAd");
        }
        this.a.Z().a(true);
        final c c2 = (c)maxAd;
        final j j2 = c2.c();
        if (j2 == null) {
            this.a.Z().a(false);
            this.b.d("MediationService", "Failed to show " + maxAd + ": adapter not found");
            q.i("MediationService", "There may be an integration problem with the adapter for ad unit id '" + c2.getAdUnitId() + "'. Please check if you have a supported version of that SDK integrated into your project.");
            throw new IllegalStateException("Could not find adapter for provided ad");
        }
        c2.c(string);
        long l2 = c2.q();
        this.b.c("MediationService", "Showing ad " + maxAd.getAdUnitId() + " with delay of " + l2 + "ms...");
        AppLovinSdkUtils.runOnUiThreadDelayed(new Runnable(){

            @Override
            public void run() {
                if (c2.getFormat() == MaxAdFormat.REWARDED) {
                    h h2 = new h(c2, MediationServiceImpl.this.a);
                    MediationServiceImpl.this.a.L().a(h2, s.a.q);
                }
                j2.a(c2, activity);
                MediationServiceImpl.this.a.Z().a(false);
                MediationServiceImpl.this.b.b("MediationService", "Scheduling impression for ad manually...");
                MediationServiceImpl.this.maybeScheduleRawAdImpressionPostback(c2);
            }
        }, l2);
    }

    public void destroyAd(MaxAd maxAd) {
        if (!(maxAd instanceof com.applovin.impl.mediation.b.a)) {
            return;
        }
        this.b.c("MediationService", "Destroying " + maxAd);
        com.applovin.impl.mediation.b.a a2 = (com.applovin.impl.mediation.b.a)maxAd;
        j j2 = a2.c();
        if (j2 != null) {
            j2.h();
            a2.k();
        }
    }

    public void loadThirdPartyMediatedAd(String string, com.applovin.impl.mediation.b.a a2, Activity activity, MaxAdListener maxAdListener) {
        if (a2 == null) {
            throw new IllegalArgumentException("No mediated ad specified");
        }
        if (activity == null) {
            throw new IllegalArgumentException("A valid Activity is required");
        }
        this.b.b("MediationService", "Loading " + a2 + "...");
        this.a.ac().a(a2, "WILL_LOAD");
        this.a(a2);
        j j2 = this.a.w().a(a2);
        if (j2 != null) {
            MaxAdapterParametersImpl maxAdapterParametersImpl = MaxAdapterParametersImpl.a(a2, activity.getApplicationContext());
            j2.a(maxAdapterParametersImpl, activity);
            com.applovin.impl.mediation.b.a a3 = a2.a(j2);
            j2.a(string, a3);
            a3.g();
            j2.a(string, maxAdapterParametersImpl, a3, activity, new a(a3, maxAdListener));
        } else {
            this.b.d("MediationService", "Failed to load " + a2 + ": adapter not loaded");
            this.a(a2, new com.applovin.impl.mediation.e(-5001), maxAdListener);
        }
    }

    public void collectSignal(MaxAdFormat maxAdFormat, final g g2, Activity activity, final f.a a2) {
        if (g2 == null) {
            throw new IllegalArgumentException("No spec specified");
        }
        if (activity == null) {
            throw new IllegalArgumentException("No activity specified");
        }
        if (a2 == null) {
            throw new IllegalArgumentException("No callback specified");
        }
        final j j2 = this.a.w().a(g2);
        if (j2 != null) {
            MaxAdapterParametersImpl maxAdapterParametersImpl = MaxAdapterParametersImpl.a(g2, maxAdFormat, activity.getApplicationContext());
            j2.a(maxAdapterParametersImpl, activity);
            MaxSignalCollectionListener maxSignalCollectionListener = new MaxSignalCollectionListener(){

                @Override
                public void onSignalCollected(String string) {
                    a2.a(f.a(g2, j2, string));
                }

                @Override
                public void onSignalCollectionFailed(String string) {
                    MediationServiceImpl.this.a(string, g2);
                    a2.a(f.b(g2, j2, string));
                }
            };
            if (g2.b()) {
                if (this.a.x().a(g2)) {
                    this.b.b("MediationService", "Collecting signal for now-initialized adapter: " + j2.b());
                    j2.a(maxAdapterParametersImpl, g2, activity, maxSignalCollectionListener);
                } else {
                    this.b.e("MediationService", "Skip collecting signal for not-initialized adapter: " + j2.b());
                    a2.a(f.a(g2, "Adapter not initialized yet"));
                }
            } else {
                this.b.b("MediationService", "Collecting signal for adapter: " + j2.b());
                j2.a(maxAdapterParametersImpl, g2, activity, maxSignalCollectionListener);
            }
        } else {
            a2.a(f.a(g2, "Could not load adapter"));
        }
    }

    private void a(com.applovin.impl.mediation.b.a a2, com.applovin.impl.mediation.e e2, MaxAdListener maxAdListener) {
        this.a(e2, a2);
        this.destroyAd(a2);
        com.applovin.impl.sdk.utils.j.a(maxAdListener, a2.getAdUnitId(), e2.getErrorCode());
    }

    private void b(com.applovin.impl.mediation.b.a a2, com.applovin.impl.mediation.e e2, MaxAdListener maxAdListener) {
        this.a.ac().a(a2, "DID_FAIL_DISPLAY");
        this.maybeScheduleAdDisplayErrorPostback(e2, a2);
        if (a2.j().compareAndSet(false, true)) {
            com.applovin.impl.sdk.utils.j.a(maxAdListener, (MaxAd)a2, e2.getErrorCode());
        }
    }

    private void a(com.applovin.impl.mediation.b.a a2) {
        this.b.b("MediationService", "Firing ad preload postback for " + a2.E());
        this.a("mpreload", (e)a2);
    }

    private void b(com.applovin.impl.mediation.b.a a2) {
        long l2 = a2.f();
        this.b.b("MediationService", "Firing ad load success postback with load time: " + l2);
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("{LOAD_TIME_MS}", String.valueOf(l2));
        this.a("load", hashMap, a2);
    }

    private void a(com.applovin.impl.mediation.e e2, com.applovin.impl.mediation.b.a a2) {
        long l2 = a2.f();
        this.b.b("MediationService", "Firing ad load failure postback with load time: " + l2);
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("{LOAD_TIME_MS}", String.valueOf(l2));
        this.a("mlerr", hashMap, e2, a2);
    }

    public void maybeScheduleAdapterInitializationPostback(e e2, long l2, MaxAdapter.InitializationStatus initializationStatus, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("{INIT_STATUS}", String.valueOf(initializationStatus.getCode()));
        hashMap.put("{INIT_TIME_MS}", String.valueOf(l2));
        this.a("minit", hashMap, new com.applovin.impl.mediation.e(string), e2);
    }

    public void maybeScheduleRawAdImpressionPostback(com.applovin.impl.mediation.b.a a2) {
        this.a.ac().a(a2, "WILL_DISPLAY");
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        if (a2 instanceof c) {
            c c2 = (c)a2;
            hashMap.put("{TIME_TO_SHOW_MS}", String.valueOf(c2.p()));
        }
        this.a("mimp", hashMap, a2);
    }

    public void maybeScheduleViewabilityAdImpressionPostback(b b2, long l2) {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("{VIEWABILITY_FLAGS}", String.valueOf(l2));
        hashMap.put("{USED_VIEWABILITY_TIMER}", String.valueOf(b2.t()));
        this.a("mvimp", hashMap, b2);
    }

    public void maybeScheduleCallbackAdImpressionPostback(com.applovin.impl.mediation.b.a a2) {
        this.a("mcimp", (e)a2);
    }

    private void c(com.applovin.impl.mediation.b.a a2) {
        this.a("mclick", (e)a2);
    }

    public void maybeScheduleAdDisplayErrorPostback(com.applovin.impl.mediation.e e2, com.applovin.impl.mediation.b.a a2) {
        this.a("mierr", Collections.EMPTY_MAP, e2, a2);
    }

    private void a(String string, g g2) {
        this.a("serr", Collections.EMPTY_MAP, new com.applovin.impl.mediation.e(string), g2);
    }

    private void a(String string, e e2) {
        this.a(string, Collections.EMPTY_MAP, null, e2);
    }

    private void a(String string, Map<String, String> map, e e2) {
        this.a(string, map, null, e2);
    }

    private void a(String string, Map<String, String> map, com.applovin.impl.mediation.e e2, e e3) {
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        hashMap.put("{PLACEMENT}", e3.L() != null ? e3.L() : "");
        d d2 = new d(string, hashMap, e2, e3, this.a);
        this.a.L().a(d2, s.a.m);
    }

    private class a
    implements com.applovin.impl.mediation.d {
        private final com.applovin.impl.mediation.b.a b;
        private MaxAdListener c;

        private a(com.applovin.impl.mediation.b.a a2, MaxAdListener maxAdListener) {
            this.b = a2;
            this.c = maxAdListener;
        }

        @Override
        public void a(MaxAdListener maxAdListener) {
            this.c = maxAdListener;
        }

        @Override
        public void onAdLoaded(MaxAd maxAd) {
            this.b.i();
            MediationServiceImpl.this.b(this.b);
            com.applovin.impl.sdk.utils.j.a(this.c, maxAd);
        }

        @Override
        public void onAdLoadFailed(String string, int n2) {
            this.b.i();
            MediationServiceImpl.this.a(this.b, new com.applovin.impl.mediation.e(n2), this.c);
        }

        @Override
        public void a(String string, com.applovin.impl.mediation.e e2) {
            this.b.i();
            MediationServiceImpl.this.a(this.b, e2, this.c);
        }

        @Override
        public void onAdDisplayed(MaxAd maxAd) {
            MediationServiceImpl.this.b.b("MediationService", "Scheduling impression for ad via callback...");
            MediationServiceImpl.this.maybeScheduleCallbackAdImpressionPostback(this.b);
            if (maxAd.getFormat() == MaxAdFormat.INTERSTITIAL || maxAd.getFormat() == MaxAdFormat.REWARDED) {
                MediationServiceImpl.this.a.Z().a(maxAd);
            }
            com.applovin.impl.sdk.utils.j.b(this.c, maxAd);
        }

        @Override
        public void onAdHidden(final MaxAd maxAd) {
            MediationServiceImpl.this.a.ac().a((com.applovin.impl.mediation.b.a)maxAd, "DID_HIDE");
            long l2 = 0L;
            if (maxAd instanceof c) {
                l2 = ((c)maxAd).r();
            }
            AppLovinSdkUtils.runOnUiThreadDelayed(new Runnable(){

                @Override
                public void run() {
                    if (maxAd.getFormat() == MaxAdFormat.INTERSTITIAL || maxAd.getFormat() == MaxAdFormat.REWARDED) {
                        MediationServiceImpl.this.a.Z().b(maxAd);
                    }
                    com.applovin.impl.sdk.utils.j.c(a.this.c, maxAd);
                }
            }, l2);
        }

        @Override
        public void onAdClicked(MaxAd maxAd) {
            MediationServiceImpl.this.a.ac().a((com.applovin.impl.mediation.b.a)maxAd, "DID_CLICKED");
            MediationServiceImpl.this.c(this.b);
            com.applovin.impl.sdk.utils.j.d(this.c, maxAd);
        }

        @Override
        public void onAdDisplayFailed(MaxAd maxAd, int n2) {
            MediationServiceImpl.this.b(this.b, new com.applovin.impl.mediation.e(n2), this.c);
        }

        @Override
        public void a(MaxAd maxAd, com.applovin.impl.mediation.e e2) {
            MediationServiceImpl.this.b(this.b, e2, this.c);
            if (maxAd.getFormat() == MaxAdFormat.REWARDED && maxAd instanceof c) {
                ((c)maxAd).v();
            }
        }

        @Override
        public void onRewardedVideoStarted(MaxAd maxAd) {
            com.applovin.impl.sdk.utils.j.e(this.c, maxAd);
        }

        @Override
        public void onRewardedVideoCompleted(MaxAd maxAd) {
            com.applovin.impl.sdk.utils.j.f(this.c, maxAd);
        }

        @Override
        public void onUserRewarded(MaxAd maxAd, MaxReward maxReward) {
            com.applovin.impl.sdk.utils.j.a(this.c, maxAd, maxReward);
            com.applovin.impl.mediation.c.g g2 = new com.applovin.impl.mediation.c.g((c)maxAd, MediationServiceImpl.this.a);
            MediationServiceImpl.this.a.L().a(g2, s.a.q);
        }

        @Override
        public void onAdExpanded(MaxAd maxAd) {
            com.applovin.impl.sdk.utils.j.g(this.c, maxAd);
        }

        @Override
        public void onAdCollapsed(MaxAd maxAd) {
            com.applovin.impl.sdk.utils.j.h(this.c, maxAd);
        }
    }
}

