/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.exoplayer2.common.base;

import com.applovin.exoplayer2.common.base.Preconditions;

public final class Ascii {
    public static final byte NUL = 0;
    public static final byte SOH = 1;
    public static final byte STX = 2;
    public static final byte ETX = 3;
    public static final byte EOT = 4;
    public static final byte ENQ = 5;
    public static final byte ACK = 6;
    public static final byte BEL = 7;
    public static final byte BS = 8;
    public static final byte HT = 9;
    public static final byte LF = 10;
    public static final byte NL = 10;
    public static final byte VT = 11;
    public static final byte FF = 12;
    public static final byte CR = 13;
    public static final byte SO = 14;
    public static final byte SI = 15;
    public static final byte DLE = 16;
    public static final byte DC1 = 17;
    public static final byte XON = 17;
    public static final byte DC2 = 18;
    public static final byte DC3 = 19;
    public static final byte XOFF = 19;
    public static final byte DC4 = 20;
    public static final byte NAK = 21;
    public static final byte SYN = 22;
    public static final byte ETB = 23;
    public static final byte CAN = 24;
    public static final byte EM = 25;
    public static final byte SUB = 26;
    public static final byte ESC = 27;
    public static final byte FS = 28;
    public static final byte GS = 29;
    public static final byte RS = 30;
    public static final byte US = 31;
    public static final byte SP = 32;
    public static final byte SPACE = 32;
    public static final byte DEL = 127;
    public static final char MIN = '\u0000';
    public static final char MAX = '\u007f';
    private static final char CASE_MASK = ' ';

    private Ascii() {
    }

    public static String toLowerCase(String object) {
        int n10 = ((String)object).length();
        for (int i10 = 0; i10 < n10; ++i10) {
            if (!Ascii.isUpperCase(((String)object).charAt(i10))) continue;
            object = ((String)object).toCharArray();
            while (i10 < n10) {
                Object object2 = object[i10];
                if (Ascii.isUpperCase((char)object2)) {
                    object[i10] = (char)(object2 ^ 0x20);
                }
                ++i10;
            }
            return String.valueOf((char[])object);
        }
        return object;
    }

    public static String toLowerCase(CharSequence charSequence) {
        if (charSequence instanceof String) {
            return Ascii.toLowerCase((String)charSequence);
        }
        int n10 = charSequence.length();
        char[] cArray = new char[n10];
        for (int i10 = 0; i10 < n10; ++i10) {
            cArray[i10] = Ascii.toLowerCase(charSequence.charAt(i10));
        }
        return String.valueOf(cArray);
    }

    public static char toLowerCase(char c10) {
        if (Ascii.isUpperCase(c10)) {
            c10 = (char)(c10 ^ 0x20);
        }
        return c10;
    }

    public static String toUpperCase(String object) {
        int n10 = ((String)object).length();
        for (int i10 = 0; i10 < n10; ++i10) {
            if (!Ascii.isLowerCase(((String)object).charAt(i10))) continue;
            object = ((String)object).toCharArray();
            while (i10 < n10) {
                Object object2 = object[i10];
                if (Ascii.isLowerCase((char)object2)) {
                    object[i10] = (char)(object2 ^ 0x20);
                }
                ++i10;
            }
            return String.valueOf((char[])object);
        }
        return object;
    }

    public static String toUpperCase(CharSequence charSequence) {
        if (charSequence instanceof String) {
            return Ascii.toUpperCase((String)charSequence);
        }
        int n10 = charSequence.length();
        char[] cArray = new char[n10];
        for (int i10 = 0; i10 < n10; ++i10) {
            cArray[i10] = Ascii.toUpperCase(charSequence.charAt(i10));
        }
        return String.valueOf(cArray);
    }

    public static char toUpperCase(char c10) {
        if (Ascii.isLowerCase(c10)) {
            c10 = (char)(c10 ^ 0x20);
        }
        return c10;
    }

    public static boolean isLowerCase(char c10) {
        return c10 >= 'a' && c10 <= 'z';
    }

    public static boolean isUpperCase(char c10) {
        return c10 >= 'A' && c10 <= 'Z';
    }

    public static String truncate(CharSequence charSequence, int n10, String string2) {
        Preconditions.checkNotNull(charSequence);
        int n11 = n10 - string2.length();
        int n12 = n11 >= 0 ? 1 : 0;
        int n13 = n12;
        n12 = string2.length();
        Preconditions.checkArgument(n13 != 0, "maxLength (%s) must be >= length of the truncation indicator (%s)", n10, n12);
        if (charSequence.length() <= n10 && ((String)(charSequence = charSequence.toString())).length() <= n10) {
            return charSequence;
        }
        return new StringBuilder(n10).append(charSequence, 0, n11).append(string2).toString();
    }

    public static boolean equalsIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        CharSequence charSequence3 = charSequence;
        int n10 = charSequence3.length();
        if (charSequence3 == charSequence2) {
            return true;
        }
        if (n10 != charSequence2.length()) {
            return false;
        }
        for (int i10 = 0; i10 < n10; ++i10) {
            char c10;
            int n11 = charSequence.charAt(i10);
            if (n11 == (c10 = charSequence2.charAt(i10)) || (n11 = Ascii.getAlphaIndex((char)n11)) < 26 && n11 == Ascii.getAlphaIndex(c10)) {
                continue;
            }
            return false;
        }
        return true;
    }

    private static int getAlphaIndex(char c10) {
        return (char)((c10 | 0x20) - 97);
    }
}

