/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Point;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.ImageView;
import androidx.annotation.Dimension;
import androidx.annotation.Nullable;
import com.applovin.impl.qj;
import com.applovin.impl.sdk.utils.CollectionUtils;
import com.applovin.impl.sdk.utils.ImageViewUtils;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sj;
import com.applovin.impl.un;
import com.applovin.impl.x3;
import com.applovin.impl.zp;
import com.applovin.sdk.AppLovinSdk;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class AppLovinSdkUtils {
    private static final Handler a = new Handler(Looper.getMainLooper());

    @Dimension(unit=1)
    public static int dpToPx(Context context, @Dimension(unit=0) int n10) {
        float f10 = n10;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return (int)TypedValue.applyDimension((int)1, (float)f10, (DisplayMetrics)displayMetrics);
    }

    @Dimension(unit=0)
    public static int pxToDp(Context context, @Dimension(unit=1) int n10) {
        return (int)Math.ceil((float)n10 / context.getResources().getDisplayMetrics().density);
    }

    public static boolean isTablet(Context context) {
        Point point = x3.b(context);
        return Math.min(point.x, point.y) >= AppLovinSdkUtils.dpToPx(context, 600);
    }

    public static boolean isEmulator() {
        return AppLovinSdkUtils.a(Build.DEVICE, "goldfish,vbox") || AppLovinSdkUtils.a(Build.HARDWARE, "ranchu,generic,vbox") || AppLovinSdkUtils.a(Build.MANUFACTURER, "Genymotion") || AppLovinSdkUtils.a(Build.MODEL, "Android SDK built for x86");
    }

    private static boolean a(String string2, String string3) {
        return StringUtils.startsWithAtLeastOnePrefix(string2, CollectionUtils.explode(string3));
    }

    public static int getOrientation(Context context) {
        if (context != null && (context = context.getResources()) != null && (context = context.getConfiguration()) != null) {
            return context.orientation;
        }
        return 0;
    }

    public static boolean isValidString(String string2) {
        return TextUtils.isEmpty((CharSequence)string2) ^ true;
    }

    public static void runOnUiThread(Runnable runnable) {
        AppLovinSdkUtils.runOnUiThread(false, runnable);
    }

    public static void runOnUiThread(boolean bl2, Runnable runnable) {
        if (!bl2 && zp.h()) {
            runnable.run();
        } else {
            a.post(runnable);
        }
    }

    public static void runOnUiThreadDelayed(Runnable runnable, long l10) {
        Runnable runnable2 = runnable;
        runnable = a;
        AppLovinSdkUtils.runOnUiThreadDelayed(runnable2, l10, (Handler)runnable);
    }

    public static void runOnUiThreadDelayed(Runnable runnable, long l10, Handler handler) {
        if (l10 > 0L) {
            handler.postDelayed(runnable, l10);
        } else if (zp.h()) {
            runnable.run();
        } else {
            handler.post(runnable);
        }
    }

    public static Map<String, String> toMap(JSONObject jSONObject) throws JSONException {
        return JsonUtils.toStringMap(jSONObject);
    }

    public static boolean isSdkVersionGreaterThanOrEqualTo(String string2) {
        return AppLovinSdk.VERSION_CODE >= zp.f(string2);
    }

    public static boolean isFireOS(Context context) {
        return "amazon".equalsIgnoreCase(Build.MANUFACTURER) || AppLovinSdkUtils.isFireTv(context);
    }

    public static boolean isFireTv(Context context) {
        return context.getPackageManager().hasSystemFeature("amazon.hardware.fire_tv");
    }

    public static boolean isTv(Context context) {
        if (AppLovinSdkUtils.isFireTv(context)) {
            return true;
        }
        context = context.getPackageManager();
        if (x3.f()) {
            return context.hasSystemFeature("android.software.leanback");
        }
        return context.hasSystemFeature("android.hardware.type.television");
    }

    public static void setImageUrl(String string2, ImageView imageView, AppLovinSdk appLovinSdk) {
        string2 = Uri.parse((String)string2);
        ImageViewUtils.setImageUri(imageView, (Uri)string2, appLovinSdk.a());
    }

    @Deprecated
    @Nullable
    public static Boolean getTcfConsentStatus(int n10, Context object) {
        object = PreferenceManager.getDefaultSharedPreferences((Context)object);
        if ((object = (String)sj.a(qj.u, null, (SharedPreferences)object, false)) != null) {
            return un.a((String)object, n10 - 1);
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static Boolean getAdditionalConsentStatus(int n10, Context context) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        return un.a(n10, (String)sj.a(qj.t, null, sharedPreferences, false));
    }

    public static final class Size {
        public static final Size ZERO = new Size(0, 0);
        private int a;
        private int b;

        public Size(int n10, int n11) {
            this.a = n10;
            this.b = n11;
        }

        public int getWidth() {
            return this.a;
        }

        public int getHeight() {
            return this.b;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Size)) {
                return false;
            }
            return this.a == ((Size)(object = (Size)object)).getWidth() && this.b == ((Size)object).getHeight();
        }

        public String toString() {
            return this.a + "x" + this.b;
        }

        public int hashCode() {
            int n10 = this.a;
            return this.b ^ (n10 << 16 | n10 >>> 16);
        }
    }
}

