/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.view.View;
import com.applovin.adview.AppLovinAdView;
import com.applovin.adview.AppLovinAdViewDisplayErrorCode;
import com.applovin.adview.AppLovinAdViewEventListener;
import com.applovin.impl.mb;
import com.applovin.impl.sdk.AppLovinError;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapters.AppLovinMediationAdapter;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;

public class AppLovinAdapterAdViewListener
implements mb,
AppLovinAdDisplayListener,
AppLovinAdClickListener,
AppLovinAdViewEventListener {
    private final AppLovinMediationAdapter parentAdapter;
    private final MaxAdFormat adFormat;
    private final MaxAdViewAdapterListener listener;

    public AppLovinAdapterAdViewListener(AppLovinMediationAdapter appLovinMediationAdapter, MaxAdFormat maxAdFormat, MaxAdViewAdapterListener maxAdViewAdapterListener) {
        this.parentAdapter = appLovinMediationAdapter;
        this.adFormat = maxAdFormat;
        this.listener = maxAdViewAdapterListener;
    }

    @Override
    public void adReceived(AppLovinAd appLovinAd) {
        this.parentAdapter.log(this.adFormat.getLabel() + " ad loaded");
        AppLovinSdkUtils.runOnUiThread(() -> {
            AppLovinAdapterAdViewListener appLovinAdapterAdViewListener = this;
            AppLovinSdk appLovinSdk = this.parentAdapter.getWrappingSdk();
            AppLovinAdSize appLovinAdSize = appLovinAd.getSize();
            appLovinAdapterAdViewListener.parentAdapter.loadedAdView = new AppLovinAdView(appLovinSdk, appLovinAdSize, this.parentAdapter.getApplicationContext());
            appLovinAdapterAdViewListener.parentAdapter.loadedAdView.setAdDisplayListener(this);
            appLovinAdapterAdViewListener.parentAdapter.loadedAdView.setAdClickListener(this);
            appLovinAdapterAdViewListener.parentAdapter.loadedAdView.setAdViewEventListener(this);
            appLovinAdapterAdViewListener.listener.onAdViewAdLoaded((View)this.parentAdapter.loadedAdView);
            appLovinAdapterAdViewListener.parentAdapter.loadedAdView.renderAd(appLovinAd);
        });
    }

    @Override
    public void failedToReceiveAd(int n10) {
        AppLovinError appLovinError;
        AppLovinAdapterAdViewListener appLovinAdapterAdViewListener = appLovinError2;
        AppLovinError appLovinError2 = appLovinError;
        appLovinError = new AppLovinError(n10, "");
        appLovinAdapterAdViewListener.failedToReceiveAdV2(appLovinError2);
    }

    @Override
    public void failedToReceiveAdV2(AppLovinError object) {
        AppLovinAdapterAdViewListener appLovinAdapterAdViewListener = this;
        object = AppLovinMediationAdapter.toMaxError((AppLovinError)object);
        appLovinAdapterAdViewListener.parentAdapter.log(this.adFormat.getLabel() + " ad failed to load with error: " + object);
        appLovinAdapterAdViewListener.listener.onAdViewAdLoadFailed((MaxAdapterError)object);
    }

    @Override
    public void adDisplayed(AppLovinAd appLovinAd) {
        AppLovinAdapterAdViewListener appLovinAdapterAdViewListener = this;
        appLovinAdapterAdViewListener.parentAdapter.log(this.adFormat.getLabel() + " ad shown");
        appLovinAdapterAdViewListener.listener.onAdViewAdDisplayed();
    }

    @Override
    public void adClicked(AppLovinAd appLovinAd) {
        AppLovinAdapterAdViewListener appLovinAdapterAdViewListener = this;
        appLovinAdapterAdViewListener.parentAdapter.log(this.adFormat.getLabel() + " ad clicked");
        appLovinAdapterAdViewListener.listener.onAdViewAdClicked(AppLovinMediationAdapter.getExtraInfo(appLovinAd));
    }

    @Override
    public void adHidden(AppLovinAd appLovinAd) {
        AppLovinAdapterAdViewListener appLovinAdapterAdViewListener = this;
        appLovinAdapterAdViewListener.parentAdapter.log(this.adFormat.getLabel() + " ad hidden");
        appLovinAdapterAdViewListener.listener.onAdViewAdHidden(AppLovinMediationAdapter.getExtraInfo(appLovinAd));
    }

    @Override
    public void adOpenedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
        AppLovinAdapterAdViewListener appLovinAdapterAdViewListener = this;
        appLovinAdapterAdViewListener.parentAdapter.log(this.adFormat.getLabel() + " ad expanded");
        appLovinAdapterAdViewListener.listener.onAdViewAdExpanded();
    }

    @Override
    public void adClosedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
        AppLovinAdapterAdViewListener appLovinAdapterAdViewListener = this;
        appLovinAdapterAdViewListener.parentAdapter.log(this.adFormat.getLabel() + " ad collapsed");
        appLovinAdapterAdViewListener.listener.onAdViewAdCollapsed();
    }

    @Override
    public void adLeftApplication(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
        this.parentAdapter.log(this.adFormat.getLabel() + " ad left application");
    }

    @Override
    public void adFailedToDisplay(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView, AppLovinAdViewDisplayErrorCode appLovinAdViewDisplayErrorCode) {
        AppLovinAdapterAdViewListener appLovinAdapterAdViewListener = this;
        appLovinAdapterAdViewListener.parentAdapter.log(this.adFormat.getLabel() + " failed to display with error code: " + (Object)((Object)appLovinAdViewDisplayErrorCode));
        appLovinAdapterAdViewListener.listener.onAdViewAdDisplayFailed(MaxAdapterError.UNSPECIFIED);
    }
}

