/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.utils;

import android.net.Uri;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final char[] a = "0123456789abcdef".toCharArray();

    public static int parseInt(String string2) {
        return StringUtils.parseInt(string2, 0);
    }

    public static int parseInt(String string2, int n10) {
        if (StringUtils.isNumeric(string2)) {
            n10 = Integer.parseInt(string2);
        }
        return n10;
    }

    public static long parseLong(String string2, long l10) {
        if (StringUtils.isNumeric(string2)) {
            l10 = Long.parseLong(string2);
        }
        return l10;
    }

    public static boolean containsIgnoreCase(String string2, String string3) {
        return StringUtils.isValidString(string2) && StringUtils.isValidString(string3) && string2.toLowerCase().contains(string3.toLowerCase());
    }

    public static boolean isValidString(String string2) {
        return TextUtils.isEmpty((CharSequence)string2) ^ true;
    }

    public static String emptyIfNull(String string2) {
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public static String replace(String string2, String string3, String string4) {
        if (string4 != null) {
            if (string2 != null && string2.length() >= 1) {
                if (string3 != null && string3.length() >= 1) {
                    StringBuilder stringBuilder;
                    StringBuilder stringBuilder2 = stringBuilder;
                    int n10 = new StringBuilder(string2).indexOf(string3);
                    while (n10 != -1) {
                        int n11 = n10;
                        stringBuilder2.replace(n11, n11 + string3.length(), string4);
                        n10 = stringBuilder2.indexOf(string3, n10 + string4.length());
                    }
                    return stringBuilder2.toString();
                }
                return string2;
            }
            return string2;
        }
        throw new IllegalArgumentException("No replacement target specified");
    }

    public static String replace(String object, Map<String, String> object2) {
        if (object != null && object2 != null) {
            object2 = object2.entrySet().iterator();
            while (object2.hasNext()) {
                String string2 = object;
                object = (Map.Entry)object2.next();
                object = string2.replace((CharSequence)object.getKey(), (CharSequence)object.getValue());
            }
            return object;
        }
        return object;
    }

    public static boolean isNumeric(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        int n10 = string2.charAt(0);
        n10 = n10 != 45 && n10 != 43 ? 0 : 1;
        int n11 = string2.length();
        if (n10 == 1 && n11 == 1) {
            return false;
        }
        while (n10 < n11) {
            if (!Character.isDigit(string2.charAt(n10))) {
                return false;
            }
            ++n10;
        }
        return true;
    }

    public static boolean isAlphaNumeric(String string2) {
        if (StringUtils.isValidString(string2)) {
            return string2.matches("^[a-zA-Z0-9]*$");
        }
        return false;
    }

    public static String prefixToIndex(int n10, String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        if (n10 > string2.length()) {
            n10 = string2.length();
        }
        return string2.substring(0, n10);
    }

    public static String encodeUriString(String string2) {
        return StringUtils.isValidString(string2) ? Uri.encode((String)string2) : "";
    }

    public static String appendQueryParameter(String string2, String string3, String string4) {
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
            Uri.Builder builder = Uri.parse((String)string2).buildUpon();
            builder.appendQueryParameter(string3, string4);
            return builder.build().toString();
        }
        return string2;
    }

    public static String appendQueryParameters(String string2, Map<String, String> treeMap, boolean bl2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        if (treeMap != null && !treeMap.isEmpty()) {
            if (bl2) {
                Comparator comparator;
                TreeMap treeMap2;
                TreeMap treeMap3 = treeMap2;
                Comparator comparator2 = comparator;
                comparator = new Comparator(){

                    public int a(String string2, String string3) {
                        return string2.compareToIgnoreCase(string3);
                    }
                };
                new TreeMap(comparator2).putAll(treeMap);
                treeMap = treeMap3;
            }
            string2 = Uri.parse((String)string2).buildUpon();
            for (Map.Entry entry : treeMap.entrySet()) {
                string2.appendQueryParameter((String)entry.getKey(), (String)entry.getValue());
            }
            return string2.build().toString();
        }
        return string2;
    }

    public static String getHost(String string2) {
        return Uri.parse((String)string2).getHost();
    }

    public static String getHostAndPath(String string2) {
        string2 = Uri.parse((String)string2);
        return string2.getHost() + string2.getPath();
    }

    public static String toFullSHA1Hash(String string2) {
        return StringUtils.a(string2, -1);
    }

    public static String toShortSHA1Hash(String string2) {
        return StringUtils.a(string2, 16);
    }

    private static String a(String string2, Integer n10) {
        Throwable throwable2;
        block6: {
            String string3;
            block5: {
                Integer n11;
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    return "";
                }
                try {
                    n11 = n10;
                    MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                    messageDigest.update(string2.getBytes("UTF-8"));
                    string3 = StringUtils.toHexString(messageDigest.digest());
                }
                catch (Throwable throwable2) {}
                if (n11 <= 0) break block5;
                return string3.substring(0, Math.min(n10, string3.length()));
                break block6;
            }
            return string3;
        }
        throw new RuntimeException("SHA-1 for \"" + string2 + "\" failed.", throwable2);
    }

    public static String toHexString(byte[] byArray) {
        if (byArray != null) {
            char[] cArray = new char[byArray.length * 2];
            for (int i10 = 0; i10 < byArray.length; ++i10) {
                int n10 = i10 * 2;
                char[] cArray2 = a;
                byte by = byArray[i10];
                cArray[n10] = cArray2[(by & 0xF0) >>> 4];
                cArray[++n10] = a[by & 0xF];
            }
            return new String(cArray);
        }
        throw new IllegalArgumentException("No data specified");
    }

    public static String toHumanReadableString(String stringArray) {
        StringBuilder stringBuilder;
        if (!StringUtils.isValidString((String)stringArray)) {
            return "";
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(stringArray.length());
        for (String string2 : stringArray.split("_")) {
            if (!StringUtils.isValidString(string2)) continue;
            if (string2.equals("id")) {
                stringBuilder2.append(string2.toUpperCase(Locale.ENGLISH));
            } else {
                Locale locale = Locale.ENGLISH;
                stringBuilder2.append(string2.substring(0, 1).toUpperCase(locale)).append(string2.substring(1).toLowerCase(locale));
            }
            stringBuilder2.append(" ");
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        return stringBuilder3.deleteCharAt(stringBuilder3.length() - 1).toString();
    }

    public static Boolean endsWith(String string2, List<String> object) {
        object = object.iterator();
        while (object.hasNext()) {
            if (!string2.endsWith((String)object.next())) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean containsAtLeastOneSubstring(String string2, List<String> object) {
        object = object.iterator();
        while (object.hasNext()) {
            if (!string2.contains((String)object.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWithAtLeastOnePrefix(String string2, List<String> object) {
        object = object.iterator();
        while (object.hasNext()) {
            if (!string2.startsWith((String)object.next())) continue;
            return true;
        }
        return false;
    }

    public static SpannedString createListItemDetailSpannedString(String string2, int n10) {
        return StringUtils.createSpannedString(string2, n10, 16);
    }

    public static SpannedString createListItemDetailSubSpannedString(String string2, int n10) {
        return StringUtils.createSpannedString(string2, n10, 12, 1);
    }

    public static SpannedString createSpannedString(String string2, int n10, int n11) {
        return StringUtils.createSpannedString(string2, n10, n11, 0);
    }

    public static SpannedString createSpannedString(String string2, int n10, int n11, int n12) {
        StyleSpan styleSpan;
        AbsoluteSizeSpan absoluteSizeSpan;
        ForegroundColorSpan foregroundColorSpan;
        SpannableString spannableString;
        SpannableString spannableString2 = spannableString;
        spannableString = new SpannableString((CharSequence)string2);
        string2 = foregroundColorSpan;
        foregroundColorSpan = new ForegroundColorSpan(n10);
        n10 = spannableString.length();
        spannableString.setSpan((Object)string2, 0, n10, 33);
        string2 = absoluteSizeSpan;
        absoluteSizeSpan = new AbsoluteSizeSpan(n11, true);
        n10 = spannableString.length();
        spannableString.setSpan((Object)string2, 0, n10, 33);
        string2 = styleSpan;
        styleSpan = new StyleSpan(n12);
        n10 = spannableString.length();
        spannableString.setSpan((Object)string2, 0, n10, 33);
        return new SpannedString((CharSequence)spannableString2);
    }

    public static void addLinks(Spannable spannable, Pattern object, ClickableSpan clickableSpan, boolean bl2) {
        object = ((Pattern)object).matcher((CharSequence)spannable);
        while (((Matcher)object).find()) {
            StyleSpan styleSpan;
            Object object2 = object;
            int n10 = ((Matcher)object2).start();
            int n11 = ((Matcher)object2).end();
            spannable.setSpan((Object)clickableSpan, n10, n11, 33);
            if (!bl2) continue;
            StyleSpan styleSpan2 = styleSpan;
            styleSpan = new StyleSpan(1);
            spannable.setSpan((Object)styleSpan2, n10, n11, 256);
        }
    }

    public static String toDigitsOnlyVersionString(String stringArray) {
        ArrayList<String> arrayList;
        if (TextUtils.isEmpty((CharSequence)stringArray)) {
            return "";
        }
        stringArray = stringArray.split("\\.");
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>(stringArray.length);
        for (String string2 : stringArray) {
            String[] stringArray2;
            if (!StringUtils.isValidString(string2) || (stringArray2 = string2.split("[^0-9]+")).length <= 0) continue;
            arrayList2.add(stringArray2[0]);
        }
        return TextUtils.join((CharSequence)".", arrayList2);
    }

    public static String join(CharSequence charSequence, List<?> object) {
        if (object != null && !object.isEmpty()) {
            StringBuilder stringBuilder;
            List<?> list = object;
            object = stringBuilder;
            stringBuilder = new StringBuilder();
            Iterator<?> iterator = list.iterator();
            while (iterator.hasNext()) {
                ((StringBuilder)object).append(iterator.next());
                ((StringBuilder)object).append(charSequence);
            }
            Object object2 = object;
            int n10 = ((StringBuilder)object2).length() - 1 - charSequence.length();
            ((StringBuilder)object2).delete(n10, ((StringBuilder)object2).length());
            return ((StringBuilder)object2).toString();
        }
        return "";
    }

    public static Matcher match(String string2, String string3) {
        return Pattern.compile(string3).matcher(string2);
    }

    public static List<String> getRegexMatches(Matcher matcher, int n10) {
        ArrayList<String> arrayList;
        matcher.reset();
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        while (matcher.find()) {
            String string2 = matcher.group(n10);
            if (!StringUtils.isValidString(string2)) continue;
            arrayList2.add(string2);
        }
        return arrayList2;
    }
}

