/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.exoplayer2.common.base;

import com.applovin.exoplayer2.common.base.Preconditions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class Throwables {
    private static final String JAVA_LANG_ACCESS_CLASSNAME = "sun.misc.JavaLangAccess";
    static final String SHARED_SECRETS_CLASSNAME = "sun.misc.SharedSecrets";
    private static final Object jla;
    private static final Method getStackTraceElementMethod;
    private static final Method getStackTraceDepthMethod;

    private Throwables() {
    }

    public static <X extends Throwable> void throwIfInstanceOf(Throwable throwable, Class<X> clazz) throws X {
        Throwable throwable2 = throwable;
        Preconditions.checkNotNull(throwable2);
        if (!clazz.isInstance(throwable2)) {
            return;
        }
        throw (Throwable)clazz.cast(throwable);
    }

    @Deprecated
    public static <X extends Throwable> void propagateIfInstanceOf(Throwable throwable, Class<X> clazz) throws X {
        if (throwable != null) {
            Throwables.throwIfInstanceOf(throwable, clazz);
        }
    }

    public static void throwIfUnchecked(Throwable throwable) {
        Throwable throwable2 = throwable;
        Preconditions.checkNotNull(throwable2);
        if (!(throwable2 instanceof RuntimeException)) {
            if (!(throwable instanceof Error)) {
                return;
            }
            throw (Error)throwable;
        }
        throw (RuntimeException)throwable;
    }

    @Deprecated
    public static void propagateIfPossible(Throwable throwable) {
        if (throwable != null) {
            Throwables.throwIfUnchecked(throwable);
        }
    }

    public static <X extends Throwable> void propagateIfPossible(Throwable throwable, Class<X> clazz) throws X {
        Throwable throwable2 = throwable;
        Throwables.propagateIfInstanceOf(throwable2, clazz);
        Throwables.propagateIfPossible(throwable2);
    }

    public static <X1 extends Throwable, X2 extends Throwable> void propagateIfPossible(Throwable throwable, Class<X1> clazz, Class<X2> clazz2) throws X1, X2 {
        Throwable throwable2 = throwable;
        Preconditions.checkNotNull(clazz2);
        Throwables.propagateIfInstanceOf(throwable2, clazz);
        Throwables.propagateIfPossible(throwable2, clazz2);
    }

    @Deprecated
    public static RuntimeException propagate(Throwable throwable) {
        Throwables.throwIfUnchecked(throwable);
        throw new RuntimeException(throwable);
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable throwable2;
        boolean bl2;
        boolean bl3 = bl2 = false;
        Throwable throwable3 = throwable;
        while ((throwable2 = throwable.getCause()) != null) {
            if (throwable2 != throwable3) {
                boolean bl4;
                throwable = bl3 ? throwable3.getCause() : throwable3;
                bl3 = bl4 = bl3 ^ true;
                throwable3 = throwable;
                throwable = throwable2;
                continue;
            }
            throw new IllegalArgumentException("Loop in causal chain detected.", throwable2);
        }
        return throwable;
    }

    public static List<Throwable> getCausalChain(Throwable throwable) {
        boolean bl2;
        ArrayList<Throwable> arrayList;
        Preconditions.checkNotNull(throwable);
        ArrayList<Throwable> arrayList2 = arrayList;
        new ArrayList<Throwable>(4).add(throwable);
        boolean bl3 = bl2 = false;
        Throwable throwable2 = throwable;
        while ((throwable = throwable.getCause()) != null) {
            arrayList2.add(throwable);
            if (throwable != throwable2) {
                if (bl3) {
                    throwable2 = throwable2.getCause();
                }
                bl3 ^= true;
                continue;
            }
            throw new IllegalArgumentException("Loop in causal chain detected.", throwable);
        }
        return Collections.unmodifiableList(arrayList2);
    }

    public static <X extends Throwable> X getCauseAs(Throwable throwable, Class<X> clazz) {
        try {
            return (X)((Throwable)clazz.cast(throwable.getCause()));
        }
        catch (ClassCastException classCastException) {
            classCastException.initCause(throwable);
            throw classCastException;
        }
    }

    public static String getStackTraceAsString(Throwable object) {
        StringWriter stringWriter;
        Throwable throwable = object;
        object = stringWriter;
        stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)object));
        return ((StringWriter)object).toString();
    }

    public static List<StackTraceElement> lazyStackTrace(Throwable throwable) {
        return Throwables.lazyStackTraceIsLazy() ? Throwables.jlaStackTrace(throwable) : Collections.unmodifiableList(Arrays.asList(throwable.getStackTrace()));
    }

    public static boolean lazyStackTraceIsLazy() {
        return getStackTraceElementMethod != null && getStackTraceDepthMethod != null;
    }

    private static List<StackTraceElement> jlaStackTrace(final Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        return new AbstractList(){

            @Override
            public StackTraceElement get(int n10) {
                a a10 = objectArray;
                Object[] objectArray = jla;
                Throwable throwable2 = a10.throwable;
                Integer n11 = n10;
                Object[] objectArray2 = objectArray;
                Object[] objectArray3 = new Object[2];
                objectArray = objectArray3;
                objectArray3[0] = throwable2;
                objectArray3[1] = n11;
                return (StackTraceElement)Throwables.invokeAccessibleNonThrowingMethod(getStackTraceElementMethod, objectArray2, objectArray);
            }

            @Override
            public int size() {
                a a10 = objectArray;
                Object[] objectArray = jla;
                Throwable throwable2 = a10.throwable;
                Object[] objectArray2 = objectArray;
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = throwable2;
                return (Integer)Throwables.invokeAccessibleNonThrowingMethod(getStackTraceDepthMethod, objectArray2, objectArray);
            }
        };
    }

    private static Object invokeAccessibleNonThrowingMethod(Method method, Object object, Object ... objectArray) {
        try {
            return method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw Throwables.propagate(invocationTargetException.getCause());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    private static Object getJLA() {
        ThreadDeath threadDeath2;
        block5: {
            Method method = Class.forName(SHARED_SECRETS_CLASSNAME, false, null).getMethod("getJavaLangAccess", new Class[0]);
            try {
                return method.invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
            }
            catch (ThreadDeath threadDeath2) {
                break block5;
            }
            return null;
        }
        throw threadDeath2;
    }

    private static Method getGetMethod() {
        Class[] classArray = new Class[2];
        Class[] classArray2 = classArray;
        classArray[0] = Throwable.class;
        classArray[1] = Integer.TYPE;
        return Throwables.getJlaMethod("getStackTraceElement", classArray2);
    }

    private static Method getSizeMethod() {
        block10: {
            Throwable throwable;
            Object object;
            block9: {
                String string2 = "getStackTraceDepth";
                Class[] classArray = new Class[1];
                classArray[0] = Throwable.class;
                object = Throwables.getJlaMethod(string2, classArray);
                if (object != null) break block9;
                return null;
            }
            Method method = object;
            Method method2 = method;
            Method method3 = method;
            object = Throwables.getJLA();
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            int n10 = 0;
            Throwable throwable2 = throwable;
            try {
                throwable = new Throwable();
                objectArray[n10] = throwable2;
                method2.invoke(object, objectArray2);
            }
            catch (InvocationTargetException invocationTargetException) {
                break block10;
            }
            catch (IllegalAccessException illegalAccessException) {
                break block10;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
            return method3;
        }
        return null;
    }

    private static Method getJlaMethod(String string2, Class<?> ... classArray) throws ThreadDeath {
        ThreadDeath threadDeath2;
        block3: {
            try {
                return Class.forName(JAVA_LANG_ACCESS_CLASSNAME, false, null).getMethod(string2, classArray);
            }
            catch (Throwable throwable) {
            }
            catch (ThreadDeath threadDeath2) {
                break block3;
            }
            return null;
        }
        throw threadDeath2;
    }

    static {
        Object object;
        jla = object = Throwables.getJLA();
        getStackTraceElementMethod = object == null ? null : Throwables.getGetMethod();
        getStackTraceDepthMethod = object == null ? null : Throwables.getSizeMethod();
    }
}

