/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.exoplayer2.common.base;

import com.applovin.exoplayer2.common.base.Function;
import com.applovin.exoplayer2.common.base.Preconditions;
import com.applovin.exoplayer2.common.base.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Predicates {
    private Predicates() {
    }

    public static <T> Predicate<T> alwaysTrue() {
        return h.a.b();
    }

    public static <T> Predicate<T> alwaysFalse() {
        return h.b.b();
    }

    public static <T> Predicate<T> isNull() {
        return h.c.b();
    }

    public static <T> Predicate<T> notNull() {
        return h.d.b();
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return new g(predicate);
    }

    public static <T> Predicate<T> and(Iterable<? extends Predicate<? super T>> iterable) {
        return new b(Predicates.defensiveCopy(iterable));
    }

    @SafeVarargs
    public static <T> Predicate<T> and(Predicate<? super T> ... predicateArray) {
        return new b(Predicates.defensiveCopy(predicateArray));
    }

    public static <T> Predicate<T> and(Predicate<? super T> predicate, Predicate<? super T> predicate2) {
        return new b(Predicates.asList(Preconditions.checkNotNull(predicate), Preconditions.checkNotNull(predicate2)));
    }

    public static <T> Predicate<T> or(Iterable<? extends Predicate<? super T>> iterable) {
        return new i(Predicates.defensiveCopy(iterable));
    }

    @SafeVarargs
    public static <T> Predicate<T> or(Predicate<? super T> ... predicateArray) {
        return new i(Predicates.defensiveCopy(predicateArray));
    }

    public static <T> Predicate<T> or(Predicate<? super T> predicate, Predicate<? super T> predicate2) {
        return new i(Predicates.asList(Preconditions.checkNotNull(predicate), Preconditions.checkNotNull(predicate2)));
    }

    public static <T> Predicate<T> equalTo(@NullableDecl T object) {
        if (object == null) {
            object = Predicates.isNull();
        } else {
            f f10;
            f f11 = f10;
            f10 = new f(object);
            object = f11;
        }
        return object;
    }

    public static Predicate<Object> instanceOf(Class<?> clazz) {
        return new e(clazz);
    }

    public static Predicate<Class<?>> subtypeOf(Class<?> clazz) {
        return new j(clazz);
    }

    public static <T> Predicate<T> in(Collection<? extends T> collection) {
        return new d(collection);
    }

    public static <A, B> Predicate<A> compose(Predicate<B> predicate, Function<A, ? extends B> function) {
        return new c(predicate, function);
    }

    private static String toStringHelper(String charSequence, Iterable<?> iterable) {
        charSequence = new StringBuilder("Predicates.").append((String)charSequence).append('(');
        boolean bl2 = true;
        for (Object obj : iterable) {
            if (!bl2) {
                ((StringBuilder)charSequence).append(',');
            }
            ((StringBuilder)charSequence).append(obj);
            bl2 = false;
        }
        return ((StringBuilder)charSequence).append(')').toString();
    }

    private static <T> List<Predicate<? super T>> asList(Predicate<? super T> predicate, Predicate<? super T> predicate2) {
        return Arrays.asList(predicate, predicate2);
    }

    private static <T> List<T> defensiveCopy(T ... TArray) {
        return Predicates.defensiveCopy(Arrays.asList(TArray));
    }

    static <T> List<T> defensiveCopy(Iterable<T> arrayList) {
        ArrayList arrayList2;
        ArrayList arrayList3 = arrayList;
        arrayList = arrayList2;
        arrayList2 = new ArrayList();
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            arrayList.add(Preconditions.checkNotNull(iterator.next()));
        }
        return arrayList;
    }

    static abstract class h
    extends Enum
    implements Predicate {
        public static final /* enum */ h a = new h(){

            public boolean apply(Object object) {
                return true;
            }

            public String toString() {
                return "Predicates.alwaysTrue()";
            }
        };
        public static final /* enum */ h b = new h(){

            public boolean apply(Object object) {
                return false;
            }

            public String toString() {
                return "Predicates.alwaysFalse()";
            }
        };
        public static final /* enum */ h c = new h(){

            public boolean apply(Object object) {
                return object == null;
            }

            public String toString() {
                return "Predicates.isNull()";
            }
        };
        public static final /* enum */ h d = new h(){

            public boolean apply(Object object) {
                return object != null;
            }

            public String toString() {
                return "Predicates.notNull()";
            }
        };
        private static final /* synthetic */ h[] f;

        public static h[] values() {
            return (h[])f.clone();
        }

        public static h valueOf(String string2) {
            return Enum.valueOf(h.class, string2);
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private h() {
            void var2_-1;
            void var1_-1;
        }

        private static /* synthetic */ h[] a() {
            return new h[]{a, b, c, d};
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        /* synthetic */ h(a a10) {
            this((String)var1_-1, (int)var2_1);
            void var2_1;
            void var1_-1;
        }

        static {
            f = h.a();
        }

        Predicate b() {
            return this;
        }
    }

    private static class g
    implements Predicate,
    Serializable {
        final Predicate a;

        g(Predicate predicate) {
            this.a = Preconditions.checkNotNull(predicate);
        }

        public boolean apply(Object object) {
            return this.a.apply(object) ^ true;
        }

        public int hashCode() {
            return ~this.a.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof g) {
                g g10 = g11;
                g g11 = (g)object;
                return g10.a.equals(g11.a);
            }
            return false;
        }

        public String toString() {
            return "Predicates.not(" + this.a + ")";
        }
    }

    private static class b
    implements Predicate,
    Serializable {
        private final List a;

        private b(List list) {
            this.a = list;
        }

        public boolean apply(Object object) {
            for (int i10 = 0; i10 < this.a.size(); ++i10) {
                if (((Predicate)this.a.get(i10)).apply(object)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.a.hashCode() + 306654252;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof b) {
                b b10 = b11;
                b b11 = (b)object;
                return b10.a.equals(b11.a);
            }
            return false;
        }

        public String toString() {
            return Predicates.toStringHelper("and", this.a);
        }
    }

    private static class i
    implements Predicate,
    Serializable {
        private final List a;

        private i(List list) {
            this.a = list;
        }

        public boolean apply(Object object) {
            for (int i10 = 0; i10 < this.a.size(); ++i10) {
                if (!((Predicate)this.a.get(i10)).apply(object)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.a.hashCode() + 87855567;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof i) {
                i i10 = i11;
                i i11 = (i)object;
                return i10.a.equals(i11.a);
            }
            return false;
        }

        public String toString() {
            return Predicates.toStringHelper("or", this.a);
        }
    }

    private static class f
    implements Predicate,
    Serializable {
        private final Object a;

        private f(Object object) {
            this.a = object;
        }

        public boolean apply(Object object) {
            return this.a.equals(object);
        }

        public int hashCode() {
            return this.a.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof f) {
                f f10 = f11;
                f f11 = (f)object;
                return f10.a.equals(f11.a);
            }
            return false;
        }

        public String toString() {
            return "Predicates.equalTo(" + this.a + ")";
        }
    }

    private static class e
    implements Predicate,
    Serializable {
        private final Class a;

        private e(Class clazz) {
            this.a = Preconditions.checkNotNull(clazz);
        }

        public boolean apply(Object object) {
            return this.a.isInstance(object);
        }

        public int hashCode() {
            return this.a.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof e) {
                e e10 = e11;
                e e11 = (e)object;
                return e10.a == e11.a;
            }
            return false;
        }

        public String toString() {
            return "Predicates.instanceOf(" + this.a.getName() + ")";
        }
    }

    private static class j
    implements Predicate,
    Serializable {
        private final Class a;

        private j(Class clazz) {
            this.a = Preconditions.checkNotNull(clazz);
        }

        public boolean apply(Class clazz) {
            return this.a.isAssignableFrom(clazz);
        }

        public int hashCode() {
            return this.a.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof j) {
                j j10 = j11;
                j j11 = (j)object;
                return j10.a == j11.a;
            }
            return false;
        }

        public String toString() {
            return "Predicates.subtypeOf(" + this.a.getName() + ")";
        }
    }

    private static class d
    implements Predicate,
    Serializable {
        private final Collection a;

        private d(Collection collection) {
            this.a = Preconditions.checkNotNull(collection);
        }

        public boolean apply(Object object) {
            try {
                return this.a.contains(object);
            }
            catch (ClassCastException classCastException) {
            }
            catch (NullPointerException nullPointerException) {}
            return false;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof d) {
                d d10 = d11;
                d d11 = (d)object;
                return d10.a.equals(d11.a);
            }
            return false;
        }

        public int hashCode() {
            return this.a.hashCode();
        }

        public String toString() {
            return "Predicates.in(" + this.a + ")";
        }
    }

    private static class c
    implements Predicate,
    Serializable {
        final Predicate a;
        final Function b;

        private c(Predicate predicate, Function function) {
            this.a = Preconditions.checkNotNull(predicate);
            this.b = Preconditions.checkNotNull(function);
        }

        public boolean apply(Object object) {
            return this.a.apply(this.b.apply(object));
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof c) {
                object = (c)object;
                return this.b.equals(((c)object).b) && this.a.equals(((c)object).a);
            }
            return false;
        }

        public int hashCode() {
            return this.b.hashCode() ^ this.a.hashCode();
        }

        public String toString() {
            return this.a + "(" + this.b + ")";
        }
    }
}

