package com.applovin.sdk;

import com.applovin.impl.sdk.Logger;
import com.applovin.impl.sdk.utils.StringUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import lombok.Getter;

/**
 * Created by Thomas So on October 31 2020
 * <p>
 * User segments  allow us to serve ads using custom-defined rules based on which segment the user is in. For now, we only support a custom string 32 alphanumeric characters or less as the user segment.
 */
@Getter
public class AppLovinUserSegment
{
    private static final String TAG                  = "AppLovinUserSegment";
    private static final int    MAX_CHAR_LENGTH_NAME = 32;

    @Nullable
    private String name;

    public AppLovinUserSegment(final String name)
    {
        this.name = name;
    }

    /**
     * @deprecated Please initialize using {@link AppLovinUserSegment#AppLovinUserSegment(String)} in {@link AppLovinSdkInitializationConfiguration.Builder#setUserSegment(AppLovinUserSegment)}.
     */
    @Deprecated
    public AppLovinUserSegment() {}

    /**
     * Custom segment name with 32 alphanumeric characters or less defined in your AppLovin dashboard.
     *
     * @param name Custom segment name with 32 alphanumeric characters or less defined in your AppLovin dashboard. Can be null.
     *
     * @deprecated This function is deprecated and will be removed in a future SDK version. Please initialize a {@link AppLovinUserSegment} instance using {@link AppLovinUserSegment#AppLovinUserSegment(String)} in {@link AppLovinSdkInitializationConfiguration.Builder#setUserSegment(AppLovinUserSegment)}.
     */
    @Deprecated
    public void setName(@Nullable final String name)
    {
        if ( name != null )
        {
            if ( name.length() > MAX_CHAR_LENGTH_NAME )
            {
                Logger.userError( TAG, "Setting name greater than 32 characters: " + name );
            }

            if ( !StringUtils.isAlphaNumeric( name ) )
            {
                Logger.userError( TAG, "Setting name that is not alphanumeric: " + name );
            }
        }

        this.name = name;
    }

    @Override
    @NonNull
    public String toString()
    {
        return "AppLovinUserSegment{" +
                "name=" + getName() +
                '}';
    }
}
