package com.applovin.mediation;

import androidx.annotation.NonNull;

/**
 * This interface defines a listener intended to be notified when a user watches a rewarded video and whether a reward was granted or rejected.
 */
public interface MaxRewardedAdListener
        extends MaxAdListener
{
    /**
     * This method will be invoked when a user should be granted a reward.
     *
     * @param ad     Ad for which reward ad was rewarded for. Guaranteed not to be null.
     * @param reward The reward to be granted to the user. Guaranteed not to be null.
     */
    void onUserRewarded(@NonNull final MaxAd ad, @NonNull final MaxReward reward);

    /**
     * @deprecated This API is deprecated because not all adapters support this callback. Please use {@link MaxAdListener#onAdDisplayed(MaxAd)} instead.
     */
    @Deprecated
    default void onRewardedVideoStarted(@NonNull final MaxAd ad) { }

    /**
     * @deprecated This API is deprecated because not all adapters support this callback. Please use {@link MaxAdListener#onAdHidden(MaxAd)} instead.
     */
    @Deprecated
    default void onRewardedVideoCompleted(@NonNull final MaxAd ad) { }
}
