/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.sdk;

import a2.h;
import a2.u;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Point;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.ImageView;
import androidx.annotation.Dimension;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.utils.CollectionUtils;
import com.applovin.impl.sdk.utils.ImageViewUtils;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.sdk.AppLovinSdk;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import t1.d;
import x1.e;

public class AppLovinSdkUtils {
    private static final Handler a = new Handler(Looper.getMainLooper());

    @Dimension(unit=1)
    public static int dpToPx(Context context, @Dimension(unit=0) int n2) {
        float f2 = n2;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return (int)TypedValue.applyDimension((int)1, (float)f2, (DisplayMetrics)displayMetrics);
    }

    @Dimension(unit=0)
    public static int pxToDp(Context context, @Dimension(unit=1) int n2) {
        return (int)Math.ceil((float)n2 / context.getResources().getDisplayMetrics().density);
    }

    public static boolean isTablet(Context context) {
        Point point = h.b(context);
        return Math.min(point.x, point.y) >= AppLovinSdkUtils.dpToPx(context, 600);
    }

    public static boolean isEmulator() {
        return AppLovinSdkUtils.a(Build.DEVICE, "goldfish,vbox") || AppLovinSdkUtils.a(Build.HARDWARE, "ranchu,generic,vbox") || AppLovinSdkUtils.a(Build.MANUFACTURER, "Genymotion") || AppLovinSdkUtils.a(Build.MODEL, "Android SDK built for x86");
    }

    private static boolean a(String string2, String string3) {
        return StringUtils.startsWithAtLeastOnePrefix(string2, CollectionUtils.explode(string3));
    }

    public static int getOrientation(Context context) {
        if (context != null && (context = context.getResources()) != null && (context = context.getConfiguration()) != null) {
            return context.orientation;
        }
        return 0;
    }

    public static boolean isValidString(String string2) {
        return TextUtils.isEmpty((CharSequence)string2) ^ true;
    }

    public static void runOnUiThread(Runnable runnable) {
        AppLovinSdkUtils.runOnUiThread(false, runnable);
    }

    public static void runOnUiThread(boolean bl, Runnable runnable) {
        if (!bl && u.h()) {
            runnable.run();
        } else {
            a.post(runnable);
        }
    }

    public static void runOnUiThreadDelayed(Runnable runnable, long l2) {
        Runnable runnable2 = runnable;
        runnable = a;
        AppLovinSdkUtils.runOnUiThreadDelayed(runnable2, l2, (Handler)runnable);
    }

    public static void runOnUiThreadDelayed(Runnable runnable, long l2, Handler handler) {
        if (l2 > 0L) {
            handler.postDelayed(runnable, l2);
        } else if (u.h()) {
            runnable.run();
        } else {
            handler.post(runnable);
        }
    }

    public static Map<String, String> toMap(JSONObject jSONObject) throws JSONException {
        return JsonUtils.toStringMap(jSONObject);
    }

    public static boolean isSdkVersionGreaterThanOrEqualTo(String string2) {
        return AppLovinSdk.VERSION_CODE >= u.f(string2);
    }

    public static boolean isFireOS(Context context) {
        return "amazon".equalsIgnoreCase(Build.MANUFACTURER) || AppLovinSdkUtils.isFireTv(context);
    }

    public static boolean isFireTv(Context context) {
        return context.getPackageManager().hasSystemFeature("amazon.hardware.fire_tv");
    }

    public static boolean isTv(Context context) {
        if (AppLovinSdkUtils.isFireTv(context)) {
            return true;
        }
        context = context.getPackageManager();
        if (h.f()) {
            return context.hasSystemFeature("android.software.leanback");
        }
        return context.hasSystemFeature("android.hardware.type.television");
    }

    public static void setImageUrl(String string2, ImageView imageView, AppLovinSdk appLovinSdk) {
        string2 = Uri.parse((String)string2);
        ImageViewUtils.setImageUri(imageView, (Uri)string2, appLovinSdk.a());
    }

    @Deprecated
    @Nullable
    public static Boolean getTcfConsentStatus(int n2, Context object) {
        object = PreferenceManager.getDefaultSharedPreferences((Context)object);
        if ((object = (String)e.a(x1.d.u, null, (SharedPreferences)object, false)) != null) {
            return d.a((String)object, n2 - 1);
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static Boolean getAdditionalConsentStatus(int n2, Context context) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        return d.a(n2, (String)e.a(x1.d.t, null, sharedPreferences, false));
    }

    public static final class Size {
        public static final Size ZERO = new Size(0, 0);
        private int a;
        private int b;

        public Size(int n2, int n3) {
            this.a = n2;
            this.b = n3;
        }

        public int getWidth() {
            return this.a;
        }

        public int getHeight() {
            return this.b;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Size)) {
                return false;
            }
            return this.a == ((Size)(object = (Size)object)).getWidth() && this.b == ((Size)object).getHeight();
        }

        public String toString() {
            return this.a + "x" + this.b;
        }

        public int hashCode() {
            int n2 = this.a;
            return this.b ^ (n2 << 16 | n2 >>> 16);
        }
    }
}

