/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.nativeAds.adPlacer;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.applovin.impl.sdk.m;
import com.applovin.impl.sdk.w;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.mediation.nativeAds.MaxNativeAdViewBinder;
import com.applovin.mediation.nativeAds.adPlacer.MaxAdPlacerSettings;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import j1.d;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import k1.a;
import k1.b;

public class MaxAdPlacer
implements b.a {
    private AppLovinSdkUtils.Size a;
    private MaxNativeAdViewBinder b;
    private final a c;
    private final b d;
    protected final m sdk;
    protected final w logger;
    private Listener e;

    public MaxAdPlacer(MaxAdPlacerSettings maxAdPlacerSettings, Context context) {
        this(maxAdPlacerSettings, AppLovinSdk.getInstance(context), context);
    }

    public MaxAdPlacer(MaxAdPlacerSettings maxAdPlacerSettings, AppLovinSdk object, Context context) {
        MaxAdPlacer maxAdPlacer = this;
        this.a = AppLovinSdkUtils.Size.ZERO;
        this.sdk = ((AppLovinSdk)object).a();
        object = this.sdk.L();
        maxAdPlacer.logger = object;
        maxAdPlacer.c = new a(maxAdPlacerSettings);
        maxAdPlacer.d = new b(maxAdPlacerSettings, context, this);
        if (w.a()) {
            ((w)object).a("MaxAdPlacer", "Initializing ad placer with settings: " + maxAdPlacerSettings);
        }
    }

    private void a() {
        int n2;
        while (this.d.d() && (n2 = this.c.c()) != -1) {
            if (w.a()) {
                this.logger.a("MaxAdPlacer", "Placing ad at position: " + n2);
            }
            MaxAdPlacer maxAdPlacer = this;
            Object object = maxAdPlacer.d.b();
            maxAdPlacer.c.a((MaxAd)object, n2);
            object = maxAdPlacer.e;
            if (object == null) continue;
            object.onAdLoaded(n2);
        }
    }

    private void a(Collection object, Runnable object2) {
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            MaxAdPlacer maxAdPlacer = this;
            Object object3 = (Integer)iterator.next();
            object3 = maxAdPlacer.c.a((Integer)object3);
            maxAdPlacer.d.a((MaxAd)object3);
        }
        object2.run();
        if (!object.isEmpty()) {
            if (w.a()) {
                this.logger.a("MaxAdPlacer", "Removed " + object.size() + " ads from stream: " + object);
            }
            if (this.e != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    object2 = (Integer)object.next();
                    this.e.onAdRemoved((Integer)object2);
                }
            }
        }
    }

    public void destroy() {
        if (w.a()) {
            this.logger.a("MaxAdPlacer", "Destroying ad placer");
        }
        MaxAdPlacer maxAdPlacer = this;
        maxAdPlacer.clearAds();
        maxAdPlacer.d.c();
    }

    public void setAdSize(int n2, int n3) {
        AppLovinSdkUtils.Size size;
        MaxAdPlacer maxAdPlacer = size2;
        AppLovinSdkUtils.Size size2 = size;
        size = new AppLovinSdkUtils.Size(n2, n3);
        maxAdPlacer.a = size2;
    }

    public void setNativeAdViewBinder(MaxNativeAdViewBinder maxNativeAdViewBinder) {
        this.b = maxNativeAdViewBinder;
    }

    public void setListener(Listener listener) {
        this.e = listener;
    }

    public void loadAds() {
        if (w.a()) {
            this.logger.a("MaxAdPlacer", "Loading ads");
        }
        this.d.e();
    }

    public void clearAds() {
        MaxAdPlacer maxAdPlacer = collection;
        Collection collection = maxAdPlacer.c.b();
        maxAdPlacer.a(collection, () -> {
            if (w.a()) {
                this.logger.a("MaxAdPlacer", "Clearing all cached ads");
            }
            MaxAdPlacer maxAdPlacer = this;
            maxAdPlacer.c.a();
            maxAdPlacer.d.a();
        });
    }

    public Collection<Integer> clearTrailingAds(int n2) {
        Collection collection = this.c.e(n2);
        if (!collection.isEmpty()) {
            MaxAdPlacer maxAdPlacer = this;
            maxAdPlacer.a(collection, () -> {
                if (w.a()) {
                    this.logger.a("MaxAdPlacer", "Clearing trailing ads after position " + n2);
                }
                this.c.a(collection);
            });
        }
        return collection;
    }

    public boolean isAdPosition(int n2) {
        return this.c.g(n2);
    }

    public boolean isFilledPosition(int n2) {
        return this.c.h(n2);
    }

    public long getAdItemId(int n2) {
        if (this.isFilledPosition(n2)) {
            return -System.identityHashCode(this.c.a(n2));
        }
        return 0L;
    }

    public AppLovinSdkUtils.Size getAdSize(int n2, int n3) {
        if (this.isFilledPosition(n2)) {
            AppLovinSdkUtils.Size size = this.a;
            boolean bl = size != AppLovinSdkUtils.Size.ZERO;
            n3 = Math.min(bl ? size.getWidth() : 360, n3);
            d d2 = (d)this.c.a(n2);
            if ("small_template_1".equalsIgnoreCase(d2.o0())) {
                int n4 = bl ? this.a.getHeight() : 120;
                return new AppLovinSdkUtils.Size(n3, n4);
            }
            if ("medium_template_1".equalsIgnoreCase(d2.o0())) {
                double d3 = bl ? (double)this.a.getWidth() / (double)this.a.getHeight() : 1.2;
                int n5 = n3;
                return new AppLovinSdkUtils.Size(n5, (int)((double)n5 / d3));
            }
            if (bl) {
                return this.a;
            }
            if (d2.l0() != null) {
                MaxAdPlacer maxAdPlacer = this = d2.l0().getMainView();
                int n6 = maxAdPlacer.getMeasuredWidth();
                return new AppLovinSdkUtils.Size(n6, maxAdPlacer.getMeasuredHeight());
            }
        }
        return AppLovinSdkUtils.Size.ZERO;
    }

    public void renderAd(int n2, ViewGroup viewGroup) {
        block15: {
            MaxNativeAdView maxNativeAdView;
            block14: {
                MaxNativeAdView maxNativeAdView2;
                MaxAd maxAd;
                block13: {
                    maxAd = this.c.a(n2);
                    if (maxAd == null) {
                        if (w.a()) {
                            this.logger.a("MaxAdPlacer", "An ad is not available for position: " + n2);
                        }
                        return;
                    }
                    maxNativeAdView = ((d)maxAd).l0();
                    if (maxNativeAdView == null) break block13;
                    if (w.a()) {
                        this.logger.a("MaxAdPlacer", "Using pre-rendered ad at position: " + n2);
                    }
                    break block14;
                }
                if (this.b == null) break block15;
                maxNativeAdView = maxNativeAdView2;
                MaxNativeAdViewBinder maxNativeAdViewBinder = this.b;
                maxNativeAdView2 = new MaxNativeAdView(maxNativeAdViewBinder, viewGroup.getContext());
                if (this.d.a(maxNativeAdView, maxAd)) {
                    if (w.a()) {
                        this.logger.a("MaxAdPlacer", "Rendered ad at position: " + n2);
                    }
                } else if (w.a()) {
                    this.logger.b("MaxAdPlacer", "Unable to render ad at position: " + n2);
                }
            }
            for (int i2 = viewGroup.getChildCount(); i2 >= 0; --i2) {
                if (!(viewGroup.getChildAt(i2) instanceof MaxNativeAdView)) continue;
                viewGroup.removeViewAt(i2);
            }
            if (maxNativeAdView.getParent() != null) {
                ((ViewGroup)maxNativeAdView.getParent()).removeView((View)maxNativeAdView);
            }
            viewGroup.addView((View)maxNativeAdView, -1, -1);
            return;
        }
        if (w.a()) {
            this.logger.b("MaxAdPlacer", "Unable to render ad at position: " + n2 + ". If you're using a custom ad template, check that nativeAdViewBinder is set.");
        }
    }

    public void updateFillablePositions(int n2, int n3) {
        this.c.c(n2, n3);
        if (n2 != -1 && n3 != -1) {
            this.a();
        }
    }

    public int getAdjustedCount(int n2) {
        return this.c.b(n2);
    }

    public int getAdjustedPosition(int n2) {
        return this.c.c(n2);
    }

    public int getOriginalPosition(int n2) {
        return this.c.d(n2);
    }

    public void insertItem(int n2) {
        if (w.a()) {
            this.logger.a("MaxAdPlacer", "Inserting item at position: " + n2);
        }
        this.c.f(n2);
    }

    public void removeItem(int n2) {
        List<Object> list = this.isFilledPosition(n2) ? Collections.singletonList(n2) : Collections.emptyList();
        MaxAdPlacer maxAdPlacer = this;
        maxAdPlacer.a(list, () -> {
            if (w.a()) {
                this.logger.a("MaxAdPlacer", "Removing item at position: " + n2);
            }
            this.c.i(n2);
        });
    }

    public void moveItem(int n2, int n3) {
        this.c.b(n2, n3);
    }

    @Override
    public void onNativeAdLoaded() {
        if (w.a()) {
            this.logger.a("MaxAdPlacer", "Native ad enqueued");
        }
        this.a();
    }

    @Override
    public void onNativeAdLoadFailed(String string2, MaxError maxError) {
        if (w.a()) {
            this.logger.b("MaxAdPlacer", "Native ad failed to load: " + maxError);
        }
    }

    @Override
    public void onNativeAdClicked(MaxAd maxAd) {
        Listener listener = ((MaxAdPlacer)((Object)listener)).e;
        if (listener != null) {
            listener.onAdClicked(maxAd);
        }
    }

    @Override
    public void onAdRevenuePaid(MaxAd maxAd) {
        Listener listener = ((MaxAdPlacer)((Object)listener)).e;
        if (listener != null) {
            listener.onAdRevenuePaid(maxAd);
        }
    }

    public static interface Listener {
        public void onAdLoaded(int var1);

        public void onAdRemoved(int var1);

        public void onAdClicked(MaxAd var1);

        public void onAdRevenuePaid(MaxAd var1);
    }
}

