/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import com.applovin.adview.AppLovinAdView;
import com.applovin.adview.AppLovinAdViewDisplayErrorCode;
import com.applovin.adview.AppLovinAdViewEventListener;
import com.applovin.impl.sdk.ad.AppLovinAdImpl;
import com.applovin.impl.sdk.m;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import m1.a;
import org.json.JSONException;
import org.json.JSONObject;

public class NimbusMediationAdapter
extends MediationAdapterBase
implements MaxAdViewAdapter {
    private static final String ADAPTER_VERSION = "1.0.0.0";
    private static final AtomicBoolean initialized = new AtomicBoolean();
    private static a nimbusApiService;
    private static MaxAdapter.InitializationStatus status;
    private AppLovinAdView loadedAdView;

    public NimbusMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
    }

    protected static MaxAdapterError toMaxError(int n2) {
        MaxAdapterError maxAdapterError = n2 == -1009 ? MaxAdapterError.NO_CONNECTION : (n2 == 204 ? MaxAdapterError.NO_FILL : (n2 >= 500 ? MaxAdapterError.SERVER_ERROR : MaxAdapterError.UNSPECIFIED));
        MaxAdapterError maxAdapterError2 = maxAdapterError;
        int n3 = maxAdapterError2.getCode();
        return new MaxAdapterError(n3, maxAdapterError2.getErrorMessage(), n2, "");
    }

    protected static Bundle getExtraInfo(AppLovinAd appLovinAd) {
        Bundle bundle = new Bundle(1);
        bundle.putBundle("ad_values", ((AppLovinAdImpl)appLovinAd).getMAXAdValues());
        return bundle;
    }

    static /* synthetic */ AppLovinAdView access$002(NimbusMediationAdapter nimbusMediationAdapter, AppLovinAdView appLovinAdView) {
        nimbusMediationAdapter.loadedAdView = appLovinAdView;
        return appLovinAdView;
    }

    @Override
    public String getSdkVersion() {
        return "2.0.0";
    }

    @Override
    public String getAdapterVersion() {
        return ADAPTER_VERSION;
    }

    @Override
    public void onDestroy() {
        AppLovinAdView appLovinAdView = this.loadedAdView;
        if (appLovinAdView != null) {
            appLovinAdView.destroy();
            this.loadedAdView = null;
        }
    }

    @Override
    public void initialize(MaxAdapterInitializationParameters maxAdapterInitializationParameters, Activity object, MaxAdapter.OnCompletionListener onCompletionListener) {
        block7: {
            block6: {
                JSONObject jSONObject;
                Object object2;
                if (!initialized.compareAndSet(false, true)) break block6;
                try {
                    object = maxAdapterInitializationParameters.getServerParameters().getString("app_id", "");
                }
                catch (JSONException jSONException) {
                    object2 = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                    status = object2;
                    onCompletionListener.onCompletion((MaxAdapter.InitializationStatus)((Object)object2), "Failed to serialize app id json string.");
                    return;
                }
                JSONObject jSONObject2 = jSONObject;
                jSONObject = new JSONObject((String)object);
                JSONObject jSONObject3 = jSONObject;
                object = JsonUtils.getString(jSONObject, "api_key", null);
                String string2 = JsonUtils.getString(jSONObject3, "pub_id", null);
                String string3 = JsonUtils.getString(jSONObject2, "base_url", null);
                if (TextUtils.isEmpty((CharSequence)object)) {
                    object2 = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                    status = object2;
                    onCompletionListener.onCompletion((MaxAdapter.InitializationStatus)((Object)object2), "API Key cannot be null.");
                    return;
                }
                Object object3 = object2;
                status = MaxAdapter.InitializationStatus.INITIALIZING;
                object2 = ((MediationAdapterBase)object2).getWrappingSdk().a();
                nimbusApiService = new a((String)object, string2, string3, (m)object2);
                nimbusApiService.a(maxAdapterInitializationParameters);
                ((MediationAdapterBase)object3).log("Nimbus API successfully initialized");
                status = MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS;
                break block7;
            }
            onCompletionListener.onCompletion(status, null);
        }
    }

    @Override
    public void loadAdViewAd(MaxAdapterResponseParameters object, MaxAdFormat maxAdFormat, Activity activity, MaxAdViewAdapterListener maxAdViewAdapterListener) {
        NimbusAdapterAdViewListener nimbusAdapterAdViewListener;
        if (nimbusApiService == null) {
            this.log("Nimbus Service is not initialized");
            maxAdViewAdapterListener.onAdViewAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
            return;
        }
        this.log("Loading mediated " + maxAdFormat.getLabel() + " ad: " + object.getThirdPartyAdPlacementId() + "...");
        MaxAdapterResponseParameters maxAdapterResponseParameters = object;
        object = nimbusAdapterAdViewListener;
        NimbusMediationAdapter nimbusMediationAdapter = this;
        nimbusAdapterAdViewListener = nimbusMediationAdapter.new NimbusAdapterAdViewListener(nimbusMediationAdapter, maxAdFormat, maxAdViewAdapterListener);
        nimbusApiService.a(maxAdapterResponseParameters, maxAdFormat, (AppLovinAdLoadListener)object);
    }

    public class NimbusAdapterAdViewListener
    implements AppLovinAdLoadListener,
    AppLovinAdDisplayListener,
    AppLovinAdClickListener,
    AppLovinAdViewEventListener {
        private final NimbusMediationAdapter parentAdapter;
        private final MaxAdFormat adFormat;
        private final MaxAdViewAdapterListener listener;

        public NimbusAdapterAdViewListener(NimbusMediationAdapter nimbusMediationAdapter2, MaxAdFormat maxAdFormat, MaxAdViewAdapterListener maxAdViewAdapterListener) {
            this.parentAdapter = nimbusMediationAdapter2;
            this.adFormat = maxAdFormat;
            this.listener = maxAdViewAdapterListener;
        }

        @Override
        public void adReceived(AppLovinAd appLovinAd) {
            this.parentAdapter.log(this.adFormat.getLabel() + " ad loaded");
            AppLovinSdkUtils.runOnUiThread(() -> {
                NimbusAdapterAdViewListener nimbusAdapterAdViewListener = this;
                AppLovinSdk appLovinSdk = this.parentAdapter.getWrappingSdk();
                AppLovinAdSize appLovinAdSize = appLovinAd.getSize();
                NimbusMediationAdapter.access$002(nimbusAdapterAdViewListener.parentAdapter, new AppLovinAdView(appLovinSdk, appLovinAdSize, this.parentAdapter.getApplicationContext()));
                nimbusAdapterAdViewListener.parentAdapter.loadedAdView.setAdDisplayListener(this);
                nimbusAdapterAdViewListener.parentAdapter.loadedAdView.setAdClickListener(this);
                nimbusAdapterAdViewListener.parentAdapter.loadedAdView.setAdViewEventListener(this);
                nimbusAdapterAdViewListener.listener.onAdViewAdLoaded((View)this.parentAdapter.loadedAdView);
                nimbusAdapterAdViewListener.parentAdapter.loadedAdView.renderAd(appLovinAd);
            });
        }

        @Override
        public void failedToReceiveAd(int n2) {
            NimbusAdapterAdViewListener nimbusAdapterAdViewListener = this;
            MaxAdapterError maxAdapterError = NimbusMediationAdapter.toMaxError(n2);
            nimbusAdapterAdViewListener.parentAdapter.log(this.adFormat.getLabel() + " ad failed to load with error code: " + maxAdapterError);
            nimbusAdapterAdViewListener.listener.onAdViewAdLoadFailed(maxAdapterError);
        }

        @Override
        public void adDisplayed(AppLovinAd appLovinAd) {
            NimbusAdapterAdViewListener nimbusAdapterAdViewListener = this;
            nimbusAdapterAdViewListener.parentAdapter.log(this.adFormat.getLabel() + " ad shown");
            nimbusAdapterAdViewListener.listener.onAdViewAdDisplayed();
        }

        @Override
        public void adClicked(AppLovinAd appLovinAd) {
            NimbusAdapterAdViewListener nimbusAdapterAdViewListener = this;
            nimbusAdapterAdViewListener.parentAdapter.log(this.adFormat.getLabel() + " ad clicked");
            nimbusAdapterAdViewListener.listener.onAdViewAdClicked(NimbusMediationAdapter.getExtraInfo(appLovinAd));
        }

        @Override
        public void adHidden(AppLovinAd appLovinAd) {
            NimbusAdapterAdViewListener nimbusAdapterAdViewListener = this;
            nimbusAdapterAdViewListener.parentAdapter.log(this.adFormat.getLabel() + " ad hidden");
            nimbusAdapterAdViewListener.listener.onAdViewAdHidden(NimbusMediationAdapter.getExtraInfo(appLovinAd));
        }

        @Override
        public void adOpenedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            NimbusAdapterAdViewListener nimbusAdapterAdViewListener = this;
            nimbusAdapterAdViewListener.parentAdapter.log(this.adFormat.getLabel() + " ad expanded");
            nimbusAdapterAdViewListener.listener.onAdViewAdExpanded();
        }

        @Override
        public void adClosedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            NimbusAdapterAdViewListener nimbusAdapterAdViewListener = this;
            nimbusAdapterAdViewListener.parentAdapter.log(this.adFormat.getLabel() + " ad collapsed");
            nimbusAdapterAdViewListener.listener.onAdViewAdCollapsed();
        }

        @Override
        public void adLeftApplication(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            this.parentAdapter.log(this.adFormat.getLabel() + " ad left application");
        }

        @Override
        public void adFailedToDisplay(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView, AppLovinAdViewDisplayErrorCode appLovinAdViewDisplayErrorCode) {
            NimbusAdapterAdViewListener nimbusAdapterAdViewListener = this;
            nimbusAdapterAdViewListener.parentAdapter.log(this.adFormat.getLabel() + " failed to display with error code: " + (Object)((Object)appLovinAdViewDisplayErrorCode));
            nimbusAdapterAdViewListener.listener.onAdViewAdDisplayFailed(MaxAdapterError.UNSPECIFIED);
        }
    }
}

