/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.nativeAd;

import a2.g;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.view.View;
import com.applovin.sdk.AppLovinSdkUtils;
import com.applovin.sdk.R;
import java.util.ArrayList;
import java.util.List;

@SuppressLint(value={"ViewConstructor"})
public class AppLovinStarRatingView
extends View {
    private static final int DEFAULT_TOTAL_NUMBER_OF_STARS = 5;
    private static final int DEFAULT_PADDING_DP = 2;
    private static final float DEFAULT_STROKE_WIDTH = 0.5f;
    private static final float SUM_OF_CENTRAL_ANGLES_IN_CIRCLE_RADIANS = (float)Math.PI * 2;
    private static final float TWELVE_OCLOCK_POSITION_RADIANS = 4.712389f;
    private static final float INTERNAL_ANGLE_OF_PENTAGON_RADIANS = 1.8849556f;
    private static final Paint emptyStarPaint = new Paint(1);
    private static final Paint filledStarPaint = new Paint(1);
    private final Double starRating;
    private float sideLength;
    private final float paddingDp;
    private final float interStarsSpacingDp;

    public AppLovinStarRatingView(Double d2, Context context) {
        super(context);
        this.starRating = d2;
        this.paddingDp = AppLovinSdkUtils.dpToPx(context, 2);
        this.interStarsSpacingDp = AppLovinSdkUtils.dpToPx(context, 2);
        this.setupPaints();
    }

    private void setupPaints() {
        Paint paint = emptyStarPaint;
        paint.setColor(g.a(R.color.applovin_sdk_starColor, this.getContext()));
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(0.5f);
        Paint paint2 = filledStarPaint;
        paint2.setColor(g.a(R.color.applovin_sdk_starColor, this.getContext()));
        paint2.setStyle(Paint.Style.FILL);
    }

    private void drawEmptyStars(Canvas canvas, Path path) {
        canvas.drawPath(path, emptyStarPaint);
    }

    private void drawFilledStars(Canvas canvas, Path path) {
        if (this.starRating == 0.0) {
            return;
        }
        Canvas canvas2 = canvas;
        AppLovinStarRatingView appLovinStarRatingView = this;
        float f2 = (float)appLovinStarRatingView.roundUpToNearestHalfInt(appLovinStarRatingView.starRating);
        float f3 = f2 / 5.0f;
        f2 = (float)((double)appLovinStarRatingView.paddingDp + Math.ceil(f2 - 1.0f) * (double)this.interStarsSpacingDp);
        canvas2.clipPath(path);
        float f4 = f2 + f3 * 5.0f * this.sideLength;
        f2 = this.getHeight();
        canvas2.drawRect(new RectF(0.0f, 0.0f, f4, f2), filledStarPaint);
    }

    private Path getCombinedPathForAllStarsWithSide(float f2) {
        Path path;
        PointF pointF;
        PointF pointF2 = pointF;
        float f3 = new PointF((float)0.0f, (float)this.paddingDp).x + this.paddingDp;
        Path path2 = path;
        path = new Path();
        for (int i2 = 0; i2 < 5; ++i2) {
            float f4 = f3;
            AppLovinStarRatingView appLovinStarRatingView = this;
            float f5 = pointF2.y;
            float f6 = f5 + f2;
            Path path3 = appLovinStarRatingView.getStarPath(new RectF(f3, f5, f3 += f2, f6));
            f5 = f4 + (f2 + appLovinStarRatingView.interStarsSpacingDp);
            path2.addPath(path3);
            f3 = f5;
        }
        return path2;
    }

    private Path getStarPath(RectF rectF) {
        Path path;
        PointF pointF;
        Object object = pointF;
        RectF rectF2 = rectF;
        float f2 = rectF2.centerX();
        object(f2, rectF2.centerY());
        List<PointF> list = this.getStarPointsOnACircle((PointF)object, (float)((double)rectF.width() * 0.5), 4.712389f);
        rectF = list.get(0);
        object = AppLovinStarRatingView.getMidpointBetweenPoints((PointF)rectF, list.get(1));
        float f3 = (float)((double)AppLovinStarRatingView.getDistanceBetweenPoints((PointF)rectF, (PointF)object) / Math.tan(0.9424778f));
        object = this.getStarPointsOnACircle(pointF, AppLovinStarRatingView.getDistanceBetweenPoints(pointF, (PointF)object) - f3, 5.340708f);
        Path path2 = path;
        RectF rectF3 = rectF;
        path2();
        float f4 = rectF3.x;
        path.moveTo(f4, rectF3.y);
        for (int i2 = 0; i2 < 5; ++i2) {
            PointF pointF2 = list.get(i2);
            PointF pointF3 = (PointF)object.get(i2);
            PointF pointF4 = pointF2;
            float f5 = pointF4.x;
            path2.lineTo(f5, pointF4.y);
            f5 = pointF3.x;
            path2.lineTo(f5, pointF3.y);
        }
        Path path3 = path2;
        path3.close();
        return path3;
    }

    private List<PointF> getStarPointsOnACircle(PointF pointF, float f2, float f3) {
        ArrayList<PointF> arrayList;
        int n2 = 5;
        float f4 = (float)Math.PI * 2 / (float)5;
        ArrayList<PointF> arrayList2 = arrayList;
        arrayList = new ArrayList<PointF>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            float f5 = f3;
            PointF pointF2 = pointF;
            double d2 = f2;
            double d3 = f3;
            f3 = (float)((double)pointF2.x + d2 * Math.cos(d3));
            float f6 = (float)((double)pointF2.y + d2 * Math.sin(d3));
            arrayList2.add(new PointF(f3, f6));
            f3 = f5 + f4;
        }
        return arrayList2;
    }

    private double getTotalHorizontalSpacing() {
        return this.paddingDp * 2.0f + this.interStarsSpacingDp * 4.0f;
    }

    private double roundUpToNearestHalfInt(double d2) {
        return Math.ceil(d2 * 2.0) / 2.0;
    }

    private static PointF getMidpointBetweenPoints(PointF pointF, PointF pointF2) {
        PointF pointF3 = pointF2;
        float f2 = pointF3.x - pointF.x;
        float f3 = pointF3.y - pointF.y;
        return new PointF((float)((double)pointF.x + (double)f2 * 0.5), (float)((double)pointF.y + (double)f3 * 0.5));
    }

    private static float getDistanceBetweenPoints(PointF pointF, PointF pointF2) {
        return (float)Math.sqrt(Math.pow(pointF.x - pointF2.x, 2.0) + Math.pow(pointF.y - pointF2.y, 2.0));
    }

    protected void onDraw(Canvas canvas) {
        float f2;
        float f3;
        if (appLovinStarRatingView3.starRating == null) {
            return;
        }
        AppLovinStarRatingView appLovinStarRatingView = appLovinStarRatingView3;
        int n2 = appLovinStarRatingView.getWidth();
        int n3 = appLovinStarRatingView.getHeight();
        appLovinStarRatingView3.sideLength = f3 = (float)Math.min(((double)n2 - appLovinStarRatingView3.getTotalHorizontalSpacing()) / 5.0, (double)((float)n3 - appLovinStarRatingView3.paddingDp * 2.0f));
        if (f2 <= 0.0f) {
            return;
        }
        AppLovinStarRatingView appLovinStarRatingView2 = appLovinStarRatingView3;
        AppLovinStarRatingView appLovinStarRatingView3 = appLovinStarRatingView2.getCombinedPathForAllStarsWithSide(f3);
        appLovinStarRatingView2.drawEmptyStars(canvas, (Path)appLovinStarRatingView3);
        appLovinStarRatingView2.drawFilledStars(canvas, (Path)appLovinStarRatingView3);
    }
}

