/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.exoplayer2.common.base;

import com.applovin.exoplayer2.common.base.Preconditions;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Strings {
    private Strings() {
    }

    public static String padStart(String string2, int n2, char c2) {
        StringBuilder stringBuilder;
        String string3 = string2;
        Preconditions.checkNotNull(string3);
        if (string3.length() >= n2) {
            return string2;
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(n2);
        for (int i2 = string2.length(); i2 < n2; ++i2) {
            stringBuilder2.append(c2);
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append(string2);
        return stringBuilder3.toString();
    }

    public static String padEnd(String string2, int n2, char c2) {
        StringBuilder stringBuilder;
        String string3 = string2;
        Preconditions.checkNotNull(string3);
        if (string3.length() >= n2) {
            return string2;
        }
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder(n2).append(string2);
        for (int i2 = string2.length(); i2 < n2; ++i2) {
            stringBuilder2.append(c2);
        }
        return stringBuilder2.toString();
    }

    public static String repeat(String object, int n2) {
        Preconditions.checkNotNull(object);
        if (n2 <= 1) {
            Preconditions.checkArgument(n2 >= 0, "invalid count: %s", n2);
            if (n2 == 0) {
                object = "";
            }
            return object;
        }
        int n3 = ((String)object).length();
        long l2 = (long)n3 * (long)n2;
        n2 = (int)l2;
        if ((long)n2 == l2) {
            int n4;
            String string2 = object;
            object = new char[n2];
            string2.getChars(0, n3, (char[])object, 0);
            while (n3 < (n4 = n2 - n3)) {
                int n5 = n3;
                System.arraycopy(object, 0, object, n5, n5);
                n3 <<= 1;
            }
            System.arraycopy(object, 0, object, n3, n4);
            return new String((char[])object);
        }
        throw new ArrayIndexOutOfBoundsException("Required array size too large: " + l2);
    }

    public static String commonPrefix(CharSequence charSequence, CharSequence charSequence2) {
        int n2;
        Preconditions.checkNotNull(charSequence);
        Preconditions.checkNotNull(charSequence2);
        int n3 = Math.min(charSequence.length(), charSequence2.length());
        for (n2 = 0; n2 < n3 && charSequence.charAt(n2) == charSequence2.charAt(n2); ++n2) {
        }
        n3 = n2 - 1;
        if (Strings.validSurrogatePairAt(charSequence, n3) || Strings.validSurrogatePairAt(charSequence2, n3)) {
            --n2;
        }
        return charSequence.subSequence(0, n2).toString();
    }

    public static String commonSuffix(CharSequence charSequence, CharSequence charSequence2) {
        int n2;
        block4: {
            block3: {
                Preconditions.checkNotNull(charSequence);
                Preconditions.checkNotNull(charSequence2);
                int n3 = Math.min(charSequence.length(), charSequence2.length());
                for (n2 = 0; n2 < n3; ++n2) {
                    CharSequence charSequence3 = charSequence;
                    CharSequence charSequence4 = charSequence2;
                    if (charSequence3.charAt(charSequence3.length() - n2 - 1) != charSequence4.charAt(charSequence4.length() - n2 - 1)) break;
                }
                CharSequence charSequence5 = charSequence;
                if (Strings.validSurrogatePairAt(charSequence5, charSequence5.length() - n2 - 1)) break block3;
                CharSequence charSequence6 = charSequence2;
                if (!Strings.validSurrogatePairAt(charSequence6, charSequence6.length() - n2 - 1)) break block4;
            }
            --n2;
        }
        CharSequence charSequence7 = charSequence;
        int n4 = charSequence7.length() - n2;
        return charSequence7.subSequence(n4, charSequence7.length()).toString();
    }

    static boolean validSurrogatePairAt(CharSequence charSequence, int n2) {
        return n2 >= 0 && n2 <= charSequence.length() - 2 && Character.isHighSurrogate(charSequence.charAt(n2)) && Character.isLowSurrogate(charSequence.charAt(n2 + 1));
    }

    public static String lenientFormat(@NullableDecl String string2, Object ... objectArray) {
        int n2;
        StringBuilder stringBuilder;
        string2 = String.valueOf(string2);
        if (objectArray == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = "(Object[])null";
        } else {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                objectArray[i2] = Strings.lenientToString(objectArray[i2]);
            }
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(string2.length() + objectArray.length * 16);
        int n3 = 0;
        int n4 = 0;
        while (n4 < objectArray.length && (n2 = string2.indexOf("%s", n3)) != -1) {
            stringBuilder2.append(string2, n3, n2);
            stringBuilder2.append(objectArray[n4++]);
            n3 = n2 + 2;
        }
        String string3 = string2;
        stringBuilder2.append(string3, n3, string3.length());
        if (n4 < objectArray.length) {
            stringBuilder2.append(" [");
            int n5 = n4 + 1;
            stringBuilder2.append(objectArray[n4]);
            while (n5 < objectArray.length) {
                stringBuilder2.append(", ");
                stringBuilder2.append(objectArray[n5++]);
            }
            stringBuilder2.append(']');
        }
        return stringBuilder2.toString();
    }

    private static String lenientToString(@NullableDecl Object object) {
        try {
            return String.valueOf(object);
        }
        catch (Exception exception) {
            object = object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
            Logger.getLogger("com.applovin.exoplayer2.common.base.Strings").log(Level.WARNING, "Exception during lenientFormat for " + (String)object, exception);
            return "<" + (String)object + " threw " + exception.getClass().getName() + ">";
        }
    }
}

