/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.exoplayer2.common.base;

import com.applovin.exoplayer2.common.base.Function;
import com.applovin.exoplayer2.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.io.Serializable;
import java.util.Iterator;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class Converter<A, B>
implements Function<A, B> {
    private final boolean handleNullAutomatically;
    @LazyInit
    @MonotonicNonNullDecl
    private transient Converter<B, A> reverse;

    protected Converter() {
        this(true);
    }

    Converter(boolean bl) {
        this.handleNullAutomatically = bl;
    }

    public static <A, B> Converter<A, B> from(Function<? super A, ? extends B> function, Function<? super B, ? extends A> function2) {
        return new c(function, function2);
    }

    public static <T> Converter<T, T> identity() {
        return d.a;
    }

    @ForOverride
    protected abstract B doForward(A var1);

    @ForOverride
    protected abstract A doBackward(B var1);

    @NullableDecl
    @CanIgnoreReturnValue
    public final B convert(@NullableDecl A a2) {
        return this.correctedDoForward(a2);
    }

    @NullableDecl
    B correctedDoForward(@NullableDecl A a2) {
        if (this.handleNullAutomatically) {
            return a2 == null ? null : (B)Preconditions.checkNotNull(this.doForward(a2));
        }
        return this.doForward(a2);
    }

    @NullableDecl
    A correctedDoBackward(@NullableDecl B b2) {
        if (this.handleNullAutomatically) {
            return b2 == null ? null : (A)Preconditions.checkNotNull(this.doBackward(b2));
        }
        return this.doBackward(b2);
    }

    @CanIgnoreReturnValue
    public Iterable<B> convertAll(final Iterable<? extends A> iterable) {
        Preconditions.checkNotNull(iterable, "fromIterable");
        return new Iterable(){

            public Iterator iterator() {
                return new Iterator(){
                    private final Iterator a;
                    {
                        this.a = iterable.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.a.hasNext();
                    }

                    public Object next() {
                        return Converter.this.convert(this.a.next());
                    }

                    @Override
                    public void remove() {
                        this.a.remove();
                    }
                };
            }
        };
    }

    @CanIgnoreReturnValue
    public Converter<B, A> reverse() {
        e e2 = this.reverse;
        if (e2 == null) {
            e e3;
            e2 = e3;
            e3 = new e(this);
            this.reverse = e2;
        }
        return e2;
    }

    public final <C> Converter<A, C> andThen(Converter<B, C> converter) {
        return this.doAndThen(converter);
    }

    <C> Converter<A, C> doAndThen(Converter<B, C> converter) {
        return new b(this, Preconditions.checkNotNull(converter));
    }

    @Override
    @Deprecated
    @NullableDecl
    @CanIgnoreReturnValue
    public final B apply(@NullableDecl A a2) {
        return this.convert(a2);
    }

    @Override
    public boolean equals(@NullableDecl Object object) {
        return super.equals(object);
    }

    private static final class e
    extends Converter
    implements Serializable {
        final Converter a;

        e(Converter converter) {
            this.a = converter;
        }

        protected Object doForward(Object object) {
            throw new AssertionError();
        }

        protected Object doBackward(Object object) {
            throw new AssertionError();
        }

        Object correctedDoForward(Object object) {
            return this.a.correctedDoBackward(object);
        }

        Object correctedDoBackward(Object object) {
            return this.a.correctedDoForward(object);
        }

        public Converter reverse() {
            return this.a;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof e) {
                e e2 = e3;
                e e3 = (e)object;
                return e2.a.equals(e3.a);
            }
            return false;
        }

        public int hashCode() {
            return ~this.a.hashCode();
        }

        public String toString() {
            return this.a + ".reverse()";
        }
    }

    private static final class b
    extends Converter
    implements Serializable {
        final Converter a;
        final Converter b;

        b(Converter converter, Converter converter2) {
            this.a = converter;
            this.b = converter2;
        }

        protected Object doForward(Object object) {
            throw new AssertionError();
        }

        protected Object doBackward(Object object) {
            throw new AssertionError();
        }

        Object correctedDoForward(Object object) {
            return this.b.correctedDoForward(this.a.correctedDoForward(object));
        }

        Object correctedDoBackward(Object object) {
            return this.a.correctedDoBackward(this.b.correctedDoBackward(object));
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof b) {
                object = (b)object;
                return this.a.equals(((b)object).a) && this.b.equals(((b)object).b);
            }
            return false;
        }

        public int hashCode() {
            return this.a.hashCode() * 31 + this.b.hashCode();
        }

        public String toString() {
            return this.a + ".andThen(" + this.b + ")";
        }
    }

    private static final class c
    extends Converter
    implements Serializable {
        private final Function a;
        private final Function b;

        private c(Function function, Function function2) {
            this.a = Preconditions.checkNotNull(function);
            this.b = Preconditions.checkNotNull(function2);
        }

        protected Object doForward(Object object) {
            return this.a.apply(object);
        }

        protected Object doBackward(Object object) {
            return this.b.apply(object);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof c) {
                object = (c)object;
                return this.a.equals(((c)object).a) && this.b.equals(((c)object).b);
            }
            return false;
        }

        public int hashCode() {
            return this.a.hashCode() * 31 + this.b.hashCode();
        }

        public String toString() {
            return "Converter.from(" + this.a + ", " + this.b + ")";
        }
    }

    private static final class d
    extends Converter
    implements Serializable {
        static final d a = new d();

        private d() {
        }

        protected Object doForward(Object object) {
            return object;
        }

        protected Object doBackward(Object object) {
            return object;
        }

        public d reverse() {
            return this;
        }

        Converter doAndThen(Converter converter) {
            return Preconditions.checkNotNull(converter, "otherConverter");
        }

        public String toString() {
            return "Converter.identity()";
        }
    }
}

