/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.exoplayer2.common.base;

import com.applovin.exoplayer2.common.base.Preconditions;
import com.applovin.exoplayer2.common.base.Predicate;
import java.util.Arrays;
import java.util.BitSet;

public abstract class CharMatcher
implements Predicate<Character> {
    public static CharMatcher any() {
        return b.b;
    }

    public static CharMatcher none() {
        return w.b;
    }

    public static CharMatcher whitespace() {
        return a0.c;
    }

    public static CharMatcher breakingWhitespace() {
        return e.a;
    }

    public static CharMatcher ascii() {
        return d.b;
    }

    @Deprecated
    public static CharMatcher digit() {
        return f.d;
    }

    @Deprecated
    public static CharMatcher javaDigit() {
        return n.a;
    }

    @Deprecated
    public static CharMatcher javaLetter() {
        return p.a;
    }

    @Deprecated
    public static CharMatcher javaLetterOrDigit() {
        return q.a;
    }

    @Deprecated
    public static CharMatcher javaUpperCase() {
        return s.a;
    }

    @Deprecated
    public static CharMatcher javaLowerCase() {
        return r.a;
    }

    public static CharMatcher javaIsoControl() {
        return o.b;
    }

    @Deprecated
    public static CharMatcher invisible() {
        return j.d;
    }

    @Deprecated
    public static CharMatcher singleWidth() {
        return z.d;
    }

    public static CharMatcher is(char c2) {
        return new k(c2);
    }

    public static CharMatcher isNot(char c2) {
        return new m(c2);
    }

    public static CharMatcher anyOf(CharSequence charSequence) {
        int n2 = charSequence.length();
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    return new c(charSequence);
                }
                return CharMatcher.isEither(charSequence.charAt(0), charSequence.charAt(1));
            }
            return CharMatcher.is(charSequence.charAt(0));
        }
        return CharMatcher.none();
    }

    public static CharMatcher noneOf(CharSequence charSequence) {
        return CharMatcher.anyOf(charSequence).negate();
    }

    public static CharMatcher inRange(char c2, char c3) {
        return new i(c2, c3);
    }

    public static CharMatcher forPredicate(Predicate<? super Character> charMatcher) {
        if (charMatcher instanceof CharMatcher) {
            charMatcher = charMatcher;
        } else {
            h h2;
            h h3 = h2;
            h2 = new h(charMatcher);
            charMatcher = h3;
        }
        return charMatcher;
    }

    protected CharMatcher() {
    }

    private String finishCollapseFrom(CharSequence charSequence, int n2, int n3, char c2, StringBuilder stringBuilder, boolean bl) {
        while (n2 < n3) {
            char c3 = charSequence.charAt(n2);
            if (this.matches(c3)) {
                if (!bl) {
                    stringBuilder.append(c2);
                    bl = true;
                }
            } else {
                stringBuilder.append(c3);
                bl = false;
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    private static String showCharacter(char c2) {
        String string2 = "0123456789ABCDEF";
        char[] cArray = new char[6];
        char[] cArray2 = cArray;
        cArray[0] = 92;
        cArray[1] = 117;
        cArray[2] = '\u0000';
        cArray[3] = '\u0000';
        cArray[4] = '\u0000';
        cArray[5] = '\u0000';
        for (int i2 = 0; i2 < 4; ++i2) {
            char c3 = c2;
            char c4 = c2;
            c2 = (char)(5 - i2);
            cArray2[c2] = string2.charAt(c4 & 0xF);
            c2 = (char)(c3 >> 4);
        }
        return String.copyValueOf(cArray2);
    }

    private static l isEither(char c2, char c3) {
        return new l(c2, c3);
    }

    public abstract boolean matches(char var1);

    public CharMatcher negate() {
        return new u(this);
    }

    public CharMatcher and(CharMatcher charMatcher) {
        return new a(this, charMatcher);
    }

    public CharMatcher or(CharMatcher charMatcher) {
        return new x(this, charMatcher);
    }

    void setBits(BitSet bitSet) {
        for (int i2 = 65535; i2 >= 0; --i2) {
            if (!this.matches((char)i2)) continue;
            bitSet.set(i2);
        }
    }

    public boolean matchesAnyOf(CharSequence charSequence) {
        return this.matchesNoneOf(charSequence) ^ true;
    }

    public boolean matchesAllOf(CharSequence charSequence) {
        for (int i2 = charSequence.length() - 1; i2 >= 0; --i2) {
            if (this.matches(charSequence.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public boolean matchesNoneOf(CharSequence charSequence) {
        return this.indexIn(charSequence) == -1;
    }

    public int indexIn(CharSequence charSequence) {
        return this.indexIn(charSequence, 0);
    }

    public int indexIn(CharSequence charSequence, int n2) {
        int n3 = charSequence.length();
        Preconditions.checkPositionIndex(n2, n3);
        while (n2 < n3) {
            if (this.matches(charSequence.charAt(n2))) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int lastIndexIn(CharSequence charSequence) {
        for (int i2 = charSequence.length() - 1; i2 >= 0; --i2) {
            if (!this.matches(charSequence.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    public int countIn(CharSequence charSequence) {
        int n2 = 0;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            if (!this.matches(charSequence.charAt(i2))) continue;
            ++n2;
        }
        return n2;
    }

    public String removeFrom(CharSequence object) {
        int n2 = this.indexIn((CharSequence)(object = object.toString()));
        if (n2 == -1) {
            return object;
        }
        object = ((String)object).toCharArray();
        int n3 = 1;
        block0: while (true) {
            ++n2;
            while (true) {
                if (n2 == ((Object)object).length) {
                    int n4 = n2 - n3;
                    return new String((char[])object, 0, n4);
                }
                if (this.matches((char)object[n2])) {
                    ++n3;
                    continue block0;
                }
                Object object2 = object;
                int n5 = n2 - n3;
                object2[n5] = object2[n2];
                ++n2;
            }
            break;
        }
    }

    public String retainFrom(CharSequence charSequence) {
        return this.negate().removeFrom(charSequence);
    }

    public String replaceFrom(CharSequence object, char c2) {
        int n2 = this.indexIn((CharSequence)(object = object.toString()));
        if (n2 == -1) {
            return object;
        }
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        cArray[n2] = c2;
        ++n2;
        while (n2 < ((Object)object).length) {
            if (this.matches((char)object[n2])) {
                object[n2] = c2;
            }
            ++n2;
        }
        return new String((char[])object);
    }

    public String replaceFrom(CharSequence charSequence, CharSequence charSequence2) {
        StringBuilder stringBuilder;
        int n2 = charSequence2.length();
        if (n2 == 0) {
            return this.removeFrom(charSequence);
        }
        if (n2 == 1) {
            return this.replaceFrom(charSequence, charSequence2.charAt(0));
        }
        n2 = this.indexIn(charSequence = charSequence.toString());
        if (n2 == -1) {
            return charSequence;
        }
        int n3 = ((String)charSequence).length();
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(n3 * 3 / 2 + 16);
        int n4 = 0;
        do {
            StringBuilder stringBuilder3 = stringBuilder2;
            stringBuilder3.append(charSequence, n4, n2);
            stringBuilder3.append(charSequence2);
        } while ((n2 = this.indexIn(charSequence, n4 = n2 + 1)) != -1);
        StringBuilder stringBuilder4 = stringBuilder2;
        stringBuilder4.append(charSequence, n4, n3);
        return stringBuilder4.toString();
    }

    public String trimFrom(CharSequence charSequence) {
        int n2;
        int n3 = charSequence.length();
        for (n2 = 0; n2 < n3 && this.matches(charSequence.charAt(n2)); ++n2) {
        }
        --n3;
        while (n3 > n2 && this.matches(charSequence.charAt(n3))) {
            --n3;
        }
        return charSequence.subSequence(n2, n3 + 1).toString();
    }

    public String trimLeadingFrom(CharSequence charSequence) {
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.matches(charSequence.charAt(i2))) continue;
            return charSequence.subSequence(i2, n2).toString();
        }
        return "";
    }

    public String trimTrailingFrom(CharSequence charSequence) {
        for (int i2 = charSequence.length() - 1; i2 >= 0; --i2) {
            if (this.matches(charSequence.charAt(i2))) continue;
            return charSequence.subSequence(0, i2 + 1).toString();
        }
        return "";
    }

    public String collapseFrom(CharSequence charSequence, char c2) {
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c3 = charSequence.charAt(i2);
            if (!((CharMatcher)((Object)stringBuilder)).matches(c3)) continue;
            if (!(c3 != c2 || i2 != n2 - 1 && ((CharMatcher)((Object)stringBuilder)).matches(charSequence.charAt(i2 + 1)))) {
                ++i2;
                continue;
            }
            CharMatcher charMatcher = stringBuilder;
            StringBuilder stringBuilder = new StringBuilder(n2).append(charSequence, 0, i2).append(c2);
            return charMatcher.finishCollapseFrom(charSequence, i2 + 1, n2, c2, stringBuilder, true);
        }
        return charSequence.toString();
    }

    public String trimAndCollapseFrom(CharSequence charSequence, char c2) {
        String string2;
        int n2;
        int n3 = charSequence.length();
        int n4 = n3 - 1;
        for (n2 = 0; n2 < n3 && this.matches(charSequence.charAt(n2)); ++n2) {
        }
        for (n3 = n4; n3 > n2 && this.matches(charSequence.charAt(n3)); --n3) {
        }
        if (n2 == 0 && n3 == n4) {
            string2 = this.collapseFrom(charSequence, c2);
        } else {
            StringBuilder stringBuilder;
            CharSequence charSequence2 = charSequence;
            int n5 = n3 + 1;
            charSequence = stringBuilder;
            stringBuilder = new StringBuilder(n5 - n2);
            string2 = this.finishCollapseFrom(charSequence2, n2, n5, c2, (StringBuilder)charSequence, false);
        }
        return string2;
    }

    @Override
    @Deprecated
    public boolean apply(Character c2) {
        return this.matches(c2.charValue());
    }

    public String toString() {
        return super.toString();
    }

    private static final class b
    extends t {
        static final b b = new b();

        private b() {
            super("CharMatcher.any()");
        }

        @Override
        public boolean matches(char c2) {
            return true;
        }

        @Override
        public int indexIn(CharSequence charSequence) {
            return charSequence.length() == 0 ? -1 : 0;
        }

        @Override
        public int indexIn(CharSequence charSequence, int n2) {
            int n3 = n2;
            int n4 = charSequence.length();
            Preconditions.checkPositionIndex(n3, n4);
            if (n3 == n4) {
                n2 = -1;
            }
            return n2;
        }

        @Override
        public int lastIndexIn(CharSequence charSequence) {
            return charSequence.length() - 1;
        }

        @Override
        public boolean matchesAllOf(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return true;
        }

        @Override
        public boolean matchesNoneOf(CharSequence charSequence) {
            return charSequence.length() == 0;
        }

        @Override
        public String removeFrom(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return "";
        }

        @Override
        public String replaceFrom(CharSequence charSequence, char c2) {
            char[] cArray = new char[charSequence.length()];
            Object object = cArray;
            Arrays.fill(cArray, c2);
            return new String((char[])object);
        }

        @Override
        public String replaceFrom(CharSequence charSequence, CharSequence charSequence2) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder(charSequence.length() * charSequence2.length());
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                stringBuilder2.append(charSequence2);
            }
            return stringBuilder2.toString();
        }

        @Override
        public String collapseFrom(CharSequence charSequence, char c2) {
            return charSequence.length() == 0 ? "" : String.valueOf(c2);
        }

        @Override
        public String trimFrom(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return "";
        }

        @Override
        public int countIn(CharSequence charSequence) {
            return charSequence.length();
        }

        @Override
        public CharMatcher and(CharMatcher charMatcher) {
            return Preconditions.checkNotNull(charMatcher);
        }

        @Override
        public CharMatcher or(CharMatcher charMatcher) {
            Preconditions.checkNotNull(charMatcher);
            return this;
        }

        @Override
        public CharMatcher negate() {
            return CharMatcher.none();
        }
    }

    private static final class w
    extends t {
        static final w b = new w();

        private w() {
            super("CharMatcher.none()");
        }

        @Override
        public boolean matches(char c2) {
            return false;
        }

        @Override
        public int indexIn(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return -1;
        }

        @Override
        public int indexIn(CharSequence charSequence, int n2) {
            Preconditions.checkPositionIndex(n2, charSequence.length());
            return -1;
        }

        @Override
        public int lastIndexIn(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return -1;
        }

        @Override
        public boolean matchesAllOf(CharSequence charSequence) {
            return charSequence.length() == 0;
        }

        @Override
        public boolean matchesNoneOf(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return true;
        }

        @Override
        public String removeFrom(CharSequence charSequence) {
            return charSequence.toString();
        }

        @Override
        public String replaceFrom(CharSequence charSequence, char c2) {
            return charSequence.toString();
        }

        @Override
        public String replaceFrom(CharSequence charSequence, CharSequence charSequence2) {
            Preconditions.checkNotNull(charSequence2);
            return charSequence.toString();
        }

        @Override
        public String collapseFrom(CharSequence charSequence, char c2) {
            return charSequence.toString();
        }

        @Override
        public String trimFrom(CharSequence charSequence) {
            return charSequence.toString();
        }

        @Override
        public String trimLeadingFrom(CharSequence charSequence) {
            return charSequence.toString();
        }

        @Override
        public String trimTrailingFrom(CharSequence charSequence) {
            return charSequence.toString();
        }

        @Override
        public int countIn(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return 0;
        }

        @Override
        public CharMatcher and(CharMatcher charMatcher) {
            Preconditions.checkNotNull(charMatcher);
            return this;
        }

        @Override
        public CharMatcher or(CharMatcher charMatcher) {
            return Preconditions.checkNotNull(charMatcher);
        }

        @Override
        public CharMatcher negate() {
            return CharMatcher.any();
        }
    }

    static final class a0
    extends t {
        static final int b = Integer.numberOfLeadingZeros(31);
        static final a0 c = new a0();

        a0() {
            super("CharMatcher.whitespace()");
        }

        @Override
        public boolean matches(char c2) {
            return "\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000".charAt(c2 * 1682554634 >>> b) == c2;
        }

        @Override
        void setBits(BitSet bitSet) {
            for (int i2 = 0; i2 < 32; ++i2) {
                bitSet.set("\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000".charAt(i2));
            }
        }
    }

    private static final class e
    extends CharMatcher {
        static final CharMatcher a = new e();

        private e() {
        }

        @Override
        public boolean matches(char c2) {
            switch (c2) {
                default: {
                    return c2 >= '\u2000' && c2 <= '\u200a';
                }
                case '\u2007': {
                    return false;
                }
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '\u0085': 
                case '\u1680': 
                case '\u2028': 
                case '\u2029': 
                case '\u205f': 
                case '\u3000': 
            }
            return true;
        }

        @Override
        public String toString() {
            return "CharMatcher.breakingWhitespace()";
        }
    }

    private static final class d
    extends t {
        static final d b = new d();

        d() {
            super("CharMatcher.ascii()");
        }

        @Override
        public boolean matches(char c2) {
            return c2 <= '\u007f';
        }
    }

    private static final class f
    extends y {
        static final f d = new f();

        private static char[] b() {
            return "0\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0de6\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1a80\u1a90\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\ua9d0\ua9f0\uaa50\uabf0\uff10".toCharArray();
        }

        private static char[] a() {
            char[] cArray = new char[37];
            for (int i2 = 0; i2 < 37; ++i2) {
                cArray[i2] = (char)("0\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0de6\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1a80\u1a90\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\ua9d0\ua9f0\uaa50\uabf0\uff10".charAt(i2) + 9);
            }
            return cArray;
        }

        private f() {
            f f2 = object;
            Object object = f.a();
            super("CharMatcher.digit()", f.b(), (char[])object);
        }
    }

    private static final class n
    extends CharMatcher {
        static final n a = new n();

        private n() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isDigit(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaDigit()";
        }
    }

    private static final class p
    extends CharMatcher {
        static final p a = new p();

        private p() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isLetter(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaLetter()";
        }
    }

    private static final class q
    extends CharMatcher {
        static final q a = new q();

        private q() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isLetterOrDigit(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaLetterOrDigit()";
        }
    }

    private static final class s
    extends CharMatcher {
        static final s a = new s();

        private s() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isUpperCase(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaUpperCase()";
        }
    }

    private static final class r
    extends CharMatcher {
        static final r a = new r();

        private r() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isLowerCase(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaLowerCase()";
        }
    }

    private static final class o
    extends t {
        static final o b = new o();

        private o() {
            super("CharMatcher.javaIsoControl()");
        }

        @Override
        public boolean matches(char c2) {
            return c2 <= '\u001f' || c2 >= '\u007f' && c2 <= '\u009f';
        }
    }

    private static final class j
    extends y {
        static final j d = new j();

        private j() {
            j j2 = object;
            Object object = " \u00a0\u00ad\u0605\u061c\u06dd\u070f\u08e2\u1680\u180e\u200f\u202f\u2064\u206f\u3000\uf8ff\ufeff\ufffb".toCharArray();
            super("CharMatcher.invisible()", "\u0000\u007f\u00ad\u0600\u061c\u06dd\u070f\u08e2\u1680\u180e\u2000\u2028\u205f\u2066\u3000\ud800\ufeff\ufff9".toCharArray(), (char[])object);
        }
    }

    private static final class z
    extends y {
        static final z d = new z();

        private z() {
            z z2 = object;
            Object object = "\u04f9\u05be\u05ea\u05f4\u06ff\u077f\u0e7f\u20af\u213a\ufdff\ufeff\uffdc".toCharArray();
            super("CharMatcher.singleWidth()", "\u0000\u05be\u05d0\u05f3\u0600\u0750\u0e00\u1e00\u2100\ufb50\ufe70\uff61".toCharArray(), (char[])object);
        }
    }

    private static final class k
    extends g {
        private final char a;

        k(char c2) {
            this.a = c2;
        }

        @Override
        public boolean matches(char c2) {
            return c2 == this.a;
        }

        @Override
        public String replaceFrom(CharSequence charSequence, char c2) {
            return charSequence.toString().replace(this.a, c2);
        }

        @Override
        public CharMatcher and(CharMatcher charMatcher) {
            if (!charMatcher.matches(charMatcher2.a)) {
                CharMatcher charMatcher2 = CharMatcher.none();
            }
            return charMatcher2;
        }

        @Override
        public CharMatcher or(CharMatcher charMatcher) {
            if (!charMatcher.matches(this.a)) {
                charMatcher = super.or(charMatcher);
            }
            return charMatcher;
        }

        @Override
        public CharMatcher negate() {
            return CharMatcher.isNot(this.a);
        }

        @Override
        void setBits(BitSet bitSet) {
            bitSet.set(this.a);
        }

        @Override
        public String toString() {
            return "CharMatcher.is('" + CharMatcher.showCharacter(this.a) + "')";
        }
    }

    private static final class m
    extends g {
        private final char a;

        m(char c2) {
            this.a = c2;
        }

        @Override
        public boolean matches(char c2) {
            return c2 != this.a;
        }

        @Override
        public CharMatcher and(CharMatcher charMatcher) {
            if (charMatcher.matches(this.a)) {
                charMatcher = super.and(charMatcher);
            }
            return charMatcher;
        }

        @Override
        public CharMatcher or(CharMatcher charMatcher) {
            if (charMatcher.matches(charMatcher2.a)) {
                CharMatcher charMatcher2 = CharMatcher.any();
            }
            return charMatcher2;
        }

        @Override
        void setBits(BitSet bitSet) {
            bitSet.set(0, this.a);
            bitSet.set(this.a + '\u0001', 65536);
        }

        @Override
        public CharMatcher negate() {
            return CharMatcher.is(this.a);
        }

        @Override
        public String toString() {
            return "CharMatcher.isNot('" + CharMatcher.showCharacter(this.a) + "')";
        }
    }

    private static final class l
    extends g {
        private final char a;
        private final char b;

        l(char c2, char c3) {
            this.a = c2;
            this.b = c3;
        }

        @Override
        public boolean matches(char c2) {
            return c2 == this.a || c2 == this.b;
        }

        @Override
        void setBits(BitSet bitSet) {
            bitSet.set(this.a);
            bitSet.set(this.b);
        }

        @Override
        public String toString() {
            return "CharMatcher.anyOf(\"" + CharMatcher.showCharacter(this.a) + CharMatcher.showCharacter(this.b) + "\")";
        }
    }

    private static final class c
    extends CharMatcher {
        private final char[] a;

        public c(CharSequence charSequence) {
            this.a = charSequence.toString().toCharArray();
            Arrays.sort(this.a);
        }

        @Override
        public boolean matches(char c2) {
            return Arrays.binarySearch(this.a, c2) >= 0;
        }

        @Override
        void setBits(BitSet bitSet) {
            Object object = ((c)object).a;
            int n2 = ((c)object).a.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                bitSet.set((int)object[i2]);
            }
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder;
            c c2 = stringBuilder2;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder("CharMatcher.anyOf(\"");
            char[] cArray = c2.a;
            int n2 = c2.a.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder2.append(CharMatcher.showCharacter(cArray[i2]));
            }
            Object object = stringBuilder2;
            ((StringBuilder)object).append("\")");
            return ((StringBuilder)object).toString();
        }
    }

    private static final class i
    extends g {
        private final char a;
        private final char b;

        i(char c2, char c3) {
            Preconditions.checkArgument(c3 >= c2);
            i i2 = this;
            i2.a = c2;
            i2.b = c3;
        }

        @Override
        public boolean matches(char c2) {
            return this.a <= c2 && c2 <= this.b;
        }

        @Override
        void setBits(BitSet bitSet) {
            bitSet.set((int)this.a, this.b + '\u0001');
        }

        @Override
        public String toString() {
            return "CharMatcher.inRange('" + CharMatcher.showCharacter(this.a) + "', '" + CharMatcher.showCharacter(this.b) + "')";
        }
    }

    private static final class h
    extends CharMatcher {
        private final Predicate a;

        h(Predicate predicate) {
            this.a = Preconditions.checkNotNull(predicate);
        }

        @Override
        public boolean matches(char c2) {
            return this.a.apply(Character.valueOf(c2));
        }

        @Override
        public boolean apply(Character c2) {
            return this.a.apply(Preconditions.checkNotNull(c2));
        }

        @Override
        public String toString() {
            return "CharMatcher.forPredicate(" + this.a + ")";
        }
    }

    private static class u
    extends CharMatcher {
        final CharMatcher a;

        u(CharMatcher charMatcher) {
            this.a = Preconditions.checkNotNull(charMatcher);
        }

        @Override
        public boolean matches(char c2) {
            return this.a.matches(c2) ^ true;
        }

        @Override
        public boolean matchesAllOf(CharSequence charSequence) {
            return this.a.matchesNoneOf(charSequence);
        }

        @Override
        public boolean matchesNoneOf(CharSequence charSequence) {
            return this.a.matchesAllOf(charSequence);
        }

        @Override
        public int countIn(CharSequence charSequence) {
            return charSequence.length() - this.a.countIn(charSequence);
        }

        @Override
        void setBits(BitSet bitSet) {
            BitSet bitSet2;
            BitSet bitSet3 = bitSet;
            bitSet = bitSet2;
            bitSet();
            this.a.setBits(bitSet);
            bitSet2.flip(0, 65536);
            bitSet3.or(bitSet2);
        }

        @Override
        public CharMatcher negate() {
            return this.a;
        }

        @Override
        public String toString() {
            return this.a + ".negate()";
        }
    }

    private static final class a
    extends CharMatcher {
        final CharMatcher a;
        final CharMatcher b;

        a(CharMatcher charMatcher, CharMatcher charMatcher2) {
            this.a = Preconditions.checkNotNull(charMatcher);
            this.b = Preconditions.checkNotNull(charMatcher2);
        }

        @Override
        public boolean matches(char c2) {
            return this.a.matches(c2) && this.b.matches(c2);
        }

        @Override
        void setBits(BitSet bitSet) {
            BitSet bitSet2;
            BitSet bitSet3;
            BitSet bitSet4 = bitSet;
            bitSet = bitSet3;
            bitSet();
            this.a.setBits(bitSet);
            bitSet = bitSet2;
            bitSet();
            this.b.setBits(bitSet);
            bitSet3.and(bitSet2);
            bitSet4.or(bitSet3);
        }

        @Override
        public String toString() {
            return "CharMatcher.and(" + this.a + ", " + this.b + ")";
        }
    }

    private static final class x
    extends CharMatcher {
        final CharMatcher a;
        final CharMatcher b;

        x(CharMatcher charMatcher, CharMatcher charMatcher2) {
            this.a = Preconditions.checkNotNull(charMatcher);
            this.b = Preconditions.checkNotNull(charMatcher2);
        }

        @Override
        void setBits(BitSet bitSet) {
            x x2 = this;
            x2.a.setBits(bitSet);
            x2.b.setBits(bitSet);
        }

        @Override
        public boolean matches(char c2) {
            return this.a.matches(c2) || this.b.matches(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.or(" + this.a + ", " + this.b + ")";
        }
    }

    private static abstract class y
    extends CharMatcher {
        private final String a;
        private final char[] b;
        private final char[] c;

        y(String string2, char[] cArray, char[] cArray2) {
            this.a = string2;
            this.b = cArray;
            this.c = cArray2;
            Preconditions.checkArgument(cArray.length == cArray2.length);
            int n2 = 0;
            while (n2 < cArray.length) {
                Preconditions.checkArgument(cArray[n2] <= cArray2[n2]);
                int n3 = n2 + 1;
                if (n3 < cArray.length) {
                    Preconditions.checkArgument(cArray2[n2] < cArray[n3]);
                }
                n2 = n3;
            }
        }

        @Override
        public boolean matches(char c2) {
            int n2 = Arrays.binarySearch(this.b, c2);
            if (n2 >= 0) {
                return true;
            }
            return (n2 = ~n2 - 1) >= 0 && c2 <= this.c[n2];
        }

        @Override
        public String toString() {
            return this.a;
        }
    }

    static class v
    extends u {
        v(CharMatcher charMatcher) {
            super(charMatcher);
        }
    }

    static abstract class t
    extends g {
        private final String a;

        t(String string2) {
            this.a = Preconditions.checkNotNull(string2);
        }

        @Override
        public final String toString() {
            return this.a;
        }
    }

    static abstract class g
    extends CharMatcher {
        g() {
        }

        @Override
        public CharMatcher negate() {
            return new v(this);
        }
    }
}

